;;;
;;;  X  Declarations and Coercions
;;;

($ap 1 "Declarations and Coercions")

;;;
;;; ` (THE class-name form) --> <object>
;;;
($ap 2 "the" P.61)
((the <integer> 10) 10 eql)
((the <number> 10) 10 eql)
;;((the <float> 10) 10 eql)	; the consequences are undefined
;;;
($argc the 2 0 0)
($error (the . 1) <error>)
($error (the <integer> 10 . 2) <error>)

;;;
;;; ` (ASSURE class-name form) --> <object>
;;;
($ap 2 "assure" P.61)
((assure <integer> 10) 10 eql)
((assure <number> 10) 10 eql)
($error (assure <float> 10) <domain-error>)
;;;
($argc assure 2 0 0)
($error (assure . 1) <error>)
($error (assure <integer> 10 . 2) <error>)

;;;
;;; ` (CONVERT obj class-name) --> <object>
;;;
($ap 2 "convert" P.62)
((convert 3 <float>) 3.0 eql)
((convert "abc" <general-vector>) #(#\a #\b #\c) equal)
((convert #(a b) <list>) (a b) equal)
;;;
($argc convert 2 0 0)
($error (convert . 1) <error>)
($error (convert 3 <float> . 2) <error>)
;;;
((convert #\a <character>) #\a eql)
((convert #\a <integer>) 97 eql)
($error (convert #\a <float>) <domain-error>)
((let ((x (convert #\a <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "a"))) t)
((let ((x (convert #\A <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "A"))) t)
((let ((x (convert #\space <symbol>)))
   (and (symbolp x) (string= (convert x <string>) " "))) t)
((let ((x (convert #\1 <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "1"))) t)
($error (convert #\a <string>) <domain-error>)
($error (convert #\a <general-vector>) <domain-error>)
($error (convert #\a <list>) <domain-error>)
;;;
((convert 100 <character>) #\d eql)
((convert 100 <integer>) 100 eql)
((convert 100 <float>) 100.0 eql)
($error (convert 100 <symbol>) <domain-error>)
((convert 100 <string>) "100" string=)
($error (convert 100 <general-vector>) <domain-error>)
($error (convert 100 <list>) <domain-error>)
;;;
($error (convert 1234567890 <character>) <domain-error>)
((convert 1234567890 <integer>) 1234567890 eql)
((convert 1234567890 <float>) 1234567890.0 eql)
($error (convert 1234567890 <symbol>) <domain-error>)
((convert 1234567890 <string>) "1234567890" string=)
($error (convert 1234567890 <general-vector>) <domain-error>)
($error (convert 1234567890 <list>) <domain-error>)
;;;
($error (convert 1.23 <character>) <domain-error>)
($error (convert 1.23 <integer>) <domain-error>)
((convert 1.23 <float>) 1.23 eql)
($error (convert 1.23 <symbol>) <domain-error>)
((convert 1.23 <string>) "1.23" string=)
($error (convert 1.23 <general-vector>) <domain-error>)
($error (convert 1.23 <list>) <domain-error>)
;;;
($error (convert 'abc <character>) <domain-error>)
($error (convert 'abc <integer>) <domain-error>)
($error (convert 'abc <float>) <domain-error>)
((convert 'abc <symbol>) abc)
((stringp (convert 'abc <string>)) t)
($error (convert 'abc <general-vector>) <domain-error>)
($error (convert 'abc <list>) <domain-error>)
;;;
($error (convert "" <character>) <domain-error>)
($error (convert "" <integer>) <domain-error>)
($error (convert "" <float>) <domain-error>)
((let ((x (convert "" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) ""))) t)
((convert "" <general-vector>) #() equal)
((convert "" <list>) ())
;;;
($error (convert "abc" <character>) <domain-error>)
($error (convert "abc" <integer>) <domain-error>)
((convert "100" <integer>) 100 eql)
((convert "1234567890" <integer>) 1234567890 eql)
($error (convert "abc" <float>) <domain-error>)
((convert "1.23" <float>) 1.23 eql)
((let ((x (convert "abc" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "abc"))) t)
((let ((x (convert "ABC" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "ABC"))) t)
((let ((x (convert "1" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "1"))) t)
((let ((x (convert "123" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "123"))) t)
((convert "abc" <string>) "abc" string=)
((convert "abc" <list>) (#\a #\b #\c) equal)
;;;
($error (convert "ab c" <character>) <domain-error>)
($error (convert "ab c" <integer>) <domain-error>)
($error (convert "10 0" <integer>) <domain-error>)
($error (convert "123456789 0" <integer>) <domain-error>)
($error (convert "ab c" <float>) <domain-error>)
($error (convert "1.2 3" <float>) <domain-error>)
((let ((x (convert "ab c" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "ab c"))) t)
((let ((x (convert "1 " <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "1 "))) t)
((convert "ab c" <string>) "ab c" string=)
((convert "ab c" <list>) (#\a #\b #\space #\c) equal)
;;;
((let ((x (convert "()" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "()"))) t)
((let ((x (convert "nil" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "nil"))) t)
((let ((x (convert "NIL" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "NIL"))) t)
((convert "()" <list>) (#\( #\)) equal)
((let ((x (convert "t" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "t"))) t)
((let ((x (convert "T" <symbol>)))
   (and (symbolp x) (string= (convert x <string>) "T"))) t)
;;;
($error (convert #() <character>) <domain-error>)
($error (convert #() <integer>) <domain-error>)
($error (convert #() <float>) <domain-error>)
($error (convert #() <symbol>) <domain-error>)
($error (convert #() <string>) <domain-error>)
((convert #() <general-vector>) #() equal)
((convert #() <list>) ())
;;;
($error (convert #(a b c) <character>) <domain-error>)
($error (convert #(a b c) <integer>) <domain-error>)
($error (convert #(a b c) <float>) <domain-error>)
($error (convert #(a b c) <symbol>) <domain-error>)
($error (convert #(a b c) <string>) <domain-error>)
((convert #(a b c) <general-vector>) #(a b c) equal)
((convert #(a b c) <list>) (a b c) equal)
;;;
($error (convert () <character>) <domain-error>)
($error (convert () <integer>) <domain-error>)
($error (convert () <float>) <domain-error>)
;;; ̂Q () V{Ƃ݂Ȃ
;($error (convert () <symbol>) <domain-error>)
;($error (convert () <string>) <domain-error>)
((convert () <symbol>) nil)
((convert () <string>) "NIL" string=)
;;;
((convert () <general-vector>) #() equal)
((convert () <list>) ())
;;;
($error (convert '(a b c) <character>) <domain-error>)
($error (convert '(a b c) <integer>) <domain-error>)
($error (convert '(a b c) <float>) <domain-error>)
($error (convert '(a b c) <symbol>) <domain-error>)
($error (convert '(a b c) <string>) <domain-error>)
((convert '(a b c) <general-vector>) #(a b c) equal)
((convert '(a b c) <list>) (a b c) equal)
