;;;
;;;  PR  List class
;;;
($ap 1 "List class")

;;;
;;; ֐ (CONSP obj) --> boolean
;;;
($ap 2 "consp" P.83)
((consp '(a . b)) t)
((consp '(a b c)) t)
((consp '()) nil)
((consp #(a b)) nil)
;;;
($argc consp 1 0 0)
($predicate consp $cons)
;;;
((consp (create-list 1000 'a)) t)

;;;
;;; ֐ (CONS obj1 obj2) --> <cons>
;;;
($ap 2 "cons" P.84)
((cons 'a '()) (a) equal)
((cons '(a) '(b c d)) ((a) b c d) equal)
((cons "a" '(b c)) ("a" b c) equal)
((cons 'a 3) (a . 3) equal)
((cons '(a b) 'c) ((a b) . c) equal)
;;;
($argc cons 2 0 0)
;;;
((length (cons (create-list 1000 'a) (create-list 1000 'b))) 1001 eql)

;;;
;;; ֐ (CAR cons) --> <object>
;;;
($ap 2 "car" P.84)
($error (car '()) <domain-error>)
((car '(a b c)) a)
((car '((a) b c d)) (a) equal)
((car '(1 . 2)) 1 eql)
;;;
($argc car 1 0 0)
($type car ($cons) :target)
;;;
((car (create-list 1000 'a)) a)

;;;
;;; ֐ (CDR cons) --> <object>
;;;
($ap 2 "cdr" P.84)
($error (cdr '()) <domain-error>)
((cdr '((a) b c d)) (b c d) equal)
((cdr '(1 . 2)) 2 eql)
;;;
($argc cdr 1 0 0)
($type cdr ($cons) :target)
;;;
((length (cdr (create-list 1000 'a))) 999 eql)

;;;
;;; ֐ (SET-CAR obj cons) --> <object>
;;;
($ap 2 "set-car" P.85)
((let ((x (list 'apple 'orange)))
   (list x (car x) (setf (car x) 'banana) x (car x)))
 ((banana orange) apple banana (banana orange) banana)
 equal)
((let ((x (list 'apple 'orange)))
   (list x (car x) (set-car 'banana x) x (car x)))
 ((banana orange) apple banana (banana orange) banana)
 equal)
;;;
($argc set-car 2 0 0)
($type set-car ($cons) 1 :target)
;;;
((let ((x (create-list 1000 'a))) (list (setf (car x) 'b) (car x))) 
 (b b) equal)
((let ((x (create-list 1000 'a))) (list (set-car 'b x) (car x))) 
 (b b) equal)

;;;
;;; ֐ (SET-CDR obj cons) --> <object>
;;;
($ap 2 "set-cdr" P.85)
((let ((x (list 'apple 'orange)))
   (list x (cdr x) (setf (cdr x) 'banana) x (cdr x)))
 ((apple . banana) (orange) banana (apple . banana) banana)
 equal)
((let ((x (list 'apple 'orange)))
   (list x (cdr x) (set-cdr 'banana x) x (cdr x)))
 ((apple . banana) (orange) banana (apple . banana) banana)
 equal)
;;;
($argc set-cdr 2 0 0)
($type set-cdr ($cons) 1 :target)
;;;
((let ((x (create-list 1000 'a))) (list (setf (cdr x) 'b) x)) 
 (b (a . b)) equal)
((let ((x (create-list 1000 'a))) (list (set-cdr 'b x) x)) 
 (b (a . b)) equal)

;;;
;;; ֐ (NULL obj) --> boolean
;;;
($ap 2 "null" P.85)
((null '(a b c)) nil)
((null '()) t)
((null (list)) t)
;;;
($argc null 1 0 0)
($predicate null $null)
;;;
((null (create-list 1000 'a)) nil)

;;;
;;; ֐ (LISTP obj) --> boolean
;;;
($ap 2 "listp" P.86)
((listp '(a b c)) t)
((listp '()) t)
((listp '(a . b)) t)
((let ((x (list 'a))) (setf (cdr x) x) (listp x)) t)
((listp "abc") nil)
((listp #(1 2)) nil)
((listp 'jerome) nil)
;;;
($argc listp 1 0 0)
($predicate listp $cons $null)
;;;
((listp (create-list 1000 'a)) t)

;;;
;;; ֐ (CREATE-LIST i [initial-element]) --> <list>
;;;
($ap 2 "create-list" P.86)
((create-list 3 17) (17 17 17) equal)
((create-list 2 #\a) (#\a #\a) equal)
;;;
($argc create-list 1 1 0)
($type create-list ($integer) :target)
;;;
((create-list 0) ())
((create-list 0 1) ())
($error (create-list -1) <domain-error>)
($error (create-list 1234567890) <storage-exhausted>)
($error (create-list 1000000000000000) <storage-exhausted>)
((length (create-list 1000)) 1000 eql)
((length (create-list 1000 'a)) 1000 eql)

;;;
;;; ֐ (LIST obj*) --> <list>
;;;
($ap 2 "list" P.87)
((list 'a (+ 3 4) 'c) (a 7 c) equal)
((list) nil)
;;;
($argc list 0 0 1)
;;;
((list 1 2 3 4 5 6 7 8 9 10) (1 2 3 4 5 6 7 8 9 10) equal)

;;;
;;; ֐ (REVERSE list) --> <list>
;;;
($ap 2 "reverse" P.87)
((reverse '(a b c d e)) (e d c b a) equal)
((reverse '(a)) (a) equal)
((reverse '()) ())
;;;
($argc reverse 1 0 0)
($type reverse ($cons $null) :target)
;;;
((length (reverse (create-list 1000 'a))) 1000 eql)

;;;
;;; ֐ (NREVERSE list) --> <list>
;;;
($ap 2 "nreverse" P.87)
;;((let* ((x (list 'a 'b)) (y (nreverse x))) (equal x y)) nil)	; IDEF
;;;
($argc nreverse 1 0 0)
($type nreverse ($cons $null) :target)
;;;
((length (nreverse (create-list 1000 'a))) 1000 eql)

;;;
;;; ֐ (APPEND list*) --> <list>
;;;
($ap 2 "append" P.87)
((append '(a b c) '(d e f)) (a b c d e f) equal)
;;;
($argc append 0 0 1)
($type append ($cons $null) :target)
($type append ($cons $null) (quote (a b c)) :target)
($type append ($cons $null) (quote (a b c)) (quote (d e f)) :target)
;;; 0 
((append) ())
;;; 1 
((append ()) ())
((append '(a b c)) (a b c) equal)
((length (append (create-list 1000 'a))) 1000 eql)
;;; 2 
((append () ()) ())
((append () '(a b c)) (a b c) equal)
((append '(a b c) ()) (a b c) equal)
((length (append (create-list 1000 'a) (create-list 1000 'b))) 2000 eql)
;;; 3 
((append () () ()) ())
((append () () '(a b c)) (a b c) equal)
((append () '(a b c) ()) (a b c) equal)
((append '(a b c) () ()) (a b c) equal)
((append '(a b c) '(d e f) ()) (a b c d e f) equal)
((append '(a b c) () '(d e f)) (a b c d e f) equal)
((append () '(a b c) '(d e f)) (a b c d e f) equal)
((length 
  (append (create-list 1000 'a) (create-list 1000 'b) (create-list 1000 'c)))
 3000 eql)
;;; Ō̃XgL
((let* ((x (list 'a 'b 'c))
	(y (append x)))
   (eq y x))
 t)
((let* ((x (list 'a 'b 'c))
	(y (append '(1 2) x)))
   (eq (cdr (cdr y)) x))
 t)
((let* ((x (list 'a 'b 'c))
	(y (append '(1 2) '(3 4) x)))
   (eq (cdr (cdr (cdr (cdr y)))) x))
 t)
((let* ((x (list 'a 'b 'c))
	(y (append '(1 2) x '(3 4))))
   (eq (cdr (cdr y)) x))
  nil)

;;;
;;; ֐ (MEMBER obj list) --> <list>
;;;
($ap 2 "member" P.88)
((member 'c '(a b c d e f)) (c d e f) equal)
((member 'g '(a b c d e f)) nil)
((member 'c '(a b c a b c)) (c a b c) equal)
;;;
($argc member 2 0 0)
($type member ($cons $null) (quote a) :target)
;;;
((member #\b '(#\a #\b #\c)) (#\b #\c) equal)
((member 2 '(1 2 3)) (2 3) equal)
((member -2 '(1 -2 3)) (-2 3) equal)
((member 2.0 '(1 2.0 3)) (2.0 3) equal)
((member -2.0 '(1 -2.0 3)) (-2.0 3) equal)
((member 1234567890 '(1 1234567890 3)) (1234567890 3) equal)
((member -1234567890 '(1 -1234567890 3)) (-1234567890 3) equal)
((member 'a ()) nil)
((length (member 'a (create-list 1000 'a))) 1000 eql)
((member 'b (create-list 1000 'a)) nil)

;;;
;;; ֐ (MAPCAR function list+) --> <list>
;;;
($ap 2 "mapcar" P.88)
((mapcar #'car '((1 a) (2 b) (3 c))) (1 2 3) equal)
((mapcar #'abs '(3 -4 2 -5 -6)) (3 4 2 5 6) equal)
((mapcar #'cons '(a b c) '(1 2 3)) ((a . 1) (b . 2) (c . 3)) equal)
;;;
($argc mapcar 2 0 1)
($type mapcar ($function $generic) :target nil)
($type mapcar ($cons $null) (function list) :target)
($type mapcar ($cons $null) (function list) (quote (a b)) :target)
;;; 1 ֐
((mapcar #'car ()) ())
((mapcar (lambda (x) (car 1)) ()) ())
((mapcar (lambda (x) (+ x 1)) '(1 2 3 4 5)) (2 3 4 5 6) equal)
;;; 2 ֐
((mapcar #'cons () ()) ())
((mapcar #'cons () '(a b c)) ())
((mapcar #'cons '(a b c) ()) ())
((mapcar (lambda (x y) (+ x y)) '(1 2 3 4 5) '(6 7 8 9 10)) 
 (7 9 11 13 15) equal)
;;; rest ֐
((mapcar #'list () () () () ()) ())
((mapcar #'list '(a b c) '(d e f) '(g h i) '(j k l) '(m n o))
 ((a d g j m) (b e h k n) (c f i l o))
 equal)
((mapcar #'list '(a b c) '(d e f) '(g) '(j k l) '(m n o))
 ((a d g j m))
 equal)
((mapcar (lambda (&rest x) x) '(1 2 3) '(4 5 6) '(7 8 9)) 
 ((1 4 7) (2 5 8) (3 6 9)) equal)

;;;
;;; ֐ (MAPC function list+) --> <list>
;;;
($ap 2 "mapc" P.88)
((let ((x 0)) (mapc (lambda (v) (setq x (+ x v))) '(3 5)) x) 8 eql)
;;;
($argc mapc 2 0 1)
($type mapc ($function $generic) :target nil)
($type mapc ($cons $null) (function list) :target)
($type mapc ($cons $null) (function list) (quote (a b)) :target)
;;; 1 ֐
((mapc #'car ()) ())
((mapc (lambda (x) (car 1)) ()) ())
((let ((x 0)) (list (mapc (lambda (v) (setq x (+ x v))) '(3 5)) x)) 
 ((3 5) 8) equal)
;;; 2 ֐
((mapc #'cons () ()) ())
((mapc #'cons () '(a b c)) ())
((mapc #'cons '(a b c) ()) (a b c) equal)
((let ((ret 0)) 
   (list (mapc (lambda (x y) (setq ret (+ ret x y))) '(1 2 3) '(4 5 6)) ret))
 ((1 2 3) 21)
 equal)
;;; rest ֐
((mapc #'list () () () () ()) ())
((mapc #'list '(a b c) '(d e f) '(g h i) '(j k l) '(m n o)) (a b c) equal)
((mapc #'list '(a b c) '(d e f) '(g) '(j k l) '(m n o)) (a b c) equal)
((let ((ret ()))
   (list (mapc (lambda (&rest x) (setq ret (cons x ret))) '(1 2 3) '(4 5 6) '(7 8 9))
         ret))
 ((1 2 3) ((3 6 9) (2 5 8) (1 4 7)))
 equal)

;;;
;;; ֐ (MAPCAN function list+) --> <list>
;;;
($ap 2 "mapcan" P.88)
((mapcan (lambda (x) (if (> x 0) (list x))) '(-3 4 0 5 -2 7)) (4 5 7) equal)
;;;
($argc mapcan 2 0 1)
($type mapcan ($function $generic) :target nil)
($type mapcan ($cons $null) (function list) :target)
($type mapcan ($cons $null) (function list) (quote (a b)) :target)
;;; 1 ֐
((mapcan #'car ()) ())
((mapcan (lambda (x) (car 1)) ()) ())
((mapcan (lambda (x) (list (+ x 1))) '(1 2 3 4 5)) (2 3 4 5 6) equal)
;;; 2 ֐
((mapcan #'cons () ()) ())
((mapcan #'cons () '(a b c)) ())
((mapcan #'cons '(a b c) ()) ())
((mapcan (lambda (x y) (list (+ x y))) '(1 2 3 4 5) '(6 7 8 9 10)) (7 9 11 13 15) equal)
;;; rest ֐
((mapcan #'list () () () () ()) ())
((mapcan #'list '(a b c) '(d e f) '(g h i) '(j k l) '(m n o))
 (a d g j m b e h k n c f i l o)
 equal)
((mapcan #'list '(a b c) '(d e f) '(g) '(j k l) '(m n o))
 (a d g j m)
 equal)
((mapcan (lambda (&rest x) x) '(1 2 3) '(4 5 6) '(7 8 9)) (1 4 7 2 5 8 3 6 9) equal)

;;;
;;; ֐ (MAPLIST function list+) --> <list>
;;;
($ap 2 "maplist" P.88)
((maplist #'append '(1 2 3 4) '(1 2) '(1 2 3)) ((1 2 3 4 1 2 1 2 3) (2 3 4 2 2 3)) equal)
((maplist (lambda (x) (cons 'foo x))
 '(a b c d)) ((foo a b c d ) (foo b c d) (foo c d) (foo d))
 equal)
((maplist (lambda (x) (if (member (car x) (cdr x)) 0 1)) '(a b a c d b c))
 (0 0 1 0 1 1 1 )
 equal)
;;;
($argc maplist 2 0 1)
($type maplist ($function $generic) :target nil)
($type maplist ($cons $null) (function list) :target)
($type maplist ($cons $null) (function list) (quote (a b)) :target)
;;; 1 ֐
((maplist #'car ()) ())
((maplist (lambda (x) (car 1)) ()) ())
((maplist (lambda (x) x) '(1 2 3 4 5)) ((1 2 3 4 5) (2 3 4 5) (3 4 5) (4 5) (5)) equal)
;;; 2 ֐
((maplist #'cons () ()) ())
((maplist #'cons () '(a b c)) ())
((maplist #'cons '(a b c) ()) ())
((maplist (lambda (x y) (list x y)) '(1 2 3) '(4 5 6))
 (((1 2 3) (4 5 6)) ((2 3) (5 6)) ((3) (6)))
 equal)
;;; rest ֐
((maplist #'list () () () () ()) ())
((maplist #'list '(a b c) '(d e f) '(g h i) '(j k l) '(m n o))
 (((a b c) (d e f) (g h i) (j k l) (m n o))
  ((b c) (e f) (h i) (k l) (n o))
  ((c) (f) (i) (l) (o)))
 equal)
((maplist #'list '(a b c) '(d e f) '(g) '(j k l) '(m n o))
 (((a b c) (d e f) (g) (j k l) (m n o)))
 equal)
((maplist (lambda (&rest x) x) '(1 2 3) '(4 5 6) '(7 8 9))
 (((1 2 3) (4 5 6) (7 8 9))
  ((2 3) (5 6) (8 9))
  ((3) (6) (9)))
 equal)

;;;
;;; ֐ (MAPL function list+) --> <list>
;;;
($ap 2 "mapl" P.88)
((let ((k 0))
   (mapl (lambda (x) (setq k (+ k (if (member (car x) (cdr x)) 0 1))))
         '(a b a c d b c))
   k)
 4
 eql)
;;;
($argc mapl 2 0 1)
($type mapl ($function $generic) :target nil)
($type mapl ($cons $null) (function list) :target)
($type mapl ($cons $null) (function list) (quote (a b)) :target)
;;; 1 ֐
((mapl #'car ()) ())
((mapl (lambda (x) (car 1)) ()) ())
((let ((ret ()))
   (list (mapl (lambda (x) (setq ret (cons x ret))) '(1 2 3 4 5))
         (nreverse ret)))
 ((1 2 3 4 5) ((1 2 3 4 5) (2 3 4 5) (3 4 5) (4 5) (5))) equal)
;;; 2 ֐
((mapl #'cons () ()) ())
((mapl #'cons () '(a b c)) ())
((mapl #'cons '(a b c) ()) (a b c) equal)
((let ((ret ()))
   (list (mapl (lambda (x y) (setq ret (cons (list x y) ret))) '(1 2 3) '(4 5 6))
         (nreverse ret)))
 ((1 2 3) (((1 2 3) (4 5 6)) ((2 3) (5 6)) ((3) (6))))
 equal)
;;; rest ֐
((mapl #'list () () () () ()) ())
((let ((ret ()))
   (list (mapl (lambda (&rest x) (setq ret (cons x ret))) '(1 2 3) '(4 5 6) '(7 8 9))
         (nreverse ret)))
 ((1 2 3)
  (((1 2 3) (4 5 6) (7 8 9))
   ((2 3) (5 6) (8 9))
   ((3) (6) (9))))
 equal)

;;;
;;; ֐ (MAPCON function list+) --> <list>
;;;
($argc mapcon 2 0 1)
((mapcon (lambda (x) (if (member (car x) (cdr x)) (list (car x)))) '(a b a c d b c b c))
 (a b c b c)
 equal)
((mapcon #'list '(1 2 3 4)) ((1 2 3 4) (2 3 4) (3 4) (4)) equal)
;;;
($argc mapcon 2 0 1)
($type mapcon ($function $generic) :target nil)
($type mapcon ($cons $null) (function list) :target)
($type mapcon ($cons $null) (function list) (quote (a b)) :target)
;;; 1 ֐
((mapcon #'car ()) ())
((mapcon (lambda (x) (car 1)) ()) ())
((mapcon (lambda (x) (list x)) '(1 2 3 4 5)) ((1 2 3 4 5) (2 3 4 5) (3 4 5) (4 5) (5)) equal)
;;; 2 ֐
((mapcon #'cons () ()) ())
((mapcon #'cons () '(a b c)) ())
((mapcon #'cons '(a b c) ()) ())
((mapcon (lambda (x y) (list (list x y))) '(1 2 3) '(4 5 6))
 (((1 2 3) (4 5 6)) ((2 3) (5 6)) ((3) (6)))
 equal)
;;; rest ֐
((mapcon #'list () () () () ()) ())
((mapcon #'list '(a b c) '(d e f) '(g h i) '(j k l) '(m n o))
 ((a b c) (d e f) (g h i) (j k l) (m n o)
  (b c) (e f) (h i) (k l) (n o)
  (c) (f) (i) (l) (o))
 equal)
((mapcon #'list '(a b c) '(d e f) '(g) '(j k l) '(m n o))
 ((a b c) (d e f) (g) (j k l) (m n o))
 equal)
((mapcon (lambda (&rest x) (list x)) '(1 2 3) '(4 5 6) '(7 8 9))
 (((1 2 3) (4 5 6) (7 8 9))
  ((2 3) (5 6) (8 9))
  ((3) (6) (9)))
 equal)

;;;
;;; ֐ (ASSOC obj association-list) --> <cons>
;;;
($ap 2 "assoc" P.90)
((assoc 'a '((a . 1) (b . 2))) (a . 1) equal)
((assoc 'a '((a . 1) (a . 2))) (a . 1) equal)
((assoc 'c '((a . 1) (b . 2))) nil)
;;;
($argc assoc 2 0 0)
;;;
((assoc 'a ()) nil)
((assoc 'b '((a) (b) (c))) (b) equal)
((assoc 'b '((a 1) (b 2) (c 3))) (b 2) equal)
((assoc #\b '((#\a . 1) (#\b . 2) (#\c . 3))) (#\b . 2) equal)
((assoc 2 '((1 . 1) (2 . 2) (3 . 3))) (2 . 2) equal)
((assoc -2 '((1 . 1) (-2 . 2) (3 . 3))) (-2 . 2) equal)
((assoc 2.0 '((1 . 1) (2.0 . 2) (3 . 3))) (2.0 . 2) equal)
((assoc -2.0 '((1 . 1) (-2.0 . 2) (3 . 3))) (-2.0 . 2) equal)
((assoc 1234567890 '((1 . 1) (1234567890 . 2) (3 . 3))) (1234567890 . 2) equal)
((assoc -1234567890 '((1 . 1) (-1234567890 . 2) (3 . 3))) (-1234567890 . 2) equal)
($error (assoc 'a '(a)) <error>)
($error (assoc 'a '(a b c)) <error>)
((assoc 'a '((a . b) ())) (a . b) equal)
((assoc 'a (create-list 1000 '(a . b))) (a . b) equal)
((assoc 'b (create-list 1000 '(a . b))) nil)
