;;;
;;;  PP  Number class
;;;

($ap 1 "Number class")

;;;
;;; ֐ (NUMBERP obj) --> boolean
;;;
($ap 2 "numberp" P.67)
((numberp 3) t)
((numberp -0.3) t)
((numberp '(a b c)) nil)
((numberp "17") nil)
;;;
($argc numberp 1 0 0)
($predicate numberp $float $integer)

;;;
;;; ֐ (PARSE-NUMBER string) --> <number>
;;;
($ap 2 "parse-number" P.67)
((parse-number "123.34") 123.34 eql)
((parse-number "#XFACE") 64206 eql)
($error (parse-number "-37.") <parse-error>)
($error (parse-number "-.5") <parse-error>)
;;;
($argc parse-number 1 0 0)
($type parse-number ($string) :target)
;;; #b[s]bb...b
((parse-number "#b0") 0 eql)
((parse-number "#b+0") 0 eql)
((parse-number "#b-0") 0 eql)
((parse-number "#b1") 1 eql)
((parse-number "#b+1") 1 eql)
((parse-number "#b-1") -1 eql)
((parse-number "#b1010101010") 682 eql)
((parse-number "#b+1010101010") 682 eql)
((parse-number "#b-1010101010") -682 eql)
($error (parse-number "#b") <parse-error>)
($error (parse-number "#b+") <parse-error>)
($error (parse-number "#b-") <parse-error>)
($error (parse-number "#b12") <parse-error>)
($error (parse-number "#b+12") <parse-error>)
($error (parse-number "#b-12") <parse-error>)
;;; #B[s]bb...b
((parse-number "#B0") 0 eql)
((parse-number "#B+0") 0 eql)
((parse-number "#B-0") 0 eql)
((parse-number "#B1") 1 eql)
((parse-number "#B+1") 1 eql)
((parse-number "#B-1") -1 eql)
((parse-number "#B1010101010") 682 eql)
((parse-number "#B+1010101010") 682 eql)
((parse-number "#B-1010101010") -682 eql)
($error (parse-number "#B") <parse-error>)
($error (parse-number "#B+") <parse-error>)
($error (parse-number "#B-") <parse-error>)
($error (parse-number "#B12") <parse-error>)
($error (parse-number "#B+12") <parse-error>)
($error (parse-number "#B-12") <parse-error>)
;;; #o[s]oo...o
((parse-number "#o0") 0 eql)
((parse-number "#o+0") 0 eql)
((parse-number "#o-0") 0 eql)
((parse-number "#o7") 7 eql)
((parse-number "#o+7") 7 eql)
((parse-number "#o-7") -7 eql)
((parse-number "#o12345670") 2739128 eql)
((parse-number "#o+12345670") 2739128 eql)
((parse-number "#o-12345670") -2739128 eql)
($error (parse-number "#o") <parse-error>)
($error (parse-number "#o+") <parse-error>)
($error (parse-number "#o-") <parse-error>)
($error (parse-number "#o12345678") <parse-error>)
($error (parse-number "#o+12345678") <parse-error>)
($error (parse-number "#o-12345678") <parse-error>)
;;; #O[s]oo...o
((parse-number "#O0") 0 eql)
((parse-number "#O+0") 0 eql)
((parse-number "#O-0") 0 eql)
((parse-number "#O7") 7 eql)
((parse-number "#O+7") 7 eql)
((parse-number "#O-7") -7 eql)
((parse-number "#O12345670") 2739128 eql)
((parse-number "#O+12345670") 2739128 eql)
((parse-number "#O-12345670") -2739128 eql)
($error (parse-number "#O") <parse-error>)
($error (parse-number "#O+") <parse-error>)
($error (parse-number "#O-") <parse-error>)
($error (parse-number "#O12345678") <parse-error>)
($error (parse-number "#O+12345678") <parse-error>)
($error (parse-number "#O-12345678") <parse-error>)
;;; [s]dd...d
((parse-number "0") 0 eql)
((parse-number "+0") 0 eql)
((parse-number "-0") 0 eql)
((parse-number "9") 9 eql)
((parse-number "+9") 9 eql)
((parse-number "-9") -9 eql)
((parse-number "1234567890") 1234567890 eql)
((parse-number "+1234567890") 1234567890 eql)
((parse-number "-1234567890") -1234567890 eql)
($error (parse-number "") <parse-error>)
($error (parse-number "+") <parse-error>)
($error (parse-number "-") <parse-error>)
($error (parse-number "123456789A") <parse-error>)
($error (parse-number "+123456789A") <parse-error>)
($error (parse-number "-123456789A") <parse-error>)
;;; #x[s]xx...x
((parse-number "#x0") 0 eql)
((parse-number "#x+0") 0 eql)
((parse-number "#x-0") 0 eql)
((parse-number "#xF") 15 eql)
((parse-number "#x+F") 15 eql)
((parse-number "#x-F") -15 eql)
((parse-number "#x1234567890abcdefABCDEF") 22007822917795467892608495 eql)
($error (parse-number "#x") <parse-error>)
($error (parse-number "#x+") <parse-error>)
($error (parse-number "#x-") <parse-error>)
($error (parse-number "#x1234567890ABCDEFG") <parse-error>)
($error (parse-number "#x+1234567890ABCDEFG") <parse-error>)
($error (parse-number "#x-1234567890ABCDEFG") <parse-error>)
;;; #X[s]xx...x
((parse-number "#X0") 0 eql)
((parse-number "#X+0") 0 eql)
((parse-number "#X-0") 0 eql)
((parse-number "#Xf") 15 eql)
((parse-number "#X+f") 15 eql)
((parse-number "#X-f") -15 eql)
((parse-number "#X1234567890abcdefABCDEF") 22007822917795467892608495 eql)
($error (parse-number "#X") <parse-error>)
($error (parse-number "#X+") <parse-error>)
($error (parse-number "#X-") <parse-error>)
($error (parse-number "#X1234567890abcdefg") <parse-error>)
($error (parse-number "#X+1234567890abcdefg") <parse-error>)
($error (parse-number "#X-1234567890abcdefg") <parse-error>)
;;; [s]dd...d.dd...d
((parse-number "0.0") 0.0 eql)
((parse-number "+0.0") 0.0 eql)
((parse-number "-0.0") 0.0 eql)
((parse-number "9.9") 9.9 eql)
((parse-number "+9.9") 9.9 eql)
((parse-number "-9.9") -9.9 eql)
((parse-number "12345.67890") 12345.67890 eql)
((parse-number "+12345.67890") 12345.67890 eql)
((parse-number "-12345.67890") -12345.67890 eql)
($error (parse-number ".") <parse-error>)
($error (parse-number "+.") <parse-error>)
($error (parse-number "-.") <parse-error>)
($error (parse-number ".0") <parse-error>)
($error (parse-number "+.0") <parse-error>)
($error (parse-number "-.0") <parse-error>)
($error (parse-number "1.") <parse-error>)
($error (parse-number "+1.") <parse-error>)
($error (parse-number "-1.") <parse-error>)
($error (parse-number "12345A.0") <parse-error>)
($error (parse-number "+12345A.0") <parse-error>)
($error (parse-number "-12345A.0") <parse-error>)
($error (parse-number "1.2345A") <parse-error>)
($error (parse-number "+1.2345A") <parse-error>)
($error (parse-number "-1.2345A") <parse-error>)
;;; [s]dd...d.dd...dE[s]dd...d
((parse-number "0.0E0") 0.0 eql)
((parse-number "0.0E+0") 0.0 eql)
((parse-number "0.0E-0") 0.0 eql)
((parse-number "+0.0E0") 0.0 eql)
((parse-number "+0.0E+0") 0.0 eql)
((parse-number "+0.0E-0") 0.0 eql)
((parse-number "-0.0E0") 0.0 eql)
((parse-number "-0.0E+0") 0.0 eql)
((parse-number "-0.0E-0") 0.0 eql)
((parse-number "9.9E9") 9.9e9 eql)
((parse-number "9.9E+9") 9.9e9 eql)
((parse-number "9.9E-9") 9.9e-9 eql)
((parse-number "+9.9E9") 9.9e9 eql)
((parse-number "+9.9E+9") 9.9e9 eql)
((parse-number "+9.9E-9") 9.9e-9 eql)
((parse-number "-9.9E9") -9.9e9 eql)
((parse-number "-9.9E+9") -9.9e9 eql)
((parse-number "-9.9E-9") -9.9e-9 eql)
((parse-number "1234.5678E90") 1234.5678e90 eql)
((parse-number "1234.5678E+90") 1234.5678e+90 eql)
((parse-number "1234.5678E-90") 1234.5678e-90 eql)
((parse-number "+1234.5678E90") 1234.5678e90 eql)
((parse-number "+1234.5678E+90") 1234.5678e+90 eql)
((parse-number "+1234.5678E-90") 1234.5678e-90 eql)
((parse-number "-1234.5678E90") -1234.5678e90 eql)
((parse-number "-1234.5678E+90") -1234.5678e+90 eql)
((parse-number "-1234.5678E-90") -1234.5678e-90 eql)
($error (parse-number ".2E3") <parse-error>)
($error (parse-number ".2E+3") <parse-error>)
($error (parse-number ".2E-3") <parse-error>)
($error (parse-number "+.2E3") <parse-error>)
($error (parse-number "+.2E+3") <parse-error>)
($error (parse-number "+.2E-3") <parse-error>)
($error (parse-number "-.2E3") <parse-error>)
($error (parse-number "-.2E+3") <parse-error>)
($error (parse-number "-.2E-3") <parse-error>)
($error (parse-number "1.E3") <parse-error>)
($error (parse-number "1.E+3") <parse-error>)
($error (parse-number "1.E-3") <parse-error>)
($error (parse-number "+1.E3") <parse-error>)
($error (parse-number "+1.E+3") <parse-error>)
($error (parse-number "+1.E-3") <parse-error>)
($error (parse-number "-1.E3") <parse-error>)
($error (parse-number "-1.E+3") <parse-error>)
($error (parse-number "-1.E-3") <parse-error>)
($error (parse-number "1.2E") <parse-error>)
($error (parse-number "1.2E+") <parse-error>)
($error (parse-number "1.2E-") <parse-error>)
($error (parse-number "+1.2E") <parse-error>)
($error (parse-number "+1.2E+") <parse-error>)
($error (parse-number "+1.2E-") <parse-error>)
($error (parse-number "-1.2E") <parse-error>)
($error (parse-number "-1.2E+") <parse-error>)
($error (parse-number "-1.2E-") <parse-error>)
($error (parse-number "123a.4E5") <parse-error>)
($error (parse-number "123a.4E+5") <parse-error>)
($error (parse-number "123a.4E-5") <parse-error>)
($error (parse-number "+123a.4E5") <parse-error>)
($error (parse-number "+123a.4E+5") <parse-error>)
($error (parse-number "+123a.4E-5") <parse-error>)
($error (parse-number "-123a.4E5") <parse-error>)
($error (parse-number "-123a.4E+5") <parse-error>)
($error (parse-number "-123a.4E-5") <parse-error>)
($error (parse-number "123.4aE5") <parse-error>)
($error (parse-number "123.4aE+5") <parse-error>)
($error (parse-number "123.4aE-5") <parse-error>)
($error (parse-number "+123.4aE5") <parse-error>)
($error (parse-number "+123.4aE+5") <parse-error>)
($error (parse-number "+123.4aE-5") <parse-error>)
($error (parse-number "-123.4aE5") <parse-error>)
($error (parse-number "-123.4aE+5") <parse-error>)
($error (parse-number "-123.4aE-5") <parse-error>)
($error (parse-number "123.4E5a") <parse-error>)
($error (parse-number "123.4E+5a") <parse-error>)
($error (parse-number "123.4E-5a") <parse-error>)
($error (parse-number "+123.4E5a") <parse-error>)
($error (parse-number "+123.4E+5a") <parse-error>)
($error (parse-number "+123.4E-5a") <parse-error>)
($error (parse-number "-123.4E5a") <parse-error>)
($error (parse-number "-123.4E+5a") <parse-error>)
($error (parse-number "-123.4E-5a") <parse-error>)
($error (parse-number "1.0E1000") <floating-point-overflow>)
($error (parse-number "1.0E+1000") <floating-point-overflow>)
($error (parse-number "1.0E-1000") <floating-point-underflow>)
($error (parse-number "+1.0E1000") <floating-point-overflow>)
($error (parse-number "+1.0E+1000") <floating-point-overflow>)
($error (parse-number "+1.0E-1000") <floating-point-underflow>)
($error (parse-number "-1.0E1000") <floating-point-overflow>)
($error (parse-number "-1.0E+1000") <floating-point-overflow>)
($error (parse-number "-1.0E-1000") <floating-point-underflow>)
;;; [s]dd...d.dd...de[s]dd...d
((parse-number "0.0e0") 0.0 eql)
((parse-number "0.0e+0") 0.0 eql)
((parse-number "0.0e-0") 0.0 eql)
((parse-number "+0.0e0") 0.0 eql)
((parse-number "+0.0e+0") 0.0 eql)
((parse-number "+0.0e-0") 0.0 eql)
((parse-number "-0.0e0") 0.0 eql)
((parse-number "-0.0e+0") 0.0 eql)
((parse-number "-0.0e-0") 0.0 eql)
((parse-number "9.9e9") 9.9E9 eql)
((parse-number "9.9e+9") 9.9E9 eql)
((parse-number "9.9e-9") 9.9E-9 eql)
((parse-number "+9.9e9") 9.9E9 eql)
((parse-number "+9.9e+9") 9.9E9 eql)
((parse-number "+9.9e-9") 9.9E-9 eql)
((parse-number "-9.9e9") -9.9E9 eql)
((parse-number "-9.9e+9") -9.9E9 eql)
((parse-number "-9.9e-9") -9.9E-9 eql)
((parse-number "1234.5678e90") 1234.5678E90 eql)
((parse-number "1234.5678e+90") 1234.5678E+90 eql)
((parse-number "1234.5678e-90") 1234.5678E-90 eql)
((parse-number "+1234.5678e90") 1234.5678E90 eql)
((parse-number "+1234.5678e+90") 1234.5678E+90 eql)
((parse-number "+1234.5678e-90") 1234.5678E-90 eql)
((parse-number "-1234.5678e90") -1234.5678E90 eql)
((parse-number "-1234.5678e+90") -1234.5678E+90 eql)
((parse-number "-1234.5678e-90") -1234.5678E-90 eql)
($error (parse-number ".2e3") <parse-error>)
($error (parse-number ".2e+3") <parse-error>)
($error (parse-number ".2e-3") <parse-error>)
($error (parse-number "+.2e3") <parse-error>)
($error (parse-number "+.2e+3") <parse-error>)
($error (parse-number "+.2e-3") <parse-error>)
($error (parse-number "-.2e3") <parse-error>)
($error (parse-number "-.2e+3") <parse-error>)
($error (parse-number "-.2e-3") <parse-error>)
($error (parse-number "1.e3") <parse-error>)
($error (parse-number "1.e+3") <parse-error>)
($error (parse-number "1.e-3") <parse-error>)
($error (parse-number "+1.e3") <parse-error>)
($error (parse-number "+1.e+3") <parse-error>)
($error (parse-number "+1.e-3") <parse-error>)
($error (parse-number "-1.e3") <parse-error>)
($error (parse-number "-1.e+3") <parse-error>)
($error (parse-number "-1.e-3") <parse-error>)
($error (parse-number "1.2e") <parse-error>)
($error (parse-number "1.2e+") <parse-error>)
($error (parse-number "1.2e-") <parse-error>)
($error (parse-number "+1.2e") <parse-error>)
($error (parse-number "+1.2e+") <parse-error>)
($error (parse-number "+1.2e-") <parse-error>)
($error (parse-number "-1.2e") <parse-error>)
($error (parse-number "-1.2e+") <parse-error>)
($error (parse-number "-1.2e-") <parse-error>)
($error (parse-number "123a.4e5") <parse-error>)
($error (parse-number "123a.4e+5") <parse-error>)
($error (parse-number "123a.4e-5") <parse-error>)
($error (parse-number "+123a.4e5") <parse-error>)
($error (parse-number "+123a.4e+5") <parse-error>)
($error (parse-number "+123a.4e-5") <parse-error>)
($error (parse-number "-123a.4e5") <parse-error>)
($error (parse-number "-123a.4e+5") <parse-error>)
($error (parse-number "-123a.4e-5") <parse-error>)
($error (parse-number "123.4ae5") <parse-error>)
($error (parse-number "123.4ae+5") <parse-error>)
($error (parse-number "123.4ae-5") <parse-error>)
($error (parse-number "+123.4ae5") <parse-error>)
($error (parse-number "+123.4ae+5") <parse-error>)
($error (parse-number "+123.4ae-5") <parse-error>)
($error (parse-number "-123.4ae5") <parse-error>)
($error (parse-number "-123.4ae+5") <parse-error>)
($error (parse-number "-123.4ae-5") <parse-error>)
($error (parse-number "123.4e5a") <parse-error>)
($error (parse-number "123.4e+5a") <parse-error>)
($error (parse-number "123.4e-5a") <parse-error>)
($error (parse-number "+123.4e5a") <parse-error>)
($error (parse-number "+123.4e+5a") <parse-error>)
($error (parse-number "+123.4e-5a") <parse-error>)
($error (parse-number "-123.4e5a") <parse-error>)
($error (parse-number "-123.4e+5a") <parse-error>)
($error (parse-number "-123.4e-5a") <parse-error>)
($error (parse-number "1.0e1000") <floating-point-overflow>)
($error (parse-number "1.0e+1000") <floating-point-overflow>)
($error (parse-number "1.0e-1000") <floating-point-underflow>)
($error (parse-number "+1.0e1000") <floating-point-overflow>)
($error (parse-number "+1.0e+1000") <floating-point-overflow>)
($error (parse-number "+1.0e-1000") <floating-point-underflow>)
($error (parse-number "-1.0e1000") <floating-point-overflow>)
($error (parse-number "-1.0e+1000") <floating-point-overflow>)
($error (parse-number "-1.0e-1000") <floating-point-underflow>)
;;; [s]dd...dE[s]dd...d
((parse-number "0E0") 0.0 eql)
((parse-number "0E+0") 0.0 eql)
((parse-number "0E-0") 0.0 eql)
((parse-number "+0E0") 0.0 eql)
((parse-number "+0E+0") 0.0 eql)
((parse-number "+0E-0") 0.0 eql)
((parse-number "-0E0") 0.0 eql)
((parse-number "-0E+0") 0.0 eql)
((parse-number "-0E-0") 0.0 eql)
((parse-number "9E9") 9e9 eql)
((parse-number "9E+9") 9e9 eql)
((parse-number "9E-9") 9e-9 eql)
((parse-number "+9E9") 9e9 eql)
((parse-number "+9E+9") 9e9 eql)
((parse-number "+9E-9") 9e-9 eql)
((parse-number "-9E9") -9e9 eql)
((parse-number "-9E+9") -9e9 eql)
((parse-number "-9E-9") -9e-9 eql)
((parse-number "12345678E90") 12345678e90 eql)
((parse-number "12345678E+90") 12345678e90 eql)
((parse-number "12345678E-90") 12345678e-90 eql)
((parse-number "+12345678E90") 12345678e90 eql)
((parse-number "+12345678E+90") 12345678e90 eql)
((parse-number "+12345678E-90") 12345678e-90 eql)
((parse-number "-12345678E90") -12345678e90 eql)
((parse-number "-12345678E+90") -12345678e90 eql)
((parse-number "-12345678E-90") -12345678e-90 eql)
($error (parse-number "E3") <parse-error>)
($error (parse-number "E+3") <parse-error>)
($error (parse-number "E-3") <parse-error>)
($error (parse-number "+E3") <parse-error>)
($error (parse-number "+E+3") <parse-error>)
($error (parse-number "+E-3") <parse-error>)
($error (parse-number "-E3") <parse-error>)
($error (parse-number "-E+3") <parse-error>)
($error (parse-number "-E-3") <parse-error>)
($error (parse-number "1E") <parse-error>)
($error (parse-number "1E+") <parse-error>)
($error (parse-number "1E-") <parse-error>)
($error (parse-number "+1E") <parse-error>)
($error (parse-number "+1E+") <parse-error>)
($error (parse-number "+1E-") <parse-error>)
($error (parse-number "-1E") <parse-error>)
($error (parse-number "-1E+") <parse-error>)
($error (parse-number "-1E-") <parse-error>)
($error (parse-number "123aE56") <parse-error>)
($error (parse-number "123aE+56") <parse-error>)
($error (parse-number "123aE-56") <parse-error>)
($error (parse-number "+123aE56") <parse-error>)
($error (parse-number "+123aE+56") <parse-error>)
($error (parse-number "+123aE-56") <parse-error>)
($error (parse-number "-123aE56") <parse-error>)
($error (parse-number "-123aE+56") <parse-error>)
($error (parse-number "-123aE-56") <parse-error>)
($error (parse-number "123E56a") <parse-error>)
($error (parse-number "123E+56a") <parse-error>)
($error (parse-number "123E-56a") <parse-error>)
($error (parse-number "+123E56a") <parse-error>)
($error (parse-number "+123E+56a") <parse-error>)
($error (parse-number "+123E-56a") <parse-error>)
($error (parse-number "-123E56a") <parse-error>)
($error (parse-number "-123E+56a") <parse-error>)
($error (parse-number "-123E-56a") <parse-error>)
($error (parse-number "1E1000") <floating-point-overflow>)
($error (parse-number "1E+1000") <floating-point-overflow>)
($error (parse-number "1E-1000") <floating-point-underflow>)
($error (parse-number "+1E1000") <floating-point-overflow>)
($error (parse-number "+1E+1000") <floating-point-overflow>)
($error (parse-number "+1E-1000") <floating-point-underflow>)
($error (parse-number "-1E1000") <floating-point-overflow>)
($error (parse-number "-1E+1000") <floating-point-overflow>)
($error (parse-number "-1E-1000") <floating-point-underflow>)
;;; [s]dd...de[s]dd...d
((parse-number "0e0") 0.0 eql)
((parse-number "0e+0") 0.0 eql)
((parse-number "0e-0") 0.0 eql)
((parse-number "+0e0") 0.0 eql)
((parse-number "+0e+0") 0.0 eql)
((parse-number "+0e-0") 0.0 eql)
((parse-number "-0e0") 0.0 eql)
((parse-number "-0e+0") 0.0 eql)
((parse-number "-0e-0") 0.0 eql)
((parse-number "9e9") 9E9 eql)
((parse-number "9e+9") 9E9 eql)
((parse-number "9e-9") 9E-9 eql)
((parse-number "+9e9") 9E9 eql)
((parse-number "+9e+9") 9E9 eql)
((parse-number "+9e-9") 9E-9 eql)
((parse-number "-9e9") -9E9 eql)
((parse-number "-9e+9") -9E9 eql)
((parse-number "-9e-9") -9E-9 eql)
((parse-number "12345678e90") 12345678E90 eql)
((parse-number "12345678e+90") 12345678E90 eql)
((parse-number "12345678e-90") 12345678E-90 eql)
((parse-number "+12345678e90") 12345678E90 eql)
((parse-number "+12345678e+90") 12345678E90 eql)
((parse-number "+12345678e-90") 12345678E-90 eql)
((parse-number "-12345678e90") -12345678E90 eql)
((parse-number "-12345678e+90") -12345678E90 eql)
((parse-number "-12345678e-90") -12345678E-90 eql)
($error (parse-number "e3") <parse-error>)
($error (parse-number "e+3") <parse-error>)
($error (parse-number "e-3") <parse-error>)
($error (parse-number "+e3") <parse-error>)
($error (parse-number "+e+3") <parse-error>)
($error (parse-number "+e-3") <parse-error>)
($error (parse-number "-e3") <parse-error>)
($error (parse-number "-e+3") <parse-error>)
($error (parse-number "-e-3") <parse-error>)
($error (parse-number "1e") <parse-error>)
($error (parse-number "1e+") <parse-error>)
($error (parse-number "1e-") <parse-error>)
($error (parse-number "+1e") <parse-error>)
($error (parse-number "+1e+") <parse-error>)
($error (parse-number "+1e-") <parse-error>)
($error (parse-number "-1e") <parse-error>)
($error (parse-number "-1e+") <parse-error>)
($error (parse-number "-1e-") <parse-error>)
($error (parse-number "123ae56") <parse-error>)
($error (parse-number "123ae+56") <parse-error>)
($error (parse-number "123ae-56") <parse-error>)
($error (parse-number "+123ae56") <parse-error>)
($error (parse-number "+123ae+56") <parse-error>)
($error (parse-number "+123ae-56") <parse-error>)
($error (parse-number "-123ae56") <parse-error>)
($error (parse-number "-123ae+56") <parse-error>)
($error (parse-number "-123ae-56") <parse-error>)
($error (parse-number "123e56a") <parse-error>)
($error (parse-number "123e+56a") <parse-error>)
($error (parse-number "123e-56a") <parse-error>)
($error (parse-number "+123e56a") <parse-error>)
($error (parse-number "+123e+56a") <parse-error>)
($error (parse-number "+123e-56a") <parse-error>)
($error (parse-number "-123e56a") <parse-error>)
($error (parse-number "-123e+56a") <parse-error>)
($error (parse-number "-123e-56a") <parse-error>)
($error (parse-number "1e1000") <floating-point-overflow>)
($error (parse-number "1e+1000") <floating-point-overflow>)
($error (parse-number "1e-1000") <floating-point-underflow>)
($error (parse-number "+1e1000") <floating-point-overflow>)
($error (parse-number "+1e+1000") <floating-point-overflow>)
($error (parse-number "+1e-1000") <floating-point-underflow>)
($error (parse-number "-1e1000") <floating-point-overflow>)
($error (parse-number "-1e+1000") <floating-point-overflow>)
($error (parse-number "-1e-1000") <floating-point-underflow>)
;;;
($error (parse-number "#") <parse-error>)
($error (parse-number "#a") <parse-error>)
($error (parse-number "#a1") <parse-error>)
;;;
;;; ֐ (= x1 x2) --> boolean
;;;
($ap 2 "=" P.67)
((= 3 4) nil)
((= 3 3.0) t)
((= (parse-number "134.54") 134.54) t)
((= 0.0 -0.0) t)
;;;
($argc = 2 0 0)
($type = ($integer $float) :target 1)
($type = ($integer $float) 1 :target)
;;;
((= -1234567890 -1234567890)   t)
((= -1234567890        -123) nil)
((= -1234567890           0) nil)
((= -1234567890         123) nil)
((= -1234567890  1234567890) nil)
((= -1234567890 -1234567890.0)   t)
((= -1234567890        -123.0) nil)
((= -1234567890           0.0) nil)
((= -1234567890         123.0) nil)
((= -1234567890  1234567890.0) nil)
((= -1234567890 *most-negative-float*) nil)
((= -1234567890 *most-positive-float*) nil)
((=        -123 -1234567890) nil)
((=        -123        -123)   t)
((=        -123           0) nil)
((=        -123         123) nil)
((=        -123  1234567890) nil)
((=        -123 -1234567890.0) nil)
((=        -123        -123.0)   t)
((=        -123           0.0) nil)
((=        -123         123.0) nil)
((=        -123  1234567890.0) nil)
((=        -123 *most-negative-float*) nil)
((=        -123 *most-positive-float*) nil)
((=           0 -1234567890) nil)
((=           0        -123) nil)
((=           0           0)   t)
((=           0         123) nil)
((=           0  1234567890) nil)
((=           0 -1234567890.0) nil)
((=           0        -123.0) nil)
((=           0           0.0)   t)
((=           0         123.0) nil)
((=           0  1234567890.0) nil)
((=           0 *most-negative-float*) nil)
((=           0 *most-positive-float*) nil)
((=         123 -1234567890) nil)
((=         123        -123) nil)
((=         123           0) nil)
((=         123         123)   t)
((=         123  1234567890) nil)
((=         123 -1234567890.0) nil)
((=         123        -123.0) nil)
((=         123           0.0) nil)
((=         123         123.0)   t)
((=         123  1234567890.0) nil)
((=         123 *most-negative-float*) nil)
((=         123 *most-positive-float*) nil)
((=  1234567890 -1234567890) nil)
((=  1234567890        -123) nil)
((=  1234567890           0) nil)
((=  1234567890         123) nil)
((=  1234567890  1234567890)   t)
((=  1234567890 -1234567890.0) nil)
((=  1234567890        -123.0) nil)
((=  1234567890           0.0) nil)
((=  1234567890         123.0) nil)
((=  1234567890  1234567890.0)   t)
((=  1234567890 *most-negative-float*) nil)
((=  1234567890 *most-positive-float*) nil)
((= -1234567890.0 -1234567890)   t)
((= -1234567890.0        -123) nil)
((= -1234567890.0           0) nil)
((= -1234567890.0         123) nil)
((= -1234567890.0  1234567890) nil)
((= -1234567890.0 -1234567890.0)   t)
((= -1234567890.0        -123.0) nil)
((= -1234567890.0           0.0) nil)
((= -1234567890.0         123.0) nil)
((= -1234567890.0  1234567890.0) nil)
((= -1234567890.0 *most-negative-float*) nil)
((= -1234567890.0 *most-positive-float*) nil)
((=        -123.0 -1234567890) nil)
((=        -123.0        -123)   t)
((=        -123.0           0) nil)
((=        -123.0         123) nil)
((=        -123.0  1234567890) nil)
((=        -123.0 -1234567890.0) nil)
((=        -123.0        -123.0)   t)
((=        -123.0           0.0) nil)
((=        -123.0         123.0) nil)
((=        -123.0  1234567890.0) nil)
((=        -123.0 *most-negative-float*) nil)
((=        -123.0 *most-positive-float*) nil)
((=           0.0 -1234567890) nil)
((=           0.0        -123) nil)
((=           0.0           0)   t)
((=           0.0         123) nil)
((=           0.0  1234567890) nil)
((=           0.0 -1234567890.0) nil)
((=           0.0        -123.0) nil)
((=           0.0           0.0)   t)
((=           0.0         123.0) nil)
((=           0.0  1234567890.0) nil)
((=           0.0 *most-negative-float*) nil)
((=           0.0 *most-positive-float*) nil)
((=         123.0 -1234567890) nil)
((=         123.0        -123) nil)
((=         123.0           0) nil)
((=         123.0         123)   t)
((=         123.0  1234567890) nil)
((=         123.0 -1234567890.0) nil)
((=         123.0        -123.0) nil)
((=         123.0           0.0) nil)
((=         123.0         123.0)   t)
((=         123.0  1234567890.0) nil)
((=         123.0 *most-negative-float*) nil)
((=         123.0 *most-positive-float*) nil)
((=  1234567890.0 -1234567890) nil)
((=  1234567890.0        -123) nil)
((=  1234567890.0           0) nil)
((=  1234567890.0         123) nil)
((=  1234567890.0  1234567890)   t)
((=  1234567890.0 -1234567890.0) nil)
((=  1234567890.0        -123.0) nil)
((=  1234567890.0           0.0) nil)
((=  1234567890.0         123.0) nil)
((=  1234567890.0  1234567890.0)   t)
((=  1234567890.0 *most-negative-float*) nil)
((=  1234567890.0 *most-positive-float*) nil)
((= *most-negative-float* -1234567890) nil)
((= *most-negative-float*        -123) nil)
((= *most-negative-float*           0) nil)
((= *most-negative-float*         123) nil)
((= *most-negative-float*  1234567890) nil)
((= *most-negative-float* -1234567890.0) nil)
((= *most-negative-float*        -123.0) nil)
((= *most-negative-float*           0.0) nil)
((= *most-negative-float*         123.0) nil)
((= *most-negative-float*  1234567890.0) nil)
((= *most-negative-float* *most-negative-float*)   t)
((= *most-negative-float* *most-positive-float*) nil)
((= *most-positive-float* -1234567890) nil)
((= *most-positive-float*        -123) nil)
((= *most-positive-float*           0) nil)
((= *most-positive-float*         123) nil)
((= *most-positive-float*  1234567890) nil)
((= *most-positive-float* -1234567890.0) nil)
((= *most-positive-float*        -123.0) nil)
((= *most-positive-float*           0.0) nil)
((= *most-positive-float*         123.0) nil)
((= *most-positive-float*  1234567890.0) nil)
((= *most-positive-float* *most-negative-float*) nil)
((= *most-positive-float* *most-positive-float*)   t)

;;;
;;; ֐ (/= x1 x2) --> boolean
;;;
($ap 2 "/=" P.68)
((/= 3 4) t)
((/= 3 3.0) nil)
((/= (parse-number "134.54") 134.54) nil)
;;;
($argc /= 2 0 0)
($type /= ($integer $float) :target 1)
($type /= ($integer $float) 1 :target)
;;;
((/= -1234567890 -1234567890) nil)
((/= -1234567890        -123)   t)
((/= -1234567890           0)   t)
((/= -1234567890         123)   t)
((/= -1234567890  1234567890)   t)
((/= -1234567890 -1234567890.0) nil)
((/= -1234567890        -123.0)   t)
((/= -1234567890           0.0)   t)
((/= -1234567890         123.0)   t)
((/= -1234567890  1234567890.0)   t)
((/= -1234567890 *most-negative-float*)   t)
((/= -1234567890 *most-positive-float*)   t)
((/=        -123 -1234567890)   t)
((/=        -123        -123) nil)
((/=        -123           0)   t)
((/=        -123         123)   t)
((/=        -123  1234567890)   t)
((/=        -123 -1234567890.0)   t)
((/=        -123        -123.0) nil)
((/=        -123           0.0)   t)
((/=        -123         123.0)   t)
((/=        -123  1234567890.0)   t)
((/=        -123 *most-negative-float*)   t)
((/=        -123 *most-positive-float*)   t)
((/=           0 -1234567890)   t)
((/=           0        -123)   t)
((/=           0           0) nil)
((/=           0         123)   t)
((/=           0  1234567890)   t)
((/=           0 -1234567890.0)   t)
((/=           0        -123.0)   t)
((/=           0           0.0) nil)
((/=           0         123.0)   t)
((/=           0  1234567890.0)   t)
((/=           0 *most-negative-float*)   t)
((/=           0 *most-positive-float*)   t)
((/=         123 -1234567890)   t)
((/=         123        -123)   t)
((/=         123           0)   t)
((/=         123         123) nil)
((/=         123  1234567890)   t)
((/=         123 -1234567890.0)   t)
((/=         123        -123.0)   t)
((/=         123           0.0)   t)
((/=         123         123.0) nil)
((/=         123  1234567890.0)   t)
((/=         123 *most-negative-float*)   t)
((/=         123 *most-positive-float*)   t)
((/=  1234567890 -1234567890)   t)
((/=  1234567890        -123)   t)
((/=  1234567890           0)   t)
((/=  1234567890         123)   t)
((/=  1234567890  1234567890) nil)
((/=  1234567890 -1234567890.0)   t)
((/=  1234567890        -123.0)   t)
((/=  1234567890           0.0)   t)
((/=  1234567890         123.0)   t)
((/=  1234567890  1234567890.0) nil)
((/=  1234567890 *most-negative-float*)   t)
((/=  1234567890 *most-positive-float*)   t)
((/= -1234567890.0 -1234567890) nil)
((/= -1234567890.0        -123)   t)
((/= -1234567890.0           0)   t)
((/= -1234567890.0         123)   t)
((/= -1234567890.0  1234567890)   t)
((/= -1234567890.0 -1234567890.0) nil)
((/= -1234567890.0        -123.0)   t)
((/= -1234567890.0           0.0)   t)
((/= -1234567890.0         123.0)   t)
((/= -1234567890.0  1234567890.0)   t)
((/= -1234567890.0 *most-negative-float*)   t)
((/= -1234567890.0 *most-positive-float*)   t)
((/=        -123.0 -1234567890)   t)
((/=        -123.0        -123) nil)
((/=        -123.0           0)   t)
((/=        -123.0         123)   t)
((/=        -123.0  1234567890)   t)
((/=        -123.0 -1234567890.0)   t)
((/=        -123.0        -123.0) nil)
((/=        -123.0           0.0)   t)
((/=        -123.0         123.0)   t)
((/=        -123.0  1234567890.0)   t)
((/=        -123.0 *most-negative-float*)   t)
((/=        -123.0 *most-positive-float*)   t)
((/=           0.0 -1234567890)   t)
((/=           0.0        -123)   t)
((/=           0.0           0) nil)
((/=           0.0         123)   t)
((/=           0.0  1234567890)   t)
((/=           0.0 -1234567890.0)   t)
((/=           0.0        -123.0)   t)
((/=           0.0           0.0) nil)
((/=           0.0         123.0)   t)
((/=           0.0  1234567890.0)   t)
((/=           0.0 *most-negative-float*)   t)
((/=           0.0 *most-positive-float*)   t)
((/=         123.0 -1234567890)   t)
((/=         123.0        -123)   t)
((/=         123.0           0)   t)
((/=         123.0         123) nil)
((/=         123.0  1234567890)   t)
((/=         123.0 -1234567890.0)   t)
((/=         123.0        -123.0)   t)
((/=         123.0           0.0)   t)
((/=         123.0         123.0) nil)
((/=         123.0  1234567890.0)   t)
((/=         123.0 *most-negative-float*)   t)
((/=         123.0 *most-positive-float*)   t)
((/=  1234567890.0 -1234567890)   t)
((/=  1234567890.0        -123)   t)
((/=  1234567890.0           0)   t)
((/=  1234567890.0         123)   t)
((/=  1234567890.0  1234567890) nil)
((/=  1234567890.0 -1234567890.0)   t)
((/=  1234567890.0        -123.0)   t)
((/=  1234567890.0           0.0)   t)
((/=  1234567890.0         123.0)   t)
((/=  1234567890.0  1234567890.0) nil)
((/=  1234567890.0 *most-negative-float*)   t)
((/=  1234567890.0 *most-positive-float*)   t)
((/= *most-negative-float* -1234567890)   t)
((/= *most-negative-float*        -123)   t)
((/= *most-negative-float*           0)   t)
((/= *most-negative-float*         123)   t)
((/= *most-negative-float*  1234567890)   t)
((/= *most-negative-float* -1234567890.0)   t)
((/= *most-negative-float*        -123.0)   t)
((/= *most-negative-float*           0.0)   t)
((/= *most-negative-float*         123.0)   t)
((/= *most-negative-float*  1234567890.0)   t)
((/= *most-negative-float* *most-negative-float*) nil)
((/= *most-negative-float* *most-positive-float*)   t)
((/= *most-positive-float* -1234567890)   t)
((/= *most-positive-float*        -123)   t)
((/= *most-positive-float*           0)   t)
((/= *most-positive-float*         123)   t)
((/= *most-positive-float*  1234567890)   t)
((/= *most-positive-float* -1234567890.0)   t)
((/= *most-positive-float*        -123.0)   t)
((/= *most-positive-float*           0.0)   t)
((/= *most-positive-float*         123.0)   t)
((/= *most-positive-float*  1234567890.0)   t)
((/= *most-positive-float* *most-negative-float*)   t)
((/= *most-positive-float* *most-positive-float*) nil)

;;;
;;; ֐ (>= x1 x2) --> boolean
;;;
($ap 2 ">=" P.68)
((>= 2 2) t)
((>= 2.0 2) t)
((>= -1 2) nil)
;;;
($argc >= 2 0 0)
($type >= ($integer $float) :target 1)
($type >= ($integer $float) 1 :target)
;;;
((>= -1234567890 -1234567891)   t)
((>= -1234567890 -1234567890)   t)
((>= -1234567890 -1234567889) nil)
((>= -1234567890        -123) nil)
((>= -1234567890           0) nil)
((>= -1234567890         123) nil)
((>= -1234567890  1234567889) nil)
((>= -1234567890  1234567890) nil)
((>= -1234567890  1234567891) nil)
((>= -1234567890 -1234567890.0)   t)
((>= -1234567890        -123.0) nil)
((>= -1234567890           0.0) nil)
((>= -1234567890         123.0) nil)
((>= -1234567890  1234567890.0) nil)
((>= -1234567890 *most-negative-float*)   t)
((>= -1234567890 *most-positive-float*) nil)
((>=        -123 -1234567890)   t)
((>=        -123        -124)   t)
((>=        -123        -123)   t)
((>=        -123        -122) nil)
((>=        -123           0) nil)
((>=        -123         122) nil)
((>=        -123         123) nil)
((>=        -123         124) nil)
((>=        -123  1234567890) nil)
((>=        -123 -1234567890.0)   t)
((>=        -123        -123.0)   t)
((>=        -123           0.0) nil)
((>=        -123         123.0) nil)
((>=        -123  1234567890.0) nil)
((>=        -123 *most-negative-float*)   t)
((>=        -123 *most-positive-float*) nil)
((>=           0 -1234567890)   t)
((>=           0        -123)   t)
((>=           0          -1)   t)
((>=           0           0)   t)
((>=           0           1) nil)
((>=           0         123) nil)
((>=           0  1234567890) nil)
((>=           0 -1234567890.0)   t)
((>=           0        -123.0)   t)
((>=           0           0.0)   t)
((>=           0         123.0) nil)
((>=           0  1234567890.0) nil)
((>=           0 *most-negative-float*)   t)
((>=           0 *most-positive-float*) nil)
((>=         123 -1234567890)   t)
((>=         123        -124)   t)
((>=         123        -123)   t)
((>=         123        -122)   t)
((>=         123           0)   t)
((>=         123         122)   t)
((>=         123         123)   t)
((>=         123         124) nil)
((>=         123  1234567890) nil)
((>=         123 -1234567890.0)   t)
((>=         123        -123.0)   t)
((>=         123           0.0)   t)
((>=         123         123.0)   t)
((>=         123  1234567890.0) nil)
((>=         123 *most-negative-float*)   t)
((>=         123 *most-positive-float*) nil)
((>=  1234567890 -1234567891)   t)
((>=  1234567890 -1234567890)   t)
((>=  1234567890 -1234567889)   t)
((>=  1234567890        -123)   t)
((>=  1234567890           0)   t)
((>=  1234567890         123)   t)
((>=  1234567890  1234567889)   t)
((>=  1234567890  1234567890)   t)
((>=  1234567890  1234567891) nil)
((>=  1234567890 -1234567890.0)   t)
((>=  1234567890        -123.0)   t)
((>=  1234567890           0.0)   t)
((>=  1234567890         123.0)   t)
((>=  1234567890  1234567890.0)   t)
((>=  1234567890 *most-negative-float*)   t)
((>=  1234567890 *most-positive-float*) nil)
((>= -1234567890.0 -1234567890)   t)
((>= -1234567890.0        -123) nil)
((>= -1234567890.0           0) nil)
((>= -1234567890.0         123) nil)
((>= -1234567890.0  1234567890) nil)
((>= -1234567890.0 -1234567890.0)   t)
((>= -1234567890.0        -123.0) nil)
((>= -1234567890.0           0.0) nil)
((>= -1234567890.0         123.0) nil)
((>= -1234567890.0  1234567890.0) nil)
((>= -1234567890.0 *most-negative-float*)   t)
((>= -1234567890.0 *most-positive-float*) nil)
((>=        -123.0 -1234567890)   t)
((>=        -123.0        -123)   t)
((>=        -123.0           0) nil)
((>=        -123.0         123) nil)
((>=        -123.0  1234567890) nil)
((>=        -123.0 -1234567890.0)   t)
((>=        -123.0        -123.0)   t)
((>=        -123.0           0.0) nil)
((>=        -123.0         123.0) nil)
((>=        -123.0  1234567890.0) nil)
((>=        -123.0 *most-negative-float*)   t)
((>=        -123.0 *most-positive-float*) nil)
((>=           0.0 -1234567890)   t)
((>=           0.0        -123)   t)
((>=           0.0           0)   t)
((>=           0.0         123) nil)
((>=           0.0  1234567890) nil)
((>=           0.0 -1234567890.0)   t)
((>=           0.0        -123.0)   t)
((>=           0.0           0.0)   t)
((>=           0.0         123.0) nil)
((>=           0.0  1234567890.0) nil)
((>=           0.0 *most-negative-float*)   t)
((>=           0.0 *most-positive-float*) nil)
((>=         123.0 -1234567890)   t)
((>=         123.0        -123)   t)
((>=         123.0           0)   t)
((>=         123.0         123)   t)
((>=         123.0  1234567890) nil)
((>=         123.0 -1234567890.0)   t)
((>=         123.0        -123.0)   t)
((>=         123.0           0.0)   t)
((>=         123.0         123.0)   t)
((>=         123.0  1234567890.0) nil)
((>=         123.0 *most-negative-float*)   t)
((>=         123.0 *most-positive-float*) nil)
((>=  1234567890.0 -1234567890)   t)
((>=  1234567890.0        -123)   t)
((>=  1234567890.0           0)   t)
((>=  1234567890.0         123)   t)
((>=  1234567890.0  1234567890)   t)
((>=  1234567890.0 -1234567890.0)   t)
((>=  1234567890.0        -123.0)   t)
((>=  1234567890.0           0.0)   t)
((>=  1234567890.0         123.0)   t)
((>=  1234567890.0  1234567890.0)   t)
((>=  1234567890.0 *most-negative-float*)   t)
((>=  1234567890.0 *most-positive-float*) nil)
((>= *most-negative-float* -1234567890) nil)
((>= *most-negative-float*        -123) nil)
((>= *most-negative-float*           0) nil)
((>= *most-negative-float*         123) nil)
((>= *most-negative-float*  1234567890) nil)
((>= *most-negative-float* -1234567890.0) nil)
((>= *most-negative-float*        -123.0) nil)
((>= *most-negative-float*           0.0) nil)
((>= *most-negative-float*         123.0) nil)
((>= *most-negative-float*  1234567890.0) nil)
((>= *most-negative-float* *most-negative-float*)   t)
((>= *most-negative-float* *most-positive-float*) nil)
((>= *most-positive-float* -1234567890)   t)
((>= *most-positive-float*        -123)   t)
((>= *most-positive-float*           0)   t)
((>= *most-positive-float*         123)   t)
((>= *most-positive-float*  1234567890)   t)
((>= *most-positive-float* -1234567890.0)   t)
((>= *most-positive-float*        -123.0)   t)
((>= *most-positive-float*           0.0)   t)
((>= *most-positive-float*         123.0)   t)
((>= *most-positive-float*  1234567890.0)   t)
((>= *most-positive-float* *most-negative-float*)   t)
((>= *most-positive-float* *most-positive-float*)   t)

;;;
;;; ֐ (<= x1 x2) --> boolean
;;;
($ap 2 "<=" P.68)
((<= -1 2) t)
((<= 2 -1) nil)
;;;
($argc <= 2 0 0)
($type <= ($integer $float) :target 1)
($type <= ($integer $float) 1 :target)
;;;
((<= -1234567890 -1234567891) nil)
((<= -1234567890 -1234567890)   t)
((<= -1234567890 -1234567889)   t)
((<= -1234567890        -123)   t)
((<= -1234567890           0)   t)
((<= -1234567890         123)   t)
((<= -1234567890  1234567889)   t)
((<= -1234567890  1234567890)   t)
((<= -1234567890  1234567891)   t)
((<= -1234567890 -1234567890.0)   t)
((<= -1234567890        -123.0)   t)
((<= -1234567890           0.0)   t)
((<= -1234567890         123.0)   t)
((<= -1234567890  1234567890.0)   t)
((<= -1234567890 *most-negative-float*) nil)
((<= -1234567890 *most-positive-float*)   t)
((<=        -123 -1234567890) nil)
((<=        -123        -124) nil)
((<=        -123        -123)   t)
((<=        -123        -122)   t)
((<=        -123           0)   t)
((<=        -123         122)   t)
((<=        -123         123)   t)
((<=        -123         124)   t)
((<=        -123  1234567890)   t)
((<=        -123 -1234567890.0) nil)
((<=        -123        -123.0)   t)
((<=        -123           0.0)   t)
((<=        -123         123.0)   t)
((<=        -123  1234567890.0)   t)
((<=        -123 *most-negative-float*) nil)
((<=        -123 *most-positive-float*)   t)
((<=           0 -1234567890) nil)
((<=           0        -123) nil)
((<=           0          -1) nil)
((<=           0           0)   t)
((<=           0           1)   t)
((<=           0         123)   t)
((<=           0  1234567890)   t)
((<=           0 -1234567890.0) nil)
((<=           0        -123.0) nil)
((<=           0           0.0)   t)
((<=           0         123.0)   t)
((<=           0  1234567890.0)   t)
((<=           0 *most-negative-float*) nil)
((<=           0 *most-positive-float*)   t)
((<=         123 -1234567890) nil)
((<=         123        -124) nil)
((<=         123        -123) nil)
((<=         123        -122) nil)
((<=         123           0) nil)
((<=         123         122) nil)
((<=         123         123)   t)
((<=         123         124)   t)
((<=         123  1234567890)   t)
((<=         123 -1234567890.0) nil)
((<=         123        -123.0) nil)
((<=         123           0.0) nil)
((<=         123         123.0)   t)
((<=         123  1234567890.0)   t)
((<=         123 *most-negative-float*) nil)
((<=         123 *most-positive-float*)   t)
((<=  1234567890 -1234567891) nil)
((<=  1234567890 -1234567890) nil)
((<=  1234567890 -1234567889) nil)
((<=  1234567890        -123) nil)
((<=  1234567890           0) nil)
((<=  1234567890         123) nil)
((<=  1234567890  1234567889) nil)
((<=  1234567890  1234567890)   t)
((<=  1234567890  1234567891)   t)
((<=  1234567890 -1234567890.0) nil)
((<=  1234567890        -123.0) nil)
((<=  1234567890           0.0) nil)
((<=  1234567890         123.0) nil)
((<=  1234567890  1234567890.0)   t)
((<=  1234567890 *most-negative-float*) nil)
((<=  1234567890 *most-positive-float*)   t)
((<= -1234567890.0 -1234567890)   t)
((<= -1234567890.0        -123)   t)
((<= -1234567890.0           0)   t)
((<= -1234567890.0         123)   t)
((<= -1234567890.0  1234567890)   t)
((<= -1234567890.0 -1234567890.0)   t)
((<= -1234567890.0        -123.0)   t)
((<= -1234567890.0           0.0)   t)
((<= -1234567890.0         123.0)   t)
((<= -1234567890.0  1234567890.0)   t)
((<= -1234567890.0 *most-negative-float*) nil)
((<= -1234567890.0 *most-positive-float*)   t)
((<=        -123.0 -1234567890) nil)
((<=        -123.0        -123)   t)
((<=        -123.0           0)   t)
((<=        -123.0         123)   t)
((<=        -123.0  1234567890)   t)
((<=        -123.0 -1234567890.0) nil)
((<=        -123.0        -123.0)   t)
((<=        -123.0           0.0)   t)
((<=        -123.0         123.0)   t)
((<=        -123.0  1234567890.0)   t)
((<=        -123.0 *most-negative-float*) nil)
((<=        -123.0 *most-positive-float*)   t)
((<=           0.0 -1234567890) nil)
((<=           0.0        -123) nil)
((<=           0.0           0)   t)
((<=           0.0         123)   t)
((<=           0.0  1234567890)   t)
((<=           0.0 -1234567890.0) nil)
((<=           0.0        -123.0) nil)
((<=           0.0           0.0)   t)
((<=           0.0         123.0)   t)
((<=           0.0  1234567890.0)   t)
((<=           0.0 *most-negative-float*) nil)
((<=           0.0 *most-positive-float*)   t)
((<=         123.0 -1234567890) nil)
((<=         123.0        -123) nil)
((<=         123.0           0) nil)
((<=         123.0         123)   t)
((<=         123.0  1234567890)   t)
((<=         123.0 -1234567890.0) nil)
((<=         123.0        -123.0) nil)
((<=         123.0           0.0) nil)
((<=         123.0         123.0)   t)
((<=         123.0  1234567890.0)   t)
((<=         123.0 *most-negative-float*) nil)
((<=         123.0 *most-positive-float*)   t)
((<=  1234567890.0 -1234567890) nil)
((<=  1234567890.0        -123) nil)
((<=  1234567890.0           0) nil)
((<=  1234567890.0         123) nil)
((<=  1234567890.0  1234567890)   t)
((<=  1234567890.0 -1234567890.0) nil)
((<=  1234567890.0        -123.0) nil)
((<=  1234567890.0           0.0) nil)
((<=  1234567890.0         123.0) nil)
((<=  1234567890.0  1234567890.0)   t)
((<=  1234567890.0 *most-negative-float*) nil)
((<=  1234567890.0 *most-positive-float*)   t)
((<= *most-negative-float* -1234567890)   t)
((<= *most-negative-float*        -123)   t)
((<= *most-negative-float*           0)   t)
((<= *most-negative-float*         123)   t)
((<= *most-negative-float*  1234567890)   t)
((<= *most-negative-float* -1234567890.0)   t)
((<= *most-negative-float*        -123.0)   t)
((<= *most-negative-float*           0.0)   t)
((<= *most-negative-float*         123.0)   t)
((<= *most-negative-float*  1234567890.0)   t)
((<= *most-negative-float* *most-negative-float*)   t)
((<= *most-negative-float* *most-positive-float*)   t)
((<= *most-positive-float* -1234567890) nil)
((<= *most-positive-float*        -123) nil)
((<= *most-positive-float*           0) nil)
((<= *most-positive-float*         123) nil)
((<= *most-positive-float*  1234567890) nil)
((<= *most-positive-float* -1234567890.0) nil)
((<= *most-positive-float*        -123.0) nil)
((<= *most-positive-float*           0.0) nil)
((<= *most-positive-float*         123.0) nil)
((<= *most-positive-float*  1234567890.0) nil)
((<= *most-positive-float* *most-negative-float*) nil)
((<= *most-positive-float* *most-positive-float*)   t)

;;;
;;; ֐ (> x1 x2) --> boolean
;;;
($ap 2 ">" P.68)
((> 2 2) nil)
((> 2.0 2) nil)
((> 2 -10) t)
((> 100 3) t)
;;;
($argc > 2 0 0)
($type > ($integer $float) :target 1)
($type > ($integer $float) 1 :target)
;;;
((> -1234567890 -1234567891)   t)
((> -1234567890 -1234567890) nil)
((> -1234567890 -1234567889) nil)
((> -1234567890        -123) nil)
((> -1234567890           0) nil)
((> -1234567890         123) nil)
((> -1234567890  1234567889) nil)
((> -1234567890  1234567890) nil)
((> -1234567890  1234567891) nil)
((> -1234567890 -1234567890.0) nil)
((> -1234567890        -123.0) nil)
((> -1234567890           0.0) nil)
((> -1234567890         123.0) nil)
((> -1234567890  1234567890.0) nil)
((> -1234567890 *most-negative-float*)   t)
((> -1234567890 *most-positive-float*) nil)
((>        -123 -1234567890)   t)
((>        -123        -124)   t)
((>        -123        -123) nil)
((>        -123        -122) nil)
((>        -123           0) nil)
((>        -123         122) nil)
((>        -123         123) nil)
((>        -123         124) nil)
((>        -123  1234567890) nil)
((>        -123 -1234567890.0)   t)
((>        -123        -123.0) nil)
((>        -123           0.0) nil)
((>        -123         123.0) nil)
((>        -123  1234567890.0) nil)
((>        -123 *most-negative-float*)   t)
((>        -123 *most-positive-float*) nil)
((>           0 -1234567890)   t)
((>           0        -123)   t)
((>           0          -1)   t)
((>           0           0) nil)
((>           0           1) nil)
((>           0         123) nil)
((>           0  1234567890) nil)
((>           0 -1234567890.0)   t)
((>           0        -123.0)   t)
((>           0           0.0) nil)
((>           0         123.0) nil)
((>           0  1234567890.0) nil)
((>           0 *most-negative-float*)   t)
((>           0 *most-positive-float*) nil)
((>         123 -1234567890)   t)
((>         123        -124)   t)
((>         123        -123)   t)
((>         123        -122)   t)
((>         123           0)   t)
((>         123         122)   t)
((>         123         123) nil)
((>         123         124) nil)
((>         123  1234567890) nil)
((>         123 -1234567890.0)   t)
((>         123        -123.0)   t)
((>         123           0.0)   t)
((>         123         123.0) nil)
((>         123  1234567890.0) nil)
((>         123 *most-negative-float*)   t)
((>         123 *most-positive-float*) nil)
((>  1234567890 -1234567891)   t)
((>  1234567890 -1234567890)   t)
((>  1234567890 -1234567889)   t)
((>  1234567890        -123)   t)
((>  1234567890           0)   t)
((>  1234567890         123)   t)
((>  1234567890  1234567889)   t)
((>  1234567890  1234567890) nil)
((>  1234567890  1234567891) nil)
((>  1234567890 -1234567890.0)   t)
((>  1234567890        -123.0)   t)
((>  1234567890           0.0)   t)
((>  1234567890         123.0)   t)
((>  1234567890  1234567890.0) nil)
((>  1234567890 *most-negative-float*)   t)
((>  1234567890 *most-positive-float*) nil)
((> -1234567890.0 -1234567890) nil)
((> -1234567890.0        -123) nil)
((> -1234567890.0           0) nil)
((> -1234567890.0         123) nil)
((> -1234567890.0  1234567890) nil)
((> -1234567890.0 -1234567890.0) nil)
((> -1234567890.0        -123.0) nil)
((> -1234567890.0           0.0) nil)
((> -1234567890.0         123.0) nil)
((> -1234567890.0  1234567890.0) nil)
((> -1234567890.0 *most-negative-float*)   t)
((> -1234567890.0 *most-positive-float*) nil)
((>        -123.0 -1234567890)   t)
((>        -123.0        -123) nil)
((>        -123.0           0) nil)
((>        -123.0         123) nil)
((>        -123.0  1234567890) nil)
((>        -123.0 -1234567890.0)   t)
((>        -123.0        -123.0) nil)
((>        -123.0           0.0) nil)
((>        -123.0         123.0) nil)
((>        -123.0  1234567890.0) nil)
((>        -123.0 *most-negative-float*)   t)
((>        -123.0 *most-positive-float*) nil)
((>           0.0 -1234567890)   t)
((>           0.0        -123)   t)
((>           0.0           0) nil)
((>           0.0         123) nil)
((>           0.0  1234567890) nil)
((>           0.0 -1234567890.0)   t)
((>           0.0        -123.0)   t)
((>           0.0           0.0) nil)
((>           0.0         123.0) nil)
((>           0.0  1234567890.0) nil)
((>           0.0 *most-negative-float*)   t)
((>           0.0 *most-positive-float*) nil)
((>         123.0 -1234567890)   t)
((>         123.0        -123)   t)
((>         123.0           0)   t)
((>         123.0         123) nil)
((>         123.0  1234567890) nil)
((>         123.0 -1234567890.0)   t)
((>         123.0        -123.0)   t)
((>         123.0           0.0)   t)
((>         123.0         123.0) nil)
((>         123.0  1234567890.0) nil)
((>         123.0 *most-negative-float*)   t)
((>         123.0 *most-positive-float*) nil)
((>  1234567890.0 -1234567890)   t)
((>  1234567890.0        -123)   t)
((>  1234567890.0           0)   t)
((>  1234567890.0         123)   t)
((>  1234567890.0  1234567890) nil)
((>  1234567890.0 -1234567890.0)   t)
((>  1234567890.0        -123.0)   t)
((>  1234567890.0           0.0)   t)
((>  1234567890.0         123.0)   t)
((>  1234567890.0  1234567890.0) nil)
((>  1234567890.0 *most-negative-float*)   t)
((>  1234567890.0 *most-positive-float*) nil)
((> *most-negative-float* -1234567890) nil)
((> *most-negative-float*        -123) nil)
((> *most-negative-float*           0) nil)
((> *most-negative-float*         123) nil)
((> *most-negative-float*  1234567890) nil)
((> *most-negative-float* -1234567890.0) nil)
((> *most-negative-float*        -123.0) nil)
((> *most-negative-float*           0.0) nil)
((> *most-negative-float*         123.0) nil)
((> *most-negative-float*  1234567890.0) nil)
((> *most-negative-float* *most-negative-float*) nil)
((> *most-negative-float* *most-positive-float*) nil)
((> *most-positive-float* -1234567890)   t)
((> *most-positive-float*        -123)   t)
((> *most-positive-float*           0)   t)
((> *most-positive-float*         123)   t)
((> *most-positive-float*  1234567890)   t)
((> *most-positive-float* -1234567890.0)   t)
((> *most-positive-float*        -123.0)   t)
((> *most-positive-float*           0.0)   t)
((> *most-positive-float*         123.0)   t)
((> *most-positive-float*  1234567890.0)   t)
((> *most-positive-float* *most-negative-float*)   t)
((> *most-positive-float* *most-positive-float*) nil)

;;;
;;; ֐ (< x1 x2) --> boolean
;;;
($ap 2 "<" P.68)
((< 2 2) nil)
((< 1 2) t)
;;;
($argc < 2 0 0)
($type < ($integer $float) :target 1)
($type < ($integer $float) 1 :target)
;;;
((< -1234567890 -1234567891) nil)
((< -1234567890 -1234567890) nil)
((< -1234567890 -1234567889)   t)
((< -1234567890        -123)   t)
((< -1234567890           0)   t)
((< -1234567890         123)   t)
((< -1234567890  1234567889)   t)
((< -1234567890  1234567890)   t)
((< -1234567890  1234567891)   t)
((< -1234567890 -1234567890.0) nil)
((< -1234567890        -123.0)   t)
((< -1234567890           0.0)   t)
((< -1234567890         123.0)   t)
((< -1234567890  1234567890.0)   t)
((< -1234567890 *most-negative-float*) nil)
((< -1234567890 *most-positive-float*)   t)
((<        -123 -1234567890) nil)
((<        -123        -124) nil)
((<        -123        -123) nil)
((<        -123        -122)   t)
((<        -123           0)   t)
((<        -123         122)   t)
((<        -123         123)   t)
((<        -123         124)   t)
((<        -123  1234567890)   t)
((<        -123 -1234567890.0) nil)
((<        -123        -123.0) nil)
((<        -123           0.0)   t)
((<        -123         123.0)   t)
((<        -123  1234567890.0)   t)
((<        -123 *most-negative-float*) nil)
((<        -123 *most-positive-float*)   t)
((<           0 -1234567890) nil)
((<           0        -123) nil)
((<           0          -1) nil)
((<           0           0) nil)
((<           0           1)   t)
((<           0         123)   t)
((<           0  1234567890)   t)
((<           0 -1234567890.0) nil)
((<           0        -123.0) nil)
((<           0           0.0) nil)
((<           0         123.0)   t)
((<           0  1234567890.0)   t)
((<           0 *most-negative-float*) nil)
((<           0 *most-positive-float*)   t)
((<         123 -1234567890) nil)
((<         123        -124) nil)
((<         123        -123) nil)
((<         123        -122) nil)
((<         123           0) nil)
((<         123         122) nil)
((<         123         123) nil)
((<         123         124)   t)
((<         123  1234567890)   t)
((<         123 -1234567890.0) nil)
((<         123        -123.0) nil)
((<         123           0.0) nil)
((<         123         123.0) nil)
((<         123  1234567890.0)   t)
((<         123 *most-negative-float*) nil)
((<         123 *most-positive-float*)   t)
((<  1234567890 -1234567891) nil)
((<  1234567890 -1234567890) nil)
((<  1234567890 -1234567889) nil)
((<  1234567890        -123) nil)
((<  1234567890           0) nil)
((<  1234567890         123) nil)
((<  1234567890  1234567889) nil)
((<  1234567890  1234567890) nil)
((<  1234567890  1234567891)   t)
((<  1234567890 -1234567890.0) nil)
((<  1234567890        -123.0) nil)
((<  1234567890           0.0) nil)
((<  1234567890         123.0) nil)
((<  1234567890  1234567890.0) nil)
((<  1234567890 *most-negative-float*) nil)
((<  1234567890 *most-positive-float*)   t)
((< -1234567890.0 -1234567890) nil)
((< -1234567890.0        -123)   t)
((< -1234567890.0           0)   t)
((< -1234567890.0         123)   t)
((< -1234567890.0  1234567890)   t)
((< -1234567890.0 -1234567890.0) nil)
((< -1234567890.0        -123.0)   t)
((< -1234567890.0           0.0)   t)
((< -1234567890.0         123.0)   t)
((< -1234567890.0  1234567890.0)   t)
((< -1234567890.0 *most-negative-float*) nil)
((< -1234567890.0 *most-positive-float*)   t)
((<        -123.0 -1234567890) nil)
((<        -123.0        -123) nil)
((<        -123.0           0)   t)
((<        -123.0         123)   t)
((<        -123.0  1234567890)   t)
((<        -123.0 -1234567890.0) nil)
((<        -123.0        -123.0) nil)
((<        -123.0           0.0)   t)
((<        -123.0         123.0)   t)
((<        -123.0  1234567890.0)   t)
((<        -123.0 *most-negative-float*) nil)
((<        -123.0 *most-positive-float*)   t)
((<           0.0 -1234567890) nil)
((<           0.0        -123) nil)
((<           0.0           0) nil)
((<           0.0         123)   t)
((<           0.0  1234567890)   t)
((<           0.0 -1234567890.0) nil)
((<           0.0        -123.0) nil)
((<           0.0           0.0) nil)
((<           0.0         123.0)   t)
((<           0.0  1234567890.0)   t)
((<           0.0 *most-negative-float*) nil)
((<           0.0 *most-positive-float*)   t)
((<         123.0 -1234567890) nil)
((<         123.0        -123) nil)
((<         123.0           0) nil)
((<         123.0         123) nil)
((<         123.0  1234567890)   t)
((<         123.0 -1234567890.0) nil)
((<         123.0        -123.0) nil)
((<         123.0           0.0) nil)
((<         123.0         123.0) nil)
((<         123.0  1234567890.0)   t)
((<         123.0 *most-negative-float*) nil)
((<         123.0 *most-positive-float*)   t)
((<  1234567890.0 -1234567890) nil)
((<  1234567890.0        -123) nil)
((<  1234567890.0           0) nil)
((<  1234567890.0         123) nil)
((<  1234567890.0  1234567890) nil)
((<  1234567890.0 -1234567890.0) nil)
((<  1234567890.0        -123.0) nil)
((<  1234567890.0           0.0) nil)
((<  1234567890.0         123.0) nil)
((<  1234567890.0  1234567890.0) nil)
((<  1234567890.0 *most-negative-float*) nil)
((<  1234567890.0 *most-positive-float*)   t)
((< *most-negative-float* -1234567890)   t)
((< *most-negative-float*        -123)   t)
((< *most-negative-float*           0)   t)
((< *most-negative-float*         123)   t)
((< *most-negative-float*  1234567890)   t)
((< *most-negative-float* -1234567890.0)   t)
((< *most-negative-float*        -123.0)   t)
((< *most-negative-float*           0.0)   t)
((< *most-negative-float*         123.0)   t)
((< *most-negative-float*  1234567890.0)   t)
((< *most-negative-float* *most-negative-float*) nil)
((< *most-negative-float* *most-positive-float*)   t)
((< *most-positive-float* -1234567890) nil)
((< *most-positive-float*        -123) nil)
((< *most-positive-float*           0) nil)
((< *most-positive-float*         123) nil)
((< *most-positive-float*  1234567890) nil)
((< *most-positive-float* -1234567890.0) nil)
((< *most-positive-float*        -123.0) nil)
((< *most-positive-float*           0.0) nil)
((< *most-positive-float*         123.0) nil)
((< *most-positive-float*  1234567890.0) nil)
((< *most-positive-float* *most-negative-float*) nil)
((< *most-positive-float* *most-positive-float*) nil)
($eval (defun eval-eql (x y) (eql x (eval y))))

;;;
;;; ֐ (+ x*) --> <number>
;;;
($ap 2 "+" P.69)
((+ 12 3) 15 eql)
((+ 1 2 3) 6 eql)
((+ 12 3.0) 15.0 eql)
((+ 4 0.0) 4.0 eql)
((+) 0 eql)
;;;
($argc + 0 0 1)
($type + ($integer $float) :target)
($type + ($integer $float) 0 :target)
($type + ($integer $float) 0 0 :target)
;;; 1 
((+ -8388609) -8388609 eql)
((+ -8388608) -8388608 eql)
((+        0)        0 eql)
((+  8388607)  8388607 eql)
((+  8388608)  8388608 eql)
((+ -123.45) -123.45 eql)
((+    0.0)     0.0  eql)
((+  123.45)  123.45 eql)
((+ *most-negative-float*) *most-negative-float* eval-eql)
((+ *most-positive-float*) *most-positive-float* eval-eql)
;;; 2 
((+ -10000000000 -10000000000)   -20000000000 eql)
((+ -10000000000     -8388609)   -10008388609 eql)
((+ -10000000000     -8388608)   -10008388608 eql)
((+ -10000000000           -1)   -10000000001 eql)
((+ -10000000000            0)   -10000000000 eql)
((+ -10000000000            1)    -9999999999 eql)
((+ -10000000000      8388607)    -9991611393 eql)
((+ -10000000000      8388608)    -9991611392 eql)
((+ -10000000000  10000000000)              0 eql)
((+ -10000000000 -10000000000.0) -20000000000.0 eql)
((+ -10000000000           -1.0) -10000000001.0 eql)
((+ -10000000000            0.0) -10000000000.0 eql)
((+ -10000000000            1.0)  -9999999999.0 eql)
((+ -10000000000  10000000000.0)            0.0 eql)
((+     -8388609 -10000000000)   -10008388609 eql)
((+     -8388609     -8388609)      -16777218 eql)
((+     -8388609     -8388608)      -16777217 eql)
((+     -8388609           -1)       -8388610 eql)
((+     -8388609            0)       -8388609 eql)
((+     -8388609            1)       -8388608 eql)
((+     -8388609      8388607)             -2 eql)
((+     -8388609      8388608)             -1 eql)
((+     -8388609  10000000000)     9991611391 eql)
((+     -8388609 -10000000000.0) -10008388609.0 eql)
((+     -8388609           -1.0)     -8388610.0 eql)
((+     -8388609            0.0)     -8388609.0 eql)
((+     -8388609            1.0)     -8388608.0 eql)
((+     -8388609  10000000000.0)   9991611391.0 eql)
((+     -8388608 -10000000000)   -10008388608 eql)
((+     -8388608     -8388609)      -16777217 eql)
((+     -8388608     -8388608)      -16777216 eql)
((+     -8388608           -1)       -8388609 eql)
((+     -8388608            0)       -8388608 eql)
((+     -8388608            1)       -8388607 eql)
((+     -8388608      8388607)             -1 eql)
((+     -8388608      8388608)              0 eql)
((+     -8388608  10000000000)     9991611392 eql)
((+     -8388608 -10000000000.0) -10008388608.0 eql)
((+     -8388608           -1.0)     -8388609.0 eql)
((+     -8388608            0.0)     -8388608.0 eql)
((+     -8388608            1.0)     -8388607.0 eql)
((+     -8388608  10000000000.0)   9991611392.0 eql)
((+           -1 -10000000000)   -10000000001 eql)
((+           -1     -8388609)       -8388610 eql)
((+           -1     -8388608)       -8388609 eql)
((+           -1           -1)             -2 eql)
((+           -1            0)             -1 eql)
((+           -1            1)              0 eql)
((+           -1      8388607)        8388606 eql)
((+           -1      8388608)        8388607 eql)
((+           -1  10000000000)     9999999999 eql)
((+           -1 -10000000000.0) -10000000001.0 eql)
((+           -1           -1.0)           -2.0 eql)
((+           -1            0.0)           -1.0 eql)
((+           -1            1.0)            0.0 eql)
((+           -1  10000000000.0)   9999999999.0 eql)
((+            0 -10000000000)   -10000000000 eql)
((+            0     -8388609)       -8388609 eql)
((+            0     -8388608)       -8388608 eql)
((+            0           -1)             -1 eql)
((+            0            0)              0 eql)
((+            0            1)              1 eql)
((+            0      8388607)        8388607 eql)
((+            0      8388608)        8388608 eql)
((+            0  10000000000)    10000000000 eql)
((+            0 -10000000000.0) -10000000000.0 eql)
((+            0           -1.0)           -1.0 eql)
((+            0            0.0)            0.0 eql)
((+            0            1.0)            1.0 eql)
((+            0  10000000000.0)  10000000000.0 eql)
((+            0 *most-negative-float*) *most-negative-float* eval-eql)
((+            0 *most-positive-float*) *most-positive-float* eval-eql)
((+            1 -10000000000)    -9999999999 eql)
((+            1     -8388609)       -8388608 eql)
((+            1     -8388608)       -8388607 eql)
((+            1           -1)              0 eql)
((+            1            0)              1 eql)
((+            1            1)              2 eql)
((+            1      8388607)        8388608 eql)
((+            1      8388608)        8388609 eql)
((+            1  10000000000)    10000000001 eql)
((+            1 -10000000000.0)  -9999999999.0 eql)
((+            1           -1.0)            0.0 eql)
((+            1            0.0)            1.0 eql)
((+            1            1.0)            2.0 eql)
((+            1  10000000000.0)  10000000001.0 eql)
((+      8388607 -10000000000)    -9991611393 eql)
((+      8388607     -8388609)             -2 eql)
((+      8388607     -8388608)             -1 eql)
((+      8388607           -1)        8388606 eql)
((+      8388607            0)        8388607 eql)
((+      8388607            1)        8388608 eql)
((+      8388607      8388607)       16777214 eql)
((+      8388607      8388608)       16777215 eql)
((+      8388607  10000000000)    10008388607 eql)
((+      8388607 -10000000000.0)  -9991611393.0 eql)
((+      8388607           -1.0)      8388606.0 eql)
((+      8388607            0.0)      8388607.0 eql)
((+      8388607            1.0)      8388608.0 eql)
((+      8388607  10000000000.0)  10008388607.0 eql)
((+      8388608 -10000000000)    -9991611392 eql)
((+      8388608     -8388609)             -1 eql)
((+      8388608     -8388608)              0 eql)
((+      8388608           -1)        8388607 eql)
((+      8388608            0)        8388608 eql)
((+      8388608            1)        8388609 eql)
((+      8388608      8388607)       16777215 eql)
((+      8388608      8388608)       16777216 eql)
((+      8388608  10000000000)    10008388608 eql)
((+      8388608 -10000000000.0)  -9991611392.0 eql)
((+      8388608           -1.0)      8388607.0 eql)
((+      8388608            0.0)      8388608.0 eql)
((+      8388608            1.0)      8388609.0 eql)
((+      8388608  10000000000.0)  10008388608.0 eql)
((+  10000000000 -10000000000)              0 eql)
((+  10000000000     -8388609)     9991611391 eql)
((+  10000000000     -8388608)     9991611392 eql)
((+  10000000000           -1)     9999999999 eql)
((+  10000000000            0)    10000000000 eql)
((+  10000000000            1)    10000000001 eql)
((+  10000000000      8388607)    10008388607 eql)
((+  10000000000      8388608)    10008388608 eql)
((+  10000000000  10000000000)    20000000000 eql)
((+  10000000000 -10000000000.0)              0.0 eql)
((+  10000000000           -1.0)     9999999999.0 eql)
((+  10000000000            0.0)    10000000000.0 eql)
((+  10000000000            1.0)    10000000001.0 eql)
((+  10000000000  10000000000.0)    20000000000.0 eql)
((+ -10000000000.0 -10000000000)   -20000000000.0 eql)
((+ -10000000000.0     -8388609)   -10008388609.0 eql)
((+ -10000000000.0     -8388608)   -10008388608.0 eql)
((+ -10000000000.0           -1)   -10000000001.0 eql)
((+ -10000000000.0            0)   -10000000000.0 eql)
((+ -10000000000.0            1)    -9999999999.0 eql)
((+ -10000000000.0      8388607)    -9991611393.0 eql)
((+ -10000000000.0      8388608)    -9991611392.0 eql)
((+ -10000000000.0  10000000000)              0.0 eql)
((+ -10000000000.0 -10000000000.0) -20000000000.0 eql)
((+ -10000000000.0           -1.0) -10000000001.0 eql)
((+ -10000000000.0            0.0) -10000000000.0 eql)
((+ -10000000000.0            1.0)  -9999999999.0 eql)
((+ -10000000000.0  10000000000.0)            0.0 eql)
((+           -1.0 -10000000000)   -10000000001.0 eql)
((+           -1.0     -8388609)       -8388610.0 eql)
((+           -1.0     -8388608)       -8388609.0 eql)
((+           -1.0           -1)             -2.0 eql)
((+           -1.0            0)             -1.0 eql)
((+           -1.0            1)              0.0 eql)
((+           -1.0      8388607)        8388606.0 eql)
((+           -1.0      8388608)        8388607.0 eql)
((+           -1.0  10000000000)     9999999999.0 eql)
((+           -1.0 -10000000000.0) -10000000001.0 eql)
((+           -1.0           -1.0)           -2.0 eql)
((+           -1.0            0.0)           -1.0 eql)
((+           -1.0            1.0)            0.0 eql)
((+           -1.0  10000000000.0)   9999999999.0 eql)
((+            0.0 -10000000000)   -10000000000.0 eql)
((+            0.0     -8388609)       -8388609.0 eql)
((+            0.0     -8388608)       -8388608.0 eql)
((+            0.0           -1)             -1.0 eql)
((+            0.0            0)              0.0 eql)
((+            0.0            1)              1.0 eql)
((+            0.0      8388607)        8388607.0 eql)
((+            0.0      8388608)        8388608.0 eql)
((+            0.0  10000000000)    10000000000.0 eql)
((+            0.0 -10000000000.0) -10000000000.0 eql)
((+            0.0           -1.0)           -1.0 eql)
((+            0.0            0.0)            0.0 eql)
((+            0.0            1.0)            1.0 eql)
((+            0.0  10000000000.0)  10000000000.0 eql)
((+            0.0 *most-negative-float*) *most-negative-float* eval-eql)
((+            0.0 *most-positive-float*) *most-positive-float* eval-eql)
((+            1.0 -10000000000)    -9999999999.0 eql)
((+            1.0     -8388609)       -8388608.0 eql)
((+            1.0     -8388608)       -8388607.0 eql)
((+            1.0           -1)              0.0 eql)
((+            1.0            0)              1.0 eql)
((+            1.0            1)              2.0 eql)
((+            1.0      8388607)        8388608.0 eql)
((+            1.0      8388608)        8388609.0 eql)
((+            1.0  10000000000)    10000000001.0 eql)
((+            1.0 -10000000000.0)  -9999999999.0 eql)
((+            1.0           -1.0)            0.0 eql)
((+            1.0            0.0)            1.0 eql)
((+            1.0            1.0)            2.0 eql)
((+            1.0  10000000000.0)  10000000001.0 eql)
((+  10000000000.0 -10000000000)              0.0 eql)
((+  10000000000.0     -8388609)     9991611391.0 eql)
((+  10000000000.0     -8388608)     9991611392.0 eql)
((+  10000000000.0           -1)     9999999999.0 eql)
((+  10000000000.0            0)    10000000000.0 eql)
((+  10000000000.0            1)    10000000001.0 eql)
((+  10000000000.0      8388607)    10008388607.0 eql)
((+  10000000000.0      8388608)    10008388608.0 eql)
((+  10000000000.0  10000000000)    20000000000.0 eql)
((+  10000000000.0 -10000000000.0)            0.0 eql)
((+  10000000000.0           -1.0)   9999999999.0 eql)
((+  10000000000.0            0.0)  10000000000.0 eql)
((+  10000000000.0            1.0)  10000000001.0 eql)
((+  10000000000.0  10000000000.0)  20000000000.0 eql)
((+ *most-negative-float* 0)   *most-negative-float* eval-eql)
((+ *most-negative-float* 0.0) *most-negative-float* eval-eql)
($error (+ *most-negative-float* *most-negative-float*) <floating-point-overflow>)
((+ *most-negative-float* *most-positive-float*) 0.0 eql)
((+ *most-positive-float* 0)   *most-positive-float* eval-eql)
((+ *most-positive-float* 0.0) *most-positive-float* eval-eql)
((+ *most-positive-float* *most-negative-float*) 0.0 eql)
($error (+ *most-positive-float* *most-positive-float*) <floating-point-overflow>)
;;; 3 
((+ 0 0 0) 0 eql)
((+ 0.0 0.0 0.0) 0.0 eql)
((+ 10 20 30) 60 eql)
((+ 10.0 20.0 30.0) 60.0 eql)

;;;
;;; ֐ (* x*) --> <number>
;;;
($ap 2 "*" P.69)
((* 12 3) 36 eql)
((* 12 3.0) 36.0 eql)
((* 4.0 0) 0.0 eql)
((* 2 3 4) 24 eql)
((*) 1 eql)
;;;
($argc * 0 0 1)
($type * ($integer $float) :target)
($type * ($integer $float) 0 :target)
($type * ($integer $float) 0 0 :target)
;;; 1 
((* -8388609) -8388609 eql)
((* -8388608) -8388608 eql)
((*        0)        0 eql)
((*  8388607)  8388607 eql)
((*  8388608)  8388608 eql)
((* -123.45) -123.45 eql)
((*    0.0)     0.0  eql)
((*  123.45)  123.45 eql)
((* *most-negative-float*) *most-negative-float* eval-eql)
((* *most-positive-float*) *most-positive-float* eval-eql)
;;; 2 
((* -10000000000 -10000000000)    100000000000000000000 eql)
((* -10000000000     -8388609)        83886090000000000 eql)
((* -10000000000     -8388608)        83886080000000000 eql)
((* -10000000000           -1)              10000000000 eql)
((* -10000000000            0)                        0 eql)
((* -10000000000            1)             -10000000000 eql)
((* -10000000000      8388607)       -83886070000000000 eql)
((* -10000000000      8388608)       -83886080000000000 eql)
((* -10000000000  10000000000)   -100000000000000000000 eql)
((* -10000000000 -10000000000.0)  100000000000000000000.0 eql)
((* -10000000000           -1.0)            10000000000.0 eql)
((* -10000000000            0.0)                      0.0 eql)
((* -10000000000            1.0)           -10000000000.0 eql)
((* -10000000000  10000000000.0) -100000000000000000000.0 eql)
($error (* -10000000000 *most-negative-float*) <floating-point-overflow>)
($error (* -10000000000 *most-positive-float*) <floating-point-overflow>)
((*     -8388609 -10000000000)        83886090000000000 eql)
((*     -8388609     -8388609)           70368760954881 eql)
((*     -8388609     -8388608)           70368752566272 eql)
((*     -8388609           -1)                  8388609 eql)
((*     -8388609            0)                        0 eql)
((*     -8388609            1)                 -8388609 eql)
((*     -8388609      8388607)          -70368744177663 eql)
((*     -8388609      8388608)          -70368752566272 eql)
((*     -8388609  10000000000)       -83886090000000000 eql)
((*     -8388609 -10000000000.0)      83886090000000000.0 eql)
((*     -8388609           -1.0)                8388609.0 eql)
((*     -8388609            0.0)                      0.0 eql)
((*     -8388609            1.0)               -8388609.0 eql)
((*     -8388609  10000000000.0)     -83886090000000000.0 eql)
($error (* -8388609 *most-negative-float*) <floating-point-overflow>)
($error (* -8388609 *most-positive-float*) <floating-point-overflow>)
((*     -8388608 -10000000000)        83886080000000000 eql)
((*     -8388608     -8388609)           70368752566272 eql)
((*     -8388608     -8388608)           70368744177664 eql)
((*     -8388608           -1)                  8388608 eql)
((*     -8388608            0)                        0 eql)
((*     -8388608            1)                 -8388608 eql)
((*     -8388608      8388607)          -70368735789056 eql)
((*     -8388608      8388608)          -70368744177664 eql)
((*     -8388608  10000000000)       -83886080000000000 eql)
((*     -8388608 -10000000000.0)      83886080000000000.0 eql)
((*     -8388608           -1.0)                8388608.0 eql)
((*     -8388608            0.0)                      0.0 eql)
((*     -8388608            1.0)               -8388608.0 eql)
((*     -8388608  10000000000.0)     -83886080000000000.0 eql)
($error (* -8388608 *most-negative-float*) <floating-point-overflow>)
($error (* -8388608 *most-positive-float*) <floating-point-overflow>)
((*           -1 -10000000000)              10000000000 eql)
((*           -1     -8388609)                  8388609 eql)
((*           -1     -8388608)                  8388608 eql)
((*           -1           -1)                        1 eql)
((*           -1            0)                        0 eql)
((*           -1            1)                       -1 eql)
((*           -1      8388607)                 -8388607 eql)
((*           -1      8388608)                 -8388608 eql)
((*           -1  10000000000)             -10000000000 eql)
((*           -1 -10000000000.0)            10000000000.0 eql)
((*           -1           -1.0)                      1.0 eql)
((*           -1            0.0)                      0.0 eql)
((*           -1            1.0)                     -1.0 eql)
((*           -1  10000000000.0)           -10000000000.0 eql)
((*           -1 *most-negative-float*) *most-positive-float* eval-eql)
((*           -1 *most-positive-float*) *most-negative-float* eval-eql)
((*            0 -10000000000)                        0 eql)
((*            0     -8388609)                        0 eql)
((*            0     -8388608)                        0 eql)
((*            0           -1)                        0 eql)
((*            0            0)                        0 eql)
((*            0            1)                        0 eql)
((*            0      8388607)                        0 eql)
((*            0      8388608)                        0 eql)
((*            0  10000000000)                        0 eql)
((*            0 -10000000000.0)                      0.0 eql)
((*            0           -1.0)                      0.0 eql)
((*            0            0.0)                      0.0 eql)
((*            0            1.0)                      0.0 eql)
((*            0  10000000000.0)                      0.0 eql)
((*            0 *most-negative-float*)               0.0 eql)
((*            0 *most-positive-float*)               0.0 eql)
((*            1 -10000000000)             -10000000000 eql)
((*            1     -8388609)                 -8388609 eql)
((*            1     -8388608)                 -8388608 eql)
((*            1           -1)                       -1 eql)
((*            1            0)                        0 eql)
((*            1            1)                        1 eql)
((*            1      8388607)                  8388607 eql)
((*            1      8388608)                  8388608 eql)
((*            1  10000000000)              10000000000 eql)
((*            1 -10000000000.0)           -10000000000.0 eql)
((*            1           -1.0)                     -1.0 eql)
((*            1            0.0)                      0.0 eql)
((*            1            1.0)                      1.0 eql)
((*            1  10000000000.0)            10000000000.0 eql)
((*            1 *most-negative-float*) *most-negative-float* eval-eql)
((*            1 *most-positive-float*) *most-positive-float* eval-eql)
((*      8388607 -10000000000)       -83886070000000000 eql)
((*      8388607     -8388609)          -70368744177663 eql)
((*      8388607     -8388608)          -70368735789056 eql)
((*      8388607           -1)                 -8388607 eql)
((*      8388607            0)                        0 eql)
((*      8388607            1)                  8388607 eql)
((*      8388607      8388607)           70368727400449 eql)
((*      8388607      8388608)           70368735789056 eql)
((*      8388607  10000000000)        83886070000000000 eql)
((*      8388607 -10000000000.0)     -83886070000000000.0 eql)
((*      8388607           -1.0)               -8388607.0 eql)
((*      8388607            0.0)                      0.0 eql)
((*      8388607            1.0)                8388607.0 eql)
((*      8388607  10000000000.0)      83886070000000000.0 eql)
($error (* 8388607 *most-negative-float*) <floating-point-overflow>)
($error (* 8388607 *most-positive-float*) <floating-point-overflow>)
((*      8388608 -10000000000)       -83886080000000000 eql)
((*      8388608     -8388609)          -70368752566272 eql)
((*      8388608     -8388608)          -70368744177664 eql)
((*      8388608           -1)                 -8388608 eql)
((*      8388608            0)                        0 eql)
((*      8388608            1)                  8388608 eql)
((*      8388608      8388607)           70368735789056 eql)
((*      8388608      8388608)           70368744177664 eql)
((*      8388608  10000000000)        83886080000000000 eql)
((*      8388608 -10000000000.0)     -83886080000000000.0 eql)
((*      8388608           -1.0)               -8388608.0 eql)
((*      8388608            0.0)                      0.0 eql)
((*      8388608            1.0)                8388608.0 eql)
((*      8388608  10000000000.0)      83886080000000000.0 eql)
($error (* 8388608 *most-negative-float*) <floating-point-overflow>)
($error (* 8388608 *most-positive-float*) <floating-point-overflow>)
((*  10000000000 -10000000000)   -100000000000000000000 eql)
((*  10000000000     -8388609)       -83886090000000000 eql)
((*  10000000000     -8388608)       -83886080000000000 eql)
((*  10000000000           -1)             -10000000000 eql)
((*  10000000000            0)                        0 eql)
((*  10000000000            1)              10000000000 eql)
((*  10000000000      8388607)        83886070000000000 eql)
((*  10000000000      8388608)        83886080000000000 eql)
((*  10000000000  10000000000)    100000000000000000000 eql)
((*  10000000000 -10000000000.0) -100000000000000000000.0 eql)
((*  10000000000           -1.0)           -10000000000.0 eql)
((*  10000000000            0.0)                      0.0 eql)
((*  10000000000            1.0)            10000000000.0 eql)
((*  10000000000  10000000000.0)  100000000000000000000.0 eql)
($error (* 10000000000 *most-negative-float*) <floating-point-overflow>)
($error (* 10000000000 *most-positive-float*) <floating-point-overflow>)
((* -10000000000.0 -10000000000)  100000000000000000000.0 eql)
((* -10000000000.0     -8388609)      83886090000000000.0 eql)
((* -10000000000.0     -8388608)      83886080000000000.0 eql)
((* -10000000000.0           -1)            10000000000.0 eql)
((* -10000000000.0            0)                      0.0 eql)
((* -10000000000.0            1)           -10000000000.0 eql)
((* -10000000000.0      8388607)     -83886070000000000.0 eql)
((* -10000000000.0      8388608)     -83886080000000000.0 eql)
((* -10000000000.0  10000000000) -100000000000000000000.0 eql)
((* -10000000000.0 -10000000000.0)  100000000000000000000.0 eql)
((* -10000000000.0           -1.0)            10000000000.0 eql)
((* -10000000000.0            0.0)                      0.0 eql)
((* -10000000000.0            1.0)           -10000000000.0 eql)
((* -10000000000.0  10000000000.0) -100000000000000000000.0 eql)
($error (* -10000000000.0 *most-negative-float*) <floating-point-overflow>)
($error (* -10000000000.0 *most-positive-float*) <floating-point-overflow>)
((*           -1.0 -10000000000)              10000000000.0 eql)
((*           -1.0     -8388609)                  8388609.0 eql)
((*           -1.0     -8388608)                  8388608.0 eql)
((*           -1.0           -1)                        1.0 eql)
((*           -1.0            0)                        0.0 eql)
((*           -1.0            1)                       -1.0 eql)
((*           -1.0      8388607)                 -8388607.0 eql)
((*           -1.0      8388608)                 -8388608.0 eql)
((*           -1.0  10000000000)             -10000000000.0 eql)
((*           -1.0 -10000000000.0)            10000000000.0 eql)
((*           -1.0           -1.0)                      1.0 eql)
((*           -1.0            0.0)                      0.0 eql)
((*           -1.0            1.0)                     -1.0 eql)
((*           -1.0  10000000000.0)           -10000000000.0 eql)
((*           -1.0 *most-negative-float*) *most-positive-float* eval-eql)
((*           -1.0 *most-positive-float*) *most-negative-float* eval-eql)
((*            0.0 -10000000000)                        0.0 eql)
((*            0.0     -8388609)                        0.0 eql)
((*            0.0     -8388608)                        0.0 eql)
((*            0.0           -1)                        0.0 eql)
((*            0.0            0)                        0.0 eql)
((*            0.0            1)                        0.0 eql)
((*            0.0      8388607)                        0.0 eql)
((*            0.0      8388608)                        0.0 eql)
((*            0.0  10000000000)                        0.0 eql)
((*            0.0 -10000000000.0)                      0.0 eql)
((*            0.0           -1.0)                      0.0 eql)
((*            0.0            0.0)                      0.0 eql)
((*            0.0            1.0)                      0.0 eql)
((*            0.0  10000000000.0)                      0.0 eql)
((*            0.0 *most-negative-float*)               0.0 eql)
((*            0.0 *most-positive-float*)               0.0 eql)
((*            1.0 -10000000000)             -10000000000.0 eql)
((*            1.0     -8388609)                 -8388609.0 eql)
((*            1.0     -8388608)                 -8388608.0 eql)
((*            1.0           -1)                       -1.0 eql)
((*            1.0            0)                        0.0 eql)
((*            1.0            1)                        1.0 eql)
((*            1.0      8388607)                  8388607.0 eql)
((*            1.0      8388608)                  8388608.0 eql)
((*            1.0  10000000000)              10000000000.0 eql)
((*            1.0 -10000000000.0)           -10000000000.0 eql)
((*            1.0           -1.0)                     -1.0 eql)
((*            1.0            0.0)                      0.0 eql)
((*            1.0            1.0)                      1.0 eql)
((*            1.0  10000000000.0)            10000000000.0 eql)
((*            1.0 *most-negative-float*) *most-negative-float* eval-eql)
((*            1.0 *most-positive-float*) *most-positive-float* eval-eql)
((*  10000000000.0 -10000000000)   -100000000000000000000.0 eql)
((*  10000000000.0     -8388609)       -83886090000000000.0 eql)
((*  10000000000.0     -8388608)       -83886080000000000.0 eql)
((*  10000000000.0           -1)             -10000000000.0 eql)
((*  10000000000.0            0)                        0.0 eql)
((*  10000000000.0            1)              10000000000.0 eql)
((*  10000000000.0      8388607)        83886070000000000.0 eql)
((*  10000000000.0      8388608)        83886080000000000.0 eql)
((*  10000000000.0  10000000000)    100000000000000000000.0 eql)
((*  10000000000.0 -10000000000.0) -100000000000000000000.0 eql)
((*  10000000000.0           -1.0)           -10000000000.0 eql)
((*  10000000000.0            0.0)                      0.0 eql)
((*  10000000000.0            1.0)            10000000000.0 eql)
((*  10000000000.0  10000000000.0)  100000000000000000000.0 eql)
($error (* 10000000000.0 *most-negative-float*) <floating-point-overflow>)
($error (* 10000000000.0 *most-positive-float*) <floating-point-overflow>)
($error (* *most-negative-float* -10000000000) <floating-point-overflow>)
($error (* *most-negative-float*     -8388609) <floating-point-overflow>)
($error (* *most-negative-float*     -8388608) <floating-point-overflow>)
((* *most-negative-float*           -1) *most-positive-float* eval-eql)
((* *most-negative-float*            0) 0.0 eql)
((* *most-negative-float*            1) *most-negative-float* eval-eql)
($error (* *most-negative-float*      8388607) <floating-point-overflow>)
($error (* *most-negative-float*      8388608) <floating-point-overflow>)
($error (* *most-negative-float*  10000000000) <floating-point-overflow>)
($error (* *most-negative-float* *most-negative-float*) <floating-point-overflow>)
($error (* *most-negative-float* *most-positive-float*) <floating-point-overflow>)
($error (* *most-positive-float* -10000000000) <floating-point-overflow>)
($error (* *most-positive-float*     -8388609) <floating-point-overflow>)
($error (* *most-positive-float*     -8388608) <floating-point-overflow>)
((* *most-positive-float*           -1) *most-negative-float* eval-eql)
((* *most-positive-float*            0) 0.0 eql)
((* *most-positive-float*            1) *most-positive-float* eval-eql)
($error (* *most-positive-float*      8388607) <floating-point-overflow>)
($error (* *most-positive-float*      8388608) <floating-point-overflow>)
($error (* *most-positive-float*  10000000000) <floating-point-overflow>)
($error (* *most-positive-float* *most-negative-float*) <floating-point-overflow>)
($error (* *most-positive-float* *most-positive-float*) <floating-point-overflow>)
;;;
($error (* -1e-300 -1e-300) <floating-point-underflow>)
($error (* -1e-300  1e-300) <floating-point-underflow>)
($error (*  1e-300 -1e-300) <floating-point-underflow>)
($error (*  1e-300  1e-300) <floating-point-underflow>)
;;; 3 
((* 0 0 0) 0 eql)
((* 0.0 0.0 0.0) 0.0 eql)
((* 10 20 30) 6000 eql)
((* 10.0 20.0 30.0) 6000.0 eql)

;;;
;;; ֐ (- x+) --> <number>
;;;
($ap 2 "-" P.69)
((- 1) -1 eql)
((- -4.0) 4.0 eql)
((- 4.0) -4.0 eql)
((eql (- 0.0) -0.0) t)
((eql (- -0.0) 0.0) t)
((- 1 2) -1 eql)
((- 92 43) 49 eql)
((- 2.3 -3.0) 5.3 eql)
((- 0.0 0.0) 0.0 eql)
((- 3 4 5) -6 eql)
;;;
($argc - 1 0 1)
($type - ($integer $float) :target)
($type - ($integer $float) 0 :target)
($type - ($integer $float) 0 0 :target)
;;; 1 
((- -10000000000)  10000000000 eql)
((-     -8388609)      8388609 eql)
((-     -8388608)      8388608 eql)
((-     -8388607)      8388607 eql)
((-            0)            0 eql)
((-      8388607)     -8388607 eql)
((-      8388608)     -8388608 eql)
((-      8388609)     -8388609 eql)
((-  10000000000) -10000000000 eql)
((- -123.45)  123.45 eql)
((-    0.0)     0.0  eql)
((-  123.45) -123.45 eql)
((- *most-negative-float*) *most-positive-float* eval-eql)
((- *most-positive-float*) *most-negative-float* eval-eql)
;;; 2 
((- -10000000000 -10000000000)              0 eql)
((- -10000000000     -8388609)    -9991611391 eql)
((- -10000000000     -8388608)    -9991611392 eql)
((- -10000000000           -1)    -9999999999 eql)
((- -10000000000            0)   -10000000000 eql)
((- -10000000000            1)   -10000000001 eql)
((- -10000000000      8388607)   -10008388607 eql)
((- -10000000000      8388608)   -10008388608 eql)
((- -10000000000  10000000000)   -20000000000 eql)
((- -10000000000 -10000000000.0)            0.0 eql)
((- -10000000000           -1.0)  -9999999999.0 eql)
((- -10000000000            0.0) -10000000000.0 eql)
((- -10000000000            1.0) -10000000001.0 eql)
((- -10000000000  10000000000.0) -20000000000.0 eql)
((-     -8388609 -10000000000)     9991611391 eql)
((-     -8388609     -8388609)              0 eql)
((-     -8388609     -8388608)             -1 eql)
((-     -8388609           -1)       -8388608 eql)
((-     -8388609            0)       -8388609 eql)
((-     -8388609            1)       -8388610 eql)
((-     -8388609      8388607)      -16777216 eql)
((-     -8388609      8388608)      -16777217 eql)
((-     -8388609  10000000000)   -10008388609 eql)
((-     -8388609 -10000000000.0)   9991611391.0 eql)
((-     -8388609           -1.0)     -8388608.0 eql)
((-     -8388609            0.0)     -8388609.0 eql)
((-     -8388609            1.0)     -8388610.0 eql)
((-     -8388609  10000000000.0) -10008388609.0 eql)
((-     -8388608 -10000000000)     9991611392 eql)
((-     -8388608     -8388609)              1 eql)
((-     -8388608     -8388608)              0 eql)
((-     -8388608           -1)       -8388607 eql)
((-     -8388608            0)       -8388608 eql)
((-     -8388608            1)       -8388609 eql)
((-     -8388608      8388607)      -16777215 eql)
((-     -8388608      8388608)      -16777216 eql)
((-     -8388608  10000000000)   -10008388608 eql)
((-     -8388608 -10000000000.0)   9991611392.0 eql)
((-     -8388608           -1.0)     -8388607.0 eql)
((-     -8388608            0.0)     -8388608.0 eql)
((-     -8388608            1.0)     -8388609.0 eql)
((-     -8388608  10000000000.0) -10008388608.0 eql)
((-           -1 -10000000000)     9999999999 eql)
((-           -1     -8388609)        8388608 eql)
((-           -1     -8388608)        8388607 eql)
((-           -1           -1)              0 eql)
((-           -1            0)             -1 eql)
((-           -1            1)             -2 eql)
((-           -1      8388607)       -8388608 eql)
((-           -1      8388608)       -8388609 eql)
((-           -1  10000000000)   -10000000001 eql)
((-           -1 -10000000000.0)   9999999999.0 eql)
((-           -1           -1.0)            0.0 eql)
((-           -1            0.0)           -1.0 eql)
((-           -1            1.0)           -2.0 eql)
((-           -1  10000000000.0) -10000000001.0 eql)
((-            0 -10000000000)    10000000000 eql)
((-            0     -8388609)        8388609 eql)
((-            0     -8388608)        8388608 eql)
((-            0           -1)              1 eql)
((-            0            0)              0 eql)
((-            0            1)             -1 eql)
((-            0      8388607)       -8388607 eql)
((-            0      8388608)       -8388608 eql)
((-            0  10000000000)   -10000000000 eql)
((-            0 -10000000000.0)  10000000000.0 eql)
((-            0           -1.0)            1.0 eql)
((-            0            0.0)            0.0 eql)
((-            0            1.0)           -1.0 eql)
((-            0  10000000000.0) -10000000000.0 eql)
((-            0 *most-negative-float*) *most-positive-float* eval-eql)
((-            0 *most-positive-float*) *most-negative-float* eval-eql)
((-            1 -10000000000)    10000000001 eql)
((-            1     -8388609)        8388610 eql)
((-            1     -8388608)        8388609 eql)
((-            1           -1)              2 eql)
((-            1            0)              1 eql)
((-            1            1)              0 eql)
((-            1      8388607)       -8388606 eql)
((-            1      8388608)       -8388607 eql)
((-            1  10000000000)    -9999999999 eql)
((-            1 -10000000000.0)  10000000001.0 eql)
((-            1           -1.0)            2.0 eql)
((-            1            0.0)            1.0 eql)
((-            1            1.0)            0.0 eql)
((-            1  10000000000.0)  -9999999999.0 eql)
((-      8388607 -10000000000)    10008388607 eql)
((-      8388607     -8388609)       16777216 eql)
((-      8388607     -8388608)       16777215 eql)
((-      8388607           -1)        8388608 eql)
((-      8388607            0)        8388607 eql)
((-      8388607            1)        8388606 eql)
((-      8388607      8388607)              0 eql)
((-      8388607      8388608)             -1 eql)
((-      8388607  10000000000)    -9991611393 eql)
((-      8388607 -10000000000.0)  10008388607.0 eql)
((-      8388607           -1.0)      8388608.0 eql)
((-      8388607            0.0)      8388607.0 eql)
((-      8388607            1.0)      8388606.0 eql)
((-      8388607  10000000000.0)  -9991611393.0 eql)
((-      8388608 -10000000000)    10008388608 eql)
((-      8388608     -8388609)       16777217 eql)
((-      8388608     -8388608)       16777216 eql)
((-      8388608           -1)        8388609 eql)
((-      8388608            0)        8388608 eql)
((-      8388608            1)        8388607 eql)
((-      8388608      8388607)              1 eql)
((-      8388608      8388608)              0 eql)
((-      8388608  10000000000)    -9991611392 eql)
((-      8388608 -10000000000.0)  10008388608.0 eql)
((-      8388608           -1.0)      8388609.0 eql)
((-      8388608            0.0)      8388608.0 eql)
((-      8388608            1.0)      8388607.0 eql)
((-      8388608  10000000000.0)  -9991611392.0 eql)
((-  10000000000 -10000000000)    20000000000 eql)
((-  10000000000     -8388609)    10008388609 eql)
((-  10000000000     -8388608)    10008388608 eql)
((-  10000000000           -1)    10000000001 eql)
((-  10000000000            0)    10000000000 eql)
((-  10000000000            1)     9999999999 eql)
((-  10000000000      8388607)     9991611393 eql)
((-  10000000000      8388608)     9991611392 eql)
((-  10000000000  10000000000)              0 eql)
((-  10000000000 -10000000000.0)    20000000000.0 eql)
((-  10000000000           -1.0)    10000000001.0 eql)
((-  10000000000            0.0)    10000000000.0 eql)
((-  10000000000            1.0)     9999999999.0 eql)
((-  10000000000  10000000000.0)              0.0 eql)
((- -10000000000.0 -10000000000)              0.0 eql)
((- -10000000000.0     -8388609)    -9991611391.0 eql)
((- -10000000000.0     -8388608)    -9991611392.0 eql)
((- -10000000000.0           -1)    -9999999999.0 eql)
((- -10000000000.0            0)   -10000000000.0 eql)
((- -10000000000.0            1)   -10000000001.0 eql)
((- -10000000000.0      8388607)   -10008388607.0 eql)
((- -10000000000.0      8388608)   -10008388608.0 eql)
((- -10000000000.0  10000000000)   -20000000000.0 eql)
((- -10000000000.0 -10000000000.0)            0.0 eql)
((- -10000000000.0           -1.0)  -9999999999.0 eql)
((- -10000000000.0            0.0) -10000000000.0 eql)
((- -10000000000.0            1.0) -10000000001.0 eql)
((- -10000000000.0  10000000000.0) -20000000000.0 eql)
((-           -1.0 -10000000000)     9999999999.0 eql)
((-           -1.0     -8388609)        8388608.0 eql)
((-           -1.0     -8388608)        8388607.0 eql)
((-           -1.0           -1)              0.0 eql)
((-           -1.0            0)             -1.0 eql)
((-           -1.0            1)             -2.0 eql)
((-           -1.0      8388607)       -8388608.0 eql)
((-           -1.0      8388608)       -8388609.0 eql)
((-           -1.0  10000000000)   -10000000001.0 eql)
((-           -1.0 -10000000000.0)   9999999999.0 eql)
((-           -1.0           -1.0)            0.0 eql)
((-           -1.0            0.0)           -1.0 eql)
((-           -1.0            1.0)           -2.0 eql)
((-           -1.0  10000000000.0) -10000000001.0 eql)
((-            0.0 -10000000000)    10000000000.0 eql)
((-            0.0     -8388609)        8388609.0 eql)
((-            0.0     -8388608)        8388608.0 eql)
((-            0.0           -1)              1.0 eql)
((-            0.0            0)              0.0 eql)
((-            0.0            1)             -1.0 eql)
((-            0.0      8388607)       -8388607.0 eql)
((-            0.0      8388608)       -8388608.0 eql)
((-            0.0  10000000000)   -10000000000.0 eql)
((-            0.0 -10000000000.0)  10000000000.0 eql)
((-            0.0           -1.0)            1.0 eql)
((-            0.0            0.0)            0.0 eql)
((-            0.0            1.0)           -1.0 eql)
((-            0.0  10000000000.0) -10000000000.0 eql)
((-            0.0 *most-negative-float*) *most-positive-float* eval-eql)
((-            0.0 *most-positive-float*) *most-negative-float* eval-eql)
((-            1.0 -10000000000)    10000000001.0 eql)
((-            1.0     -8388609)        8388610.0 eql)
((-            1.0     -8388608)        8388609.0 eql)
((-            1.0           -1)              2.0 eql)
((-            1.0            0)              1.0 eql)
((-            1.0            1)              0.0 eql)
((-            1.0      8388607)       -8388606.0 eql)
((-            1.0      8388608)       -8388607.0 eql)
((-            1.0  10000000000)    -9999999999.0 eql)
((-            1.0 -10000000000.0)  10000000001.0 eql)
((-            1.0           -1.0)            2.0 eql)
((-            1.0            0.0)            1.0 eql)
((-            1.0            1.0)            0.0 eql)
((-            1.0  10000000000.0)  -9999999999.0 eql)
((-  10000000000.0 -10000000000)    20000000000.0 eql)
((-  10000000000.0     -8388609)    10008388609.0 eql)
((-  10000000000.0     -8388608)    10008388608.0 eql)
((-  10000000000.0           -1)    10000000001.0 eql)
((-  10000000000.0            0)    10000000000.0 eql)
((-  10000000000.0            1)     9999999999.0 eql)
((-  10000000000.0      8388607)     9991611393.0 eql)
((-  10000000000.0      8388608)     9991611392.0 eql)
((-  10000000000.0  10000000000)              0.0 eql)
((-  10000000000.0 -10000000000.0)  20000000000.0 eql)
((-  10000000000.0           -1.0)  10000000001.0 eql)
((-  10000000000.0            0.0)  10000000000.0 eql)
((-  10000000000.0            1.0)   9999999999.0 eql)
((-  10000000000.0  10000000000.0)            0.0 eql)
((- *most-negative-float* 0)   *most-negative-float* eval-eql)
((- *most-negative-float* 0.0) *most-negative-float* eval-eql)
((- *most-negative-float* *most-negative-float*) 0.0 eql)
($error (- *most-negative-float* *most-positive-float*) <floating-point-overflow>)
((- *most-positive-float* 0)   *most-positive-float* eval-eql)
((- *most-positive-float* 0.0) *most-positive-float* eval-eql)
($error (- *most-positive-float* *most-negative-float*) <floating-point-overflow>)
((- *most-positive-float* *most-positive-float*) 0.0 eql)
;;; 3 
((- 0 0 0) 0 eql)
((- 0.0 0.0 0.0) 0.0 eql)
((- 10 20 30) -40 eql)
((- 10.0 20.0 30.0) -40.0 eql)

;;;
;;; ֐ (QUOTIENT dividend divisor+) --> <number>
;;;
($ap 2 "quotient" P.70)
((quotient 10 5) 2 eql)
((quotient 1 2) 0.5 eql)
((quotient 2 -0.5) -4.0 eql)
($error (quotient 0 0.0) <division-by-zero>)
((quotient 2 3 4) 0.16666666666666666 eql)
;;;
($argc quotient 2 0 1)
($type quotient ($integer $float) :target 1)
($type quotient ($integer $float) 0 :target)
($type quotient ($integer $float) 0 1 :target)
;;; 2 
((quotient -300000000000000000000   -400000000000000000000)                        0.75 eql)
((quotient -300000000000000000000   -300000000000000000000)                        1 eql)
((quotient -300000000000000000000   -200000000000000000000)                        1.5 eql)
((quotient -300000000000000000000             -30000000000)              10000000000 eql)
((quotient -300000000000000000000                       -3)    100000000000000000000 eql)
((quotient -300000000000000000000                        3)   -100000000000000000000 eql)
((quotient -300000000000000000000              30000000000)             -10000000000 eql)
((quotient -300000000000000000000    200000000000000000000)                       -1.5 eql)
((quotient -300000000000000000000    300000000000000000000)                       -1 eql)
((quotient -300000000000000000000    400000000000000000000)                       -0.75 eql)
((quotient -300000000000000000000   -300000000000000000000.0)                      1.0 eql)
((quotient -300000000000000000000             -30000000000.0)                      1.0e10 eql)
((quotient -300000000000000000000                       -3.0)                      1.0e20 eql)
((quotient -300000000000000000000                        3.0)                     -1.0e20 eql)
((quotient -300000000000000000000              30000000000.0)                     -1.0e10 eql)
((quotient -300000000000000000000    300000000000000000000.0)                     -1.0 eql)
((quotient           -30000000000   -300000000000000000000)                        1.0e-10 eql)
((quotient           -30000000000             -40000000000)                        0.75 eql)
((quotient           -30000000000             -30000000000)                        1 eql)
((quotient           -30000000000             -20000000000)                        1.5 eql)
((quotient           -30000000000                       -3)              10000000000 eql)
((quotient           -30000000000                        3)             -10000000000 eql)
((quotient           -30000000000              20000000000)                       -1.5 eql)
((quotient           -30000000000              30000000000)                       -1 eql)
((quotient           -30000000000              40000000000)                       -0.75 eql)
((quotient           -30000000000    300000000000000000000)                       -1.0e-10 eql)
((quotient           -30000000000   -300000000000000000000.0)                      1.0e-10 eql)
((quotient           -30000000000             -30000000000.0)                      1.0 eql)
((quotient           -30000000000                       -3.0)                      1.0e10 eql)
((quotient           -30000000000                        3.0)                     -1.0e10 eql)
((quotient           -30000000000              30000000000.0)                     -1.0 eql)
((quotient           -30000000000    300000000000000000000.0)                     -1.0e-10 eql)
((quotient                     -3   -300000000000000000000)                        1.0e-20 eql)
((quotient                     -3             -30000000000)                        1.0e-10 eql)
((quotient                     -3                       -4)                        0.75 eql)
((quotient                     -3                       -3)                        1 eql)
((quotient                     -3                       -2)                        1.5 eql)
((quotient                     -3                        2)                       -1.5 eql)
((quotient                     -3                        3)                       -1 eql)
((quotient                     -3                        4)                       -0.75 eql)
((quotient                     -3              30000000000)                       -1.0e-10 eql)
((quotient                     -3    300000000000000000000)                       -1.0e-20 eql)
((quotient                     -3   -300000000000000000000.0)                      1.0e-20 eql)
((quotient                     -3             -30000000000.0)                      1.0e-10 eql)
((quotient                     -3                       -3.0)                      1.0 eql)
((quotient                     -3                        3.0)                     -1.0 eql)
((quotient                     -3              30000000000.0)                     -1.0e-10 eql)
((quotient                     -3    300000000000000000000.0)                     -1.0e-20 eql)
((quotient                      0   -300000000000000000000)                        0 eql)
((quotient                      0             -30000000000)                        0 eql)
((quotient                      0                       -3)                        0 eql)
((quotient                      0                        3)                        0 eql)
((quotient                      0              30000000000)                        0 eql)
((quotient                      0    300000000000000000000)                        0 eql)
((quotient                      0   -300000000000000000000.0)                      0.0 eql)
((quotient                      0                       -3.0)                      0.0 eql)
((quotient                      0                        3.0)                      0.0 eql)
((quotient                      0    300000000000000000000.0)                      0.0 eql)
((quotient                      0 *most-negative-float*) 0.0 eql)
((quotient                      0 *most-positive-float*) 0.0 eql)
((quotient                      3   -300000000000000000000)                       -1.0e-20 eql)
((quotient                      3             -30000000000)                       -1.0e-10 eql)
((quotient                      3                       -4)                       -0.75 eql)
((quotient                      3                       -3)                       -1 eql)
((quotient                      3                       -2)                       -1.5 eql)
((quotient                      3                        2)                        1.5 eql)
((quotient                      3                        3)                        1 eql)
((quotient                      3                        4)                        0.75 eql)
((quotient                      3              30000000000)                        1.0e-10 eql)
((quotient                      3    300000000000000000000)                        1.0e-20 eql)
((quotient                      3   -300000000000000000000.0)                     -1.0e-20 eql)
((quotient                      3             -30000000000.0)                     -1.0e-10 eql)
((quotient                      3                       -3.0)                     -1.0 eql)
((quotient                      3                        3.0)                      1.0 eql)
((quotient                      3              30000000000.0)                      1.0e-10 eql)
((quotient                      3    300000000000000000000.0)                      1.0e-20 eql)
((quotient            30000000000   -300000000000000000000)                       -1.0e-10 eql)
((quotient            30000000000             -40000000000)                       -0.75 eql)
((quotient            30000000000             -30000000000)                       -1 eql)
((quotient            30000000000             -20000000000)                       -1.5 eql)
((quotient            30000000000                       -3)             -10000000000 eql)
((quotient            30000000000                        3)              10000000000 eql)
((quotient            30000000000              20000000000)                        1.5 eql)
((quotient            30000000000              30000000000)                        1 eql)
((quotient            30000000000              40000000000)                        0.75 eql)
((quotient            30000000000    300000000000000000000)                        1.0e-10 eql)
((quotient            30000000000   -300000000000000000000.0)                     -1.0e-10 eql)
((quotient            30000000000             -30000000000.0)                     -1.0 eql)
((quotient            30000000000                       -3.0)                     -1.0e10 eql)
((quotient            30000000000                        3.0)                      1.0e10 eql)
((quotient            30000000000              30000000000.0)                      1.0 eql)
((quotient            30000000000    300000000000000000000.0)                      1.0e-10 eql)
((quotient  300000000000000000000   -400000000000000000000)                       -0.75 eql)
((quotient  300000000000000000000   -300000000000000000000)                       -1 eql)
((quotient  300000000000000000000   -200000000000000000000)                       -1.5 eql)
((quotient  300000000000000000000             -30000000000)             -10000000000 eql)
((quotient  300000000000000000000                       -3)   -100000000000000000000 eql)
((quotient  300000000000000000000                        3)    100000000000000000000 eql)
((quotient  300000000000000000000              30000000000)              10000000000 eql)
((quotient  300000000000000000000    200000000000000000000)                        1.5 eql)
((quotient  300000000000000000000    300000000000000000000)                        1 eql)
((quotient  300000000000000000000    400000000000000000000)                        0.75 eql)
((quotient  300000000000000000000   -300000000000000000000.0)                     -1.0 eql)
((quotient  300000000000000000000             -30000000000.0)                     -1.0e10 eql)
((quotient  300000000000000000000                       -3.0)                     -1.0e20 eql)
((quotient  300000000000000000000                        3.0)                      1.0e20 eql)
((quotient  300000000000000000000              30000000000.0)                      1.0e10 eql)
((quotient  300000000000000000000    300000000000000000000.0)                      1.0 eql)
((quotient -300000000000000000000.0 -400000000000000000000)                        0.75 eql)
((quotient -300000000000000000000.0 -300000000000000000000)                        1.0 eql)
((quotient -300000000000000000000.0 -200000000000000000000)                        1.5 eql)
((quotient -300000000000000000000.0           -30000000000)              10000000000.0 eql)
((quotient -300000000000000000000.0                     -3)    100000000000000000000.0 eql)
((quotient -300000000000000000000.0                      3)   -100000000000000000000.0 eql)
((quotient -300000000000000000000.0            30000000000)             -10000000000.0 eql)
((quotient -300000000000000000000.0  200000000000000000000)                       -1.5 eql)
((quotient -300000000000000000000.0  300000000000000000000)                       -1.0 eql)
((quotient -300000000000000000000.0  400000000000000000000)                       -0.75 eql)
((quotient -300000000000000000000.0 -300000000000000000000.0)                      1.0 eql)
((quotient -300000000000000000000.0           -30000000000.0)                      1.0e10 eql)
((quotient -300000000000000000000.0                     -3.0)                      1.0e20 eql)
((quotient -300000000000000000000.0                      3.0)                     -1.0e20 eql)
((quotient -300000000000000000000.0            30000000000.0)                     -1.0e10 eql)
((quotient -300000000000000000000.0  300000000000000000000.0)                     -1.0 eql)
((quotient           -30000000000.0 -300000000000000000000)                        1.0e-10 eql)
((quotient           -30000000000.0           -40000000000)                        0.75 eql)
((quotient           -30000000000.0           -30000000000)                        1.0 eql)
((quotient           -30000000000.0           -20000000000)                        1.5 eql)
((quotient           -30000000000.0                     -3)              10000000000.0 eql)
((quotient           -30000000000.0                      3)             -10000000000.0 eql)
((quotient           -30000000000.0            20000000000)                       -1.5 eql)
((quotient           -30000000000.0            30000000000)                       -1.0 eql)
((quotient           -30000000000.0            40000000000)                       -0.75 eql)
((quotient           -30000000000.0  300000000000000000000)                       -1.0e-10 eql)
((quotient           -30000000000.0 -300000000000000000000.0)                      1.0e-10 eql)
((quotient           -30000000000.0           -30000000000.0)                      1.0 eql)
((quotient           -30000000000.0                     -3.0)                      1.0e10 eql)
((quotient           -30000000000.0                      3.0)                     -1.0e10 eql)
((quotient           -30000000000.0            30000000000.0)                     -1.0 eql)
((quotient           -30000000000.0  300000000000000000000.0)                     -1.0e-10 eql)
((quotient                     -3.0 -300000000000000000000)                        1.0e-20 eql)
((quotient                     -3.0           -30000000000)                        1.0e-10 eql)
((quotient                     -3.0                     -4)                        0.75 eql)
((quotient                     -3.0                     -3)                        1.0 eql)
((quotient                     -3.0                     -2)                        1.5 eql)
((quotient                     -3.0                      2)                       -1.5 eql)
((quotient                     -3.0                      3)                       -1.0 eql)
((quotient                     -3.0                      4)                       -0.75 eql)
((quotient                     -3.0            30000000000)                       -1.0e-10 eql)
((quotient                     -3.0  300000000000000000000)                       -1.0e-20 eql)
((quotient                     -3.0 -300000000000000000000.0)                      1.0e-20 eql)
((quotient                     -3.0           -30000000000.0)                      1.0e-10 eql)
((quotient                     -3.0                     -3.0)                      1.0 eql)
((quotient                     -3.0                      3.0)                     -1.0 eql)
((quotient                     -3.0            30000000000.0)                     -1.0e-10 eql)
((quotient                     -3.0  300000000000000000000.0)                     -1.0e-20 eql)
((quotient                      0.0 -300000000000000000000)                        0.0 eql)
((quotient                      0.0           -30000000000)                        0.0 eql)
((quotient                      0.0                     -3)                        0.0 eql)
((quotient                      0.0                      3)                        0.0 eql)
((quotient                      0.0            30000000000)                        0.0 eql)
((quotient                      0.0  300000000000000000000)                        0.0 eql)
((quotient                      0.0 -300000000000000000000.0)                      0.0 eql)
((quotient                      0.0                     -3.0)                      0.0 eql)
((quotient                      0.0                      3.0)                      0.0 eql)
((quotient                      0.0  300000000000000000000.0)                      0.0 eql)
((quotient                      0.0 *most-negative-float*) 0.0 eql)
((quotient                      0.0 *most-positive-float*) 0.0 eql)
((quotient                      3.0 -300000000000000000000)                       -1.0e-20 eql)
((quotient                      3.0           -30000000000)                       -1.0e-10 eql)
((quotient                      3.0                     -4)                       -0.75 eql)
((quotient                      3.0                     -3)                       -1.0 eql)
((quotient                      3.0                     -2)                       -1.5 eql)
((quotient                      3.0                      2)                        1.5 eql)
((quotient                      3.0                      3)                        1.0 eql)
((quotient                      3.0                      4)                        0.75 eql)
((quotient                      3.0            30000000000)                        1.0e-10 eql)
((quotient                      3.0  300000000000000000000)                        1.0e-20 eql)
((quotient                      3.0 -300000000000000000000.0)                     -1.0e-20 eql)
((quotient                      3.0           -30000000000.0)                     -1.0e-10 eql)
((quotient                      3.0                     -3.0)                     -1.0 eql)
((quotient                      3.0                      3.0)                      1.0 eql)
((quotient                      3.0            30000000000.0)                      1.0e-10 eql)
((quotient                      3.0  300000000000000000000.0)                      1.0e-20 eql)
((quotient            30000000000.0 -300000000000000000000)                       -1.0e-10 eql)
((quotient            30000000000.0           -40000000000)                       -0.75 eql)
((quotient            30000000000.0           -30000000000)                       -1.0 eql)
((quotient            30000000000.0           -20000000000)                       -1.5 eql)
((quotient            30000000000.0                     -3)             -10000000000.0 eql)
((quotient            30000000000.0                      3)              10000000000.0 eql)
((quotient            30000000000.0            20000000000)                        1.5 eql)
((quotient            30000000000.0            30000000000)                        1.0 eql)
((quotient            30000000000.0            40000000000)                        0.75 eql)
((quotient            30000000000.0  300000000000000000000)                        1.0e-10 eql)
((quotient            30000000000.0 -300000000000000000000.0)                     -1.0e-10 eql)
((quotient            30000000000.0           -30000000000.0)                     -1.0 eql)
((quotient            30000000000.0                     -3.0)                     -1.0e10 eql)
((quotient            30000000000.0                      3.0)                      1.0e10 eql)
((quotient            30000000000.0            30000000000.0)                      1.0 eql)
((quotient            30000000000.0  300000000000000000000.0)                      1.0e-10 eql)
((quotient  300000000000000000000.0 -400000000000000000000)                       -0.75 eql)
((quotient  300000000000000000000.0 -300000000000000000000)                       -1.0 eql)
((quotient  300000000000000000000.0 -200000000000000000000)                       -1.5 eql)
((quotient  300000000000000000000.0           -30000000000)             -10000000000.0 eql)
((quotient  300000000000000000000.0                     -3)   -100000000000000000000.0 eql)
((quotient  300000000000000000000.0                      3)    100000000000000000000.0 eql)
((quotient  300000000000000000000.0            30000000000)              10000000000.0 eql)
((quotient  300000000000000000000.0  200000000000000000000)                        1.5 eql)
((quotient  300000000000000000000.0  300000000000000000000)                        1.0 eql)
((quotient  300000000000000000000.0  400000000000000000000)                        0.75 eql)
((quotient  300000000000000000000.0 -300000000000000000000.0)                     -1.0 eql)
((quotient  300000000000000000000.0           -30000000000.0)                     -1.0e10 eql)
((quotient  300000000000000000000.0                     -3.0)                     -1.0e20 eql)
((quotient  300000000000000000000.0                      3.0)                      1.0e20 eql)
((quotient  300000000000000000000.0            30000000000.0)                      1.0e10 eql)
((quotient  300000000000000000000.0  300000000000000000000.0)                      1.0 eql)
;;;
($error (quotient -300000000000000000000   0)   <division-by-zero>)
($error (quotient           -30000000000   0)   <division-by-zero>)
($error (quotient                     -3   0)   <division-by-zero>)
($error (quotient                      0   0)   <division-by-zero>)
($error (quotient                      3   0)   <division-by-zero>)
($error (quotient            30000000000   0)   <division-by-zero>)
($error (quotient  300000000000000000000   0)   <division-by-zero>)
($error (quotient -300000000000000000000.0 0)   <division-by-zero>)
($error (quotient                     -3.0 0)   <division-by-zero>)
($error (quotient                      0.0 0)   <division-by-zero>)
($error (quotient                      3.0 0)   <division-by-zero>)
($error (quotient  300000000000000000000.0 0)   <division-by-zero>)
($error (quotient *most-negative-float*    0)   <division-by-zero>)
($error (quotient *most-positive-float*    0)   <division-by-zero>)
;;;
($error (quotient -300000000000000000000   0.0) <division-by-zero>)
($error (quotient           -30000000000   0.0) <division-by-zero>)
($error (quotient                     -3   0.0) <division-by-zero>)
($error (quotient                      0   0.0) <division-by-zero>)
($error (quotient                      3   0.0) <division-by-zero>)
($error (quotient            30000000000   0.0) <division-by-zero>)
($error (quotient  300000000000000000000   0.0) <division-by-zero>)
($error (quotient -300000000000000000000.0 0.0) <division-by-zero>)
($error (quotient                     -3.0 0.0) <division-by-zero>)
($error (quotient                      0.0 0.0) <division-by-zero>)
($error (quotient                      3.0 0.0) <division-by-zero>)
($error (quotient  300000000000000000000.0 0.0) <division-by-zero>)
($error (quotient *most-negative-float*    0.0) <division-by-zero>)
($error (quotient *most-positive-float*    0.0) <division-by-zero>)
;;;
((quotient *most-negative-float* -1) *most-positive-float* eval-eql)
((quotient *most-negative-float*  1) *most-negative-float* eval-eql)
((quotient *most-negative-float* *most-negative-float*)  1.0 eql)
((quotient *most-negative-float* *most-positive-float*) -1.0 eql)
;;;
((quotient *most-positive-float* -1) *most-negative-float* eval-eql)
((quotient *most-positive-float*  1) *most-positive-float* eval-eql)
((quotient *most-positive-float* *most-negative-float*) -1.0 eql)
((quotient *most-positive-float* *most-positive-float*)  1.0 eql)
;;;
($error (quotient   1 *most-negative-float*) <floating-point-underflow>)
($error (quotient   1 *most-positive-float*) <floating-point-underflow>)
($error (quotient  -1 *most-negative-float*) <floating-point-underflow>)
($error (quotient  -1 *most-positive-float*) <floating-point-underflow>)
($error (quotient   1.0 *most-negative-float*) <floating-point-underflow>)
($error (quotient   1.0 *most-positive-float*) <floating-point-underflow>)
($error (quotient  -1.0 *most-negative-float*) <floating-point-underflow>)
($error (quotient  -1.0 *most-positive-float*) <floating-point-underflow>)
;;;
($error (quotient *most-negative-float*  0.1) <floating-point-overflow>)
($error (quotient *most-negative-float* -0.1) <floating-point-overflow>)
($error (quotient *most-positive-float*  0.1) <floating-point-overflow>)
($error (quotient *most-positive-float* -0.1) <floating-point-overflow>)

;;;
;;; ֐ (RECIPROCAL x) --> <number>
;;;
($ap 2 "reciprocal" P.70)
((reciprocal 2) 0.5 eql)
;;;
($argc reciprocal 1 0 0)
($type reciprocal ($integer $float) :target)
;;;
((reciprocal -10000000000) -1.0e-10 eql)
((reciprocal         -100) -0.01 eql)
((reciprocal           -1) -1 eql)
($error (reciprocal            0) <division-by-zero>)
((reciprocal            1)  1 eql)
((reciprocal          100)  0.01 eql)
((reciprocal  10000000000)  1.0e-10 eql)
((reciprocal         -100.0) -0.01 eql)
((reciprocal           -1.0) -1.0 eql)
($error (reciprocal            0.0) <division-by-zero>)
((reciprocal            1.0)  1.0 eql)
((reciprocal          100.0)  0.01 eql)
($error (reciprocal *most-negative-float*) <floating-point-underflow>)
($error (reciprocal *most-positive-float*) <floating-point-underflow>)
($eval (defun ~eql (x y)
         (let* ((str1 (convert x <string>))
                (str2 (convert y <string>))
                (len (- (min (length str1) (length str2)) 1)))
           (string= (subseq str1 0 len) (subseq str2 0 len)))))

;;;
;;; ֐ (MAX x+) --> <number>
;;;
($ap 2 "max" P.70)
((max -5 3) 3 eql)
((max 2.0 3) 3 eql)
;;((max 2 2.0) 2 =)					; 2 or 2.0 (IDEF)
((max 1 5 2 4 3) 5 eql)
;;;
($argc max 1 0 1)
($type max ($integer $float) :target)
($type max ($integer $float) 0 :target)
;;; 1 
((max -10000000000) -10000000000 eql)
((max     -8388609)     -8388609 eql)
((max     -8388608)     -8388608 eql)
((max           -1)           -1 eql)
((max            0)            0 eql)
((max            1)            1 eql)
((max      8388607)      8388607 eql)
((max      8388608)      8388608 eql)
((max  10000000000)  10000000000 eql)
((max      -1234.5)      -1234.5 eql)
((max          0.0)          0.0 eql)
((max       1234.5)       1234.5 eql)
((max *most-negative-float*) *most-negative-float* eval-eql)
((max *most-positive-float*) *most-positive-float* eval-eql)
;;; 2 
((max -10000000000 -10000000000) -10000000000 eql)
((max -10000000000     -8388609)     -8388609 eql)
((max -10000000000     -8388608)     -8388608 eql)
((max -10000000000           -1)           -1 eql)
((max -10000000000            0)            0 eql)
((max -10000000000            1)            1 eql)
((max -10000000000      8388607)      8388607 eql)
((max -10000000000      8388608)      8388608 eql)
((max -10000000000  10000000000)  10000000000 eql)
((max -10000000000      -1234.5)      -1234.5 eql)
((max -10000000000          0.0)          0.0 eql)
((max -10000000000       1234.5)       1234.5 eql)
((max -10000000000 *most-negative-float*) -10000000000 eql)
((max -10000000000 *most-positive-float*) *most-positive-float* eval-eql)
((max     -8388609 -10000000000)     -8388609 eql)
((max     -8388609     -8388609)     -8388609 eql)
((max     -8388609     -8388608)     -8388608 eql)
((max     -8388609           -1)           -1 eql)
((max     -8388609            0)            0 eql)
((max     -8388609            1)            1 eql)
((max     -8388609      8388607)      8388607 eql)
((max     -8388609      8388608)      8388608 eql)
((max     -8388609  10000000000)  10000000000 eql)
((max     -8388609      -1234.5)      -1234.5 eql)
((max     -8388609          0.0)          0.0 eql)
((max     -8388609       1234.5)       1234.5 eql)
((max     -8388609 *most-negative-float*) -8388609 eql)
((max     -8388609 *most-positive-float*) *most-positive-float* eval-eql)
((max     -8388608 -10000000000)     -8388608 eql)
((max     -8388608     -8388609)     -8388608 eql)
((max     -8388608     -8388608)     -8388608 eql)
((max     -8388608           -1)           -1 eql)
((max     -8388608            0)            0 eql)
((max     -8388608            1)            1 eql)
((max     -8388608      8388607)      8388607 eql)
((max     -8388608      8388608)      8388608 eql)
((max     -8388608  10000000000)  10000000000 eql)
((max     -8388608      -1234.5)      -1234.5 eql)
((max     -8388608          0.0)          0.0 eql)
((max     -8388608       1234.5)       1234.5 eql)
((max     -8388608 *most-negative-float*) -8388608 eql)
((max     -8388608 *most-positive-float*) *most-positive-float* eval-eql)
((max           -1 -10000000000)           -1 eql)
((max           -1     -8388609)           -1 eql)
((max           -1     -8388608)           -1 eql)
((max           -1           -1)           -1 eql)
((max           -1            0)            0 eql)
((max           -1            1)            1 eql)
((max           -1      8388607)      8388607 eql)
((max           -1      8388608)      8388608 eql)
((max           -1  10000000000)  10000000000 eql)
((max           -1      -1234.5)           -1 eql)
((max           -1          0.0)          0.0 eql)
((max           -1       1234.5)       1234.5 eql)
((max           -1 *most-negative-float*) -1 eql)
((max           -1 *most-positive-float*) *most-positive-float* eval-eql)
((max            0 -10000000000)            0 eql)
((max            0     -8388609)            0 eql)
((max            0     -8388608)            0 eql)
((max            0           -1)            0 eql)
((max            0            0)            0 eql)
((max            0            1)            1 eql)
((max            0      8388607)      8388607 eql)
((max            0      8388608)      8388608 eql)
((max            0  10000000000)  10000000000 eql)
((max            0      -1234.5)            0 eql)
((max            0          0.0)            0 =)
((max            0       1234.5)       1234.5 eql)
((max            0 *most-negative-float*) 0 eql)
((max            0 *most-positive-float*) *most-positive-float* eval-eql)
((max            1 -10000000000)            1 eql)
((max            1     -8388609)            1 eql)
((max            1     -8388608)            1 eql)
((max            1           -1)            1 eql)
((max            1            0)            1 eql)
((max            1            1)            1 eql)
((max            1      8388607)      8388607 eql)
((max            1      8388608)      8388608 eql)
((max            1  10000000000)  10000000000 eql)
((max            1      -1234.5)            1 eql)
((max            1          0.0)            1 eql)
((max            1       1234.5)       1234.5 eql)
((max            1 *most-negative-float*) 1 eql)
((max            1 *most-positive-float*) *most-positive-float* eval-eql)
((max      8388607 -10000000000)      8388607 eql)
((max      8388607     -8388609)      8388607 eql)
((max      8388607     -8388608)      8388607 eql)
((max      8388607           -1)      8388607 eql)
((max      8388607            0)      8388607 eql)
((max      8388607            1)      8388607 eql)
((max      8388607      8388607)      8388607 eql)
((max      8388607      8388608)      8388608 eql)
((max      8388607  10000000000)  10000000000 eql)
((max      8388607      -1234.5)      8388607 eql)
((max      8388607          0.0)      8388607 eql)
((max      8388607       1234.5)      8388607 eql)
((max      8388607 *most-negative-float*) 8388607 eql)
((max      8388607 *most-positive-float*) *most-positive-float* eval-eql)
((max      8388608 -10000000000)      8388608 eql)
((max      8388608     -8388609)      8388608 eql)
((max      8388608     -8388608)      8388608 eql)
((max      8388608           -1)      8388608 eql)
((max      8388608            0)      8388608 eql)
((max      8388608            1)      8388608 eql)
((max      8388608      8388607)      8388608 eql)
((max      8388608      8388608)      8388608 eql)
((max      8388608  10000000000)  10000000000 eql)
((max      8388608      -1234.5)      8388608 eql)
((max      8388608          0.0)      8388608 eql)
((max      8388608       1234.5)      8388608 eql)
((max      8388608 *most-negative-float*) 8388608 eql)
((max      8388608 *most-positive-float*) *most-positive-float* eval-eql)
((max  10000000000 -10000000000)  10000000000 eql)
((max  10000000000     -8388609)  10000000000 eql)
((max  10000000000     -8388608)  10000000000 eql)
((max  10000000000           -1)  10000000000 eql)
((max  10000000000            0)  10000000000 eql)
((max  10000000000            1)  10000000000 eql)
((max  10000000000      8388607)  10000000000 eql)
((max  10000000000      8388608)  10000000000 eql)
((max  10000000000  10000000000)  10000000000 eql)
((max  10000000000      -1234.5)  10000000000 eql)
((max  10000000000          0.0)  10000000000 eql)
((max  10000000000       1234.5)  10000000000 eql)
((max  10000000000 *most-negative-float*) 10000000000 eql)
((max  10000000000 *most-positive-float*) *most-positive-float* eval-eql)
((max      -1234.5 -10000000000)      -1234.5 eql)
((max      -1234.5     -8388609)      -1234.5 eql)
((max      -1234.5     -8388608)      -1234.5 eql)
((max      -1234.5           -1)           -1 eql)
((max      -1234.5            0)            0 eql)
((max      -1234.5            1)            1 eql)
((max      -1234.5      8388607)      8388607 eql)
((max      -1234.5      8388608)      8388608 eql)
((max      -1234.5  10000000000)  10000000000 eql)
((max      -1234.5      -1234.5)      -1234.5 eql)
((max      -1234.5          0.0)          0.0 eql)
((max      -1234.5       1234.5)       1234.5 eql)
((max      -1234.5 *most-negative-float*) -1234.5 eql)
((max      -1234.5 *most-positive-float*) *most-positive-float* eval-eql)
((max          0.0 -10000000000)          0.0 eql)
((max          0.0     -8388609)          0.0 eql)
((max          0.0     -8388608)          0.0 eql)
((max          0.0           -1)          0.0 eql)
((max          0.0            0)            0 =)
((max          0.0            1)            1 eql)
((max          0.0      8388607)      8388607 eql)
((max          0.0      8388608)      8388608 eql)
((max          0.0  10000000000)  10000000000 eql)
((max          0.0      -1234.5)          0.0 eql)
((max          0.0          0.0)          0.0 eql)
((max          0.0       1234.5)       1234.5 eql)
((max          0.0 *most-negative-float*) 0.0 eql)
((max          0.0 *most-positive-float*) *most-positive-float* eval-eql)
((max       1234.5 -10000000000)       1234.5 eql)
((max       1234.5     -8388609)       1234.5 eql)
((max       1234.5     -8388608)       1234.5 eql)
((max       1234.5           -1)       1234.5 eql)
((max       1234.5            0)       1234.5 eql)
((max       1234.5            1)       1234.5 eql)
((max       1234.5      8388607)      8388607 eql)
((max       1234.5      8388608)      8388608 eql)
((max       1234.5  10000000000)  10000000000 eql)
((max       1234.5      -1234.5)       1234.5 eql)
((max       1234.5          0.0)       1234.5 eql)
((max       1234.5       1234.5)       1234.5 eql)
((max       1234.5 *most-negative-float*) 1234.5 eql)
((max       1234.5 *most-positive-float*) *most-positive-float* eval-eql)
((max *most-negative-float* -10000000000) -10000000000 eql)
((max *most-negative-float*     -8388609)     -8388609 eql)
((max *most-negative-float*     -8388608)     -8388608 eql)
((max *most-negative-float*           -1)           -1 eql)
((max *most-negative-float*            0)            0 eql)
((max *most-negative-float*            1)            1 eql)
((max *most-negative-float*      8388607)      8388607 eql)
((max *most-negative-float*      8388608)      8388608 eql)
((max *most-negative-float*  10000000000)  10000000000 eql)
((max *most-negative-float*      -1234.5)      -1234.5 eql)
((max *most-negative-float*          0.0)          0.0 eql)
((max *most-negative-float*       1234.5)       1234.5 eql)
((max *most-negative-float* *most-negative-float*) *most-negative-float* eval-eql)
((max *most-negative-float* *most-positive-float*) *most-positive-float* eval-eql)
((max *most-positive-float* -10000000000) *most-positive-float* eval-eql)
((max *most-positive-float*     -8388609) *most-positive-float* eval-eql)
((max *most-positive-float*     -8388608) *most-positive-float* eval-eql)
((max *most-positive-float*           -1) *most-positive-float* eval-eql)
((max *most-positive-float*            0) *most-positive-float* eval-eql)
((max *most-positive-float*            1) *most-positive-float* eval-eql)
((max *most-positive-float*      8388607) *most-positive-float* eval-eql)
((max *most-positive-float*      8388608) *most-positive-float* eval-eql)
((max *most-positive-float*  10000000000) *most-positive-float* eval-eql)
((max *most-positive-float*      -1234.5) *most-positive-float* eval-eql)
((max *most-positive-float*          0.0) *most-positive-float* eval-eql)
((max *most-positive-float*       1234.5) *most-positive-float* eval-eql)
((max *most-positive-float* *most-negative-float*) *most-positive-float* eval-eql)
((max *most-positive-float* *most-positive-float*) *most-positive-float* eval-eql)
;;; 3 
((max 0 0 0) 0 eql)
((max 0.0 0.0 0.0) 0.0 eql)
((max 10 20 30) 30 eql)
((max 10.0 20.0 30.0) 30.0 eql)

;;;
;;; ֐ (MIN x+) --> <number>
;;;
($ap 2 "min" P.70)
((min 3 1) 1 eql)
((min 1 2.0) 1 eql)
;;((min 2 2.0) 2 =)					; 2 or 2.0 (IDEF)
((min 1 5 2 4 3) 1 eql)
;;;
($argc min 1 0 1)
($type min ($integer $float) :target)
($type min ($integer $float) 0 :target)
;;; 1 
((min -10000000000) -10000000000 eql)
((min     -8388609)     -8388609 eql)
((min     -8388608)     -8388608 eql)
((min           -1)           -1 eql)
((min            0)            0 eql)
((min            1)            1 eql)
((min      8388607)      8388607 eql)
((min      8388608)      8388608 eql)
((min  10000000000)  10000000000 eql)
((min      -1234.5)      -1234.5 eql)
((min          0.0)          0.0 eql)
((min       1234.5)       1234.5 eql)
((min *most-negative-float*) *most-negative-float* eval-eql)
((min *most-positive-float*) *most-positive-float* eval-eql)
;;; 2 
((min -10000000000 -10000000000) -10000000000 eql)
((min -10000000000     -8388609) -10000000000 eql)
((min -10000000000     -8388608) -10000000000 eql)
((min -10000000000           -1) -10000000000 eql)
((min -10000000000            0) -10000000000 eql)
((min -10000000000            1) -10000000000 eql)
((min -10000000000      8388607) -10000000000 eql)
((min -10000000000      8388608) -10000000000 eql)
((min -10000000000  10000000000) -10000000000 eql)
((min -10000000000      -1234.5) -10000000000 eql)
((min -10000000000          0.0) -10000000000 eql)
((min -10000000000       1234.5) -10000000000 eql)
((min -10000000000 *most-negative-float*) *most-negative-float* eval-eql)
((min -10000000000 *most-positive-float*) -10000000000 eql)
((min     -8388609 -10000000000) -10000000000 eql)
((min     -8388609     -8388609)     -8388609 eql)
((min     -8388609     -8388608)     -8388609 eql)
((min     -8388609           -1)     -8388609 eql)
((min     -8388609            0)     -8388609 eql)
((min     -8388609            1)     -8388609 eql)
((min     -8388609      8388607)     -8388609 eql)
((min     -8388609      8388608)     -8388609 eql)
((min     -8388609  10000000000)     -8388609 eql)
((min     -8388609      -1234.5)     -8388609 eql)
((min     -8388609          0.0)     -8388609 eql)
((min     -8388609       1234.5)     -8388609 eql)
((min     -8388609 *most-negative-float*) *most-negative-float* eval-eql)
((min     -8388609 *most-positive-float*) -8388609 eql)
((min     -8388608 -10000000000) -10000000000 eql)
((min     -8388608     -8388609)     -8388609 eql)
((min     -8388608     -8388608)     -8388608 eql)
((min     -8388608           -1)     -8388608 eql)
((min     -8388608            0)     -8388608 eql)
((min     -8388608            1)     -8388608 eql)
((min     -8388608      8388607)     -8388608 eql)
((min     -8388608      8388608)     -8388608 eql)
((min     -8388608  10000000000)     -8388608 eql)
((min     -8388608      -1234.5)     -8388608 eql)
((min     -8388608          0.0)     -8388608 eql)
((min     -8388608       1234.5)     -8388608 eql)
((min     -8388608 *most-negative-float*) *most-negative-float* eval-eql)
((min     -8388608 *most-positive-float*) -8388608 eql)
((min           -1 -10000000000) -10000000000 eql)
((min           -1     -8388609)     -8388609 eql)
((min           -1     -8388608)     -8388608 eql)
((min           -1           -1)           -1 eql)
((min           -1            0)           -1 eql)
((min           -1            1)           -1 eql)
((min           -1      8388607)           -1 eql)
((min           -1      8388608)           -1 eql)
((min           -1  10000000000)           -1 eql)
((min           -1      -1234.5)      -1234.5 eql)
((min           -1          0.0)           -1 eql)
((min           -1       1234.5)           -1 eql)
((min           -1 *most-negative-float*) *most-negative-float* eval-eql)
((min           -1 *most-positive-float*) -1 eql)
((min            0 -10000000000) -10000000000 eql)
((min            0     -8388609)     -8388609 eql)
((min            0     -8388608)     -8388608 eql)
((min            0           -1)           -1 eql)
((min            0            0)            0 eql)
((min            0            1)            0 eql)
((min            0      8388607)            0 eql)
((min            0      8388608)            0 eql)
((min            0  10000000000)            0 eql)
((min            0      -1234.5)      -1234.5 eql)
((min            0          0.0)            0 =)
((min            0       1234.5)            0 eql)
((min            0 *most-negative-float*) *most-negative-float* eval-eql)
((min            0 *most-positive-float*) 0 eql)
((min            1 -10000000000) -10000000000 eql)
((min            1     -8388609)     -8388609 eql)
((min            1     -8388608)     -8388608 eql)
((min            1           -1)           -1 eql)
((min            1            0)            0 eql)
((min            1            1)            1 eql)
((min            1      8388607)            1 eql)
((min            1      8388608)            1 eql)
((min            1  10000000000)            1 eql)
((min            1      -1234.5)      -1234.5 eql)
((min            1          0.0)          0.0 eql)
((min            1       1234.5)            1 eql)
((min            1 *most-negative-float*) *most-negative-float* eval-eql)
((min            1 *most-positive-float*) 1 eql)
((min      8388607 -10000000000) -10000000000 eql)
((min      8388607     -8388609)     -8388609 eql)
((min      8388607     -8388608)     -8388608 eql)
((min      8388607           -1)           -1 eql)
((min      8388607            0)            0 eql)
((min      8388607            1)            1 eql)
((min      8388607      8388607)      8388607 eql)
((min      8388607      8388608)      8388607 eql)
((min      8388607  10000000000)      8388607 eql)
((min      8388607      -1234.5)      -1234.5 eql)
((min      8388607          0.0)          0.0 eql)
((min      8388607       1234.5)       1234.5 eql)
((min      8388607 *most-negative-float*) *most-negative-float* eval-eql)
((min      8388607 *most-positive-float*) 8388607 eql)
((min      8388608 -10000000000) -10000000000 eql)
((min      8388608     -8388609)     -8388609 eql)
((min      8388608     -8388608)     -8388608 eql)
((min      8388608           -1)           -1 eql)
((min      8388608            0)            0 eql)
((min      8388608            1)            1 eql)
((min      8388608      8388607)      8388607 eql)
((min      8388608      8388608)      8388608 eql)
((min      8388608  10000000000)      8388608 eql)
((min      8388608      -1234.5)      -1234.5 eql)
((min      8388608          0.0)          0.0 eql)
((min      8388608       1234.5)       1234.5 eql)
((min      8388608 *most-negative-float*) *most-negative-float* eval-eql)
((min      8388608 *most-positive-float*) 8388608 eql)
((min  10000000000 -10000000000) -10000000000 eql)
((min  10000000000     -8388609)     -8388609 eql)
((min  10000000000     -8388608)     -8388608 eql)
((min  10000000000           -1)           -1 eql)
((min  10000000000            0)            0 eql)
((min  10000000000            1)            1 eql)
((min  10000000000      8388607)      8388607 eql)
((min  10000000000      8388608)      8388608 eql)
((min  10000000000  10000000000)  10000000000 eql)
((min  10000000000      -1234.5)      -1234.5 eql)
((min  10000000000          0.0)          0.0 eql)
((min  10000000000       1234.5)       1234.5 eql)
((min  10000000000 *most-negative-float*) *most-negative-float* eval-eql)
((min  10000000000 *most-positive-float*) 10000000000 eql)
((min      -1234.5 -10000000000) -10000000000 eql)
((min      -1234.5     -8388609)     -8388609 eql)
((min      -1234.5     -8388608)     -8388608 eql)
((min      -1234.5           -1)      -1234.5 eql)
((min      -1234.5            0)      -1234.5 eql)
((min      -1234.5            1)      -1234.5 eql)
((min      -1234.5      8388607)      -1234.5 eql)
((min      -1234.5      8388608)      -1234.5 eql)
((min      -1234.5  10000000000)      -1234.5 eql)
((min      -1234.5      -1234.5)      -1234.5 eql)
((min      -1234.5          0.0)      -1234.5 eql)
((min      -1234.5       1234.5)      -1234.5 eql)
((min      -1234.5 *most-negative-float*) *most-negative-float* eval-eql)
((min      -1234.5 *most-positive-float*) -1234.5 eql)
((min          0.0 -10000000000) -10000000000 eql)
((min          0.0     -8388609)     -8388609 eql)
((min          0.0     -8388608)     -8388608 eql)
((min          0.0           -1)           -1 eql)
((min          0.0            0)            0 =)
((min          0.0            1)          0.0 eql)
((min          0.0      8388607)          0.0 eql)
((min          0.0      8388608)          0.0 eql)
((min          0.0  10000000000)          0.0 eql)
((min          0.0      -1234.5)      -1234.5 eql)
((min          0.0          0.0)          0.0 eql)
((min          0.0       1234.5)          0.0 eql)
((min          0.0 *most-negative-float*) *most-negative-float* eval-eql)
((min          0.0 *most-positive-float*) 0.0 eql)
((min       1234.5 -10000000000) -10000000000 eql)
((min       1234.5     -8388609)     -8388609 eql)
((min       1234.5     -8388608)     -8388608 eql)
((min       1234.5           -1)           -1 eql)
((min       1234.5            0)            0 eql)
((min       1234.5            1)            1 eql)
((min       1234.5      8388607)       1234.5 eql)
((min       1234.5      8388608)       1234.5 eql)
((min       1234.5  10000000000)       1234.5 eql)
((min       1234.5      -1234.5)      -1234.5 eql)
((min       1234.5          0.0)          0.0 eql)
((min       1234.5       1234.5)       1234.5 eql)
((min       1234.5 *most-negative-float*) *most-negative-float* eval-eql)
((min       1234.5 *most-positive-float*) 1234.5 eql)
((min *most-negative-float* -10000000000) *most-negative-float* eval-eql)
((min *most-negative-float*     -8388609) *most-negative-float* eval-eql)
((min *most-negative-float*     -8388608) *most-negative-float* eval-eql)
((min *most-negative-float*           -1) *most-negative-float* eval-eql)
((min *most-negative-float*            0) *most-negative-float* eval-eql)
((min *most-negative-float*            1) *most-negative-float* eval-eql)
((min *most-negative-float*      8388607) *most-negative-float* eval-eql)
((min *most-negative-float*      8388608) *most-negative-float* eval-eql)
((min *most-negative-float*  10000000000) *most-negative-float* eval-eql)
((min *most-negative-float*      -1234.5) *most-negative-float* eval-eql)
((min *most-negative-float*          0.0) *most-negative-float* eval-eql)
((min *most-negative-float*       1234.5) *most-negative-float* eval-eql)
((min *most-negative-float* *most-negative-float*) *most-negative-float* eval-eql)
((min *most-negative-float* *most-positive-float*) *most-negative-float* eval-eql)
((min *most-positive-float* -10000000000) -10000000000 eql)
((min *most-positive-float*     -8388609)     -8388609 eql)
((min *most-positive-float*     -8388608)     -8388608 eql)
((min *most-positive-float*           -1)           -1 eql)
((min *most-positive-float*            0)            0 eql)
((min *most-positive-float*            1)            1 eql)
((min *most-positive-float*      8388607)      8388607 eql)
((min *most-positive-float*      8388608)      8388608 eql)
((min *most-positive-float*  10000000000)  10000000000 eql)
((min *most-positive-float*      -1234.5)      -1234.5 eql)
((min *most-positive-float*          0.0)          0.0 eql)
((min *most-positive-float*       1234.5)       1234.5 eql)
((min *most-positive-float* *most-negative-float*) *most-negative-float* eval-eql)
((min *most-positive-float* *most-positive-float*) *most-positive-float* eval-eql)
;;; 3 
((min 0 0 0) 0 eql)
((min 0.0 0.0 0.0) 0.0 eql)
((min 10 20 30) 10 eql)
((min 10.0 20.0 30.0) 10.0 eql)

;;;
;;; ֐ (ABS x) --> <number>
;;;
($ap 2 "abs" P.71)
((abs -3) 3 eql)
((abs 2.0) 2.0 eql)
((abs -0.0) 0.0 eql)
;;;
($argc abs 1 0 0)
($type abs ($integer $float) :target)
;;;
((abs -10000000000) 10000000000 eql)
((abs     -8388609)     8388609 eql)
((abs     -8388608)     8388608 eql)
((abs     -8388607)     8388607 eql)
((abs           -1)           1 eql)
((abs            0)           0 eql)
((abs            1)           1 eql)
((abs      8388607)     8388607 eql)
((abs      8388608)     8388608 eql)
((abs  10000000000) 10000000000 eql)
((abs      -1234.5)      1234.5 eql)
((abs          0.0)         0.0 eql)
((abs       1234.5)      1234.5 eql)
((abs *most-negative-float*) *most-positive-float* eval-eql)
((abs *most-positive-float*) *most-positive-float* eval-eql)

;;;
;;; ֐ (EXP x) --> <number>
;;;
($ap 2 "exp" P.71)
((exp 1) 2.718281828459045 ~eql)
((exp 2) 7.38905609893065 eql)
((exp 1.23) 3.4212295362896734 ~eql)
;;((exp 0) 1 =)						; 1 or 1.0 (IDEF)
;;;
($argc exp 1 0 0)
($type exp ($integer $float) :target)
;;;
((exp 1.0) 2.718281828459045 ~eql)
((exp 2.0) 7.38905609893065 eql)
((exp 0.0) 1.0 eql)
($error (exp -10000000000) <floating-point-underflow>)
($error (exp  10000000000) <floating-point-overflow>)
($error (exp *most-negative-float*) <floating-point-underflow>)
($error (exp *most-positive-float*) <floating-point-overflow>)

;;;
;;; ֐ (LOG x) --> <number>
;;;
($ap 2 "log" P.71)
((log 2.718281828459045) 1.0 ~eql)
((log 10) 2.302585092994046 eql)
;;((log 1) 0 =)						; 0 or 0.0 (IDEF)
;;;
($argc log 1 0 0)
($type log ($integer $float) :target)
;;;
((log 10.0) 2.302585092994046 eql)
((log 1.0) 0.0 eql)
((log  10000000000) 23.02585092994046 ~eql)
((log *most-positive-float*) 709.782712893384 eql)
($error (log -10000000000) <error>)
($error (log           -1) <error>)
($error (log            0) <error>)
($error (log      -1234.5) <error>)
($error (log          0.0) <error>)
($error (log *most-negative-float*) <error>)

;;;
;;; ֐ (EXPT x1 x2) --> <number>
;;;
($ap 2 "expt" P.72)
((expt 2 3) 8 eql)
((expt -100 2) 10000 eql)
((expt 4 -2) 0.0625 eql)
((expt 0.5 2) 0.25 eql)
((expt 100 0) 1 eql)
((expt 1234567890 0) 1 eql)
((expt 100.0 0) 1.0 eql)
((expt -0.25 -1) -4.0 eql)
((expt 100 0.5) 10.0 eql)
((expt 100 -1.5) 0.001 eql)
((expt 100.0 0.0) 1.0 eql)
($error (expt 0.0 0.0) <error>)
;;;
($argc expt 2 0 0)
($type expt ($integer $float) :target 1)
($type expt ($integer $float) 1 :target)
;;; x1 ŁAx2 łȂ̏ꍇAʂ͐ł
;;; +Integer  +Integer
;;; +Integer         0
;;;        0  +Integer
;;;        0         0
;;; -Integer  +Integer
;;; -Integer         0
;((integerp (expt  10000000000 10000000000)) t)
((expt  10000000000           2)  100000000000000000000 eql)
((expt  10000000000           1)            10000000000 eql)
;((integerp (expt            2 10000000000)) t)
((expt            2           2)                      4 eql)
((expt            2           1)                      2 eql)
((expt            1 10000000000)                      1 eql)
((expt            1           2)                      1 eql)
((expt            1           1)                      1 eql)
((expt  10000000000           0)                      1 eql)
((expt            2           0)                      1 eql)
((expt            1           0)                      1 eql)
((expt            0 10000000000)                      0 eql)
((expt            0           2)                      0 eql)
((expt            0           1)                      0 eql)
((expt            0           0)                      1 eql)
((expt           -1 10000000000)                      1 eql)
((expt           -1           2)                      1 eql)
((expt           -1           1)                     -1 eql)
;((integerp (expt           -2 10000000000)) t)
((expt           -2           2)                      4 eql)
((expt           -2           1)                     -2 eql)
;;((integerp (expt -10000000000 10000000000)) t)
((expt -10000000000           2)  100000000000000000000 eql)
((expt -10000000000           1)           -10000000000 eql)
((expt           -1           0)                      1 eql)
((expt           -2           0)                      1 eql)
((expt -10000000000           0)                      1 eql)
;;; x1 [ŁAx2 ̏ꍇG[
;;;        0  -Integer
;;;        0    -Float
;;;      0.0  -Integer
;;;      0.0    -Float
($error (expt 0   -10000000000) <error>)
($error (expt 0             -1) <error>)
($error (expt 0        -1234.5) <error>)
($error (expt 0 *most-negative-float*) <error>)
($error (expt 0.0 -10000000000) <error>)
($error (expt 0.0           -1) <error>)
($error (expt 0.0      -1234.5) <error>)
($error (expt 0.0 *most-negative-float*) <error>)
;;; x1 [ŁAx2  0.0 ̏ꍇG[
;;;        0       0.0
;;;      0.0       0.0
($error (expt 0 0.0) <error>)
;;; x1 ŁAx2 łȂꍇG[
;;; -Integer    +Float
;;; -Integer       0.0
;;; -Integer    -Float
;;;   -Float    +Float
;;;   -Float       0.0
;;;   -Float    -Float
($error (expt -10000000000  1234.5) <error>)
($error (expt -10000000000 *most-positive-float*) <error>)
($error (expt           -1  1234.5) <error>)
($error (expt           -1 *most-positive-float*) <error>)
($error (expt -10000000000     0.0) <error>)
($error (expt           -1     0.0) <error>)
($error (expt -10000000000 -1234.5) <error>)
($error (expt -10000000000 *most-negative-float*) <error>)
($error (expt           -1 -1234.5) <error>)
($error (expt           -1 *most-negative-float*) <error>)
($error (expt      -1234.5  1234.5) <error>)
($error (expt      -1234.5 *most-positive-float*) <error>)
($error (expt *most-negative-float*  1234.5) <error>)
($error (expt *most-negative-float* *most-positive-float*) <error>)
($error (expt      -1234.5     0.0) <error>)
($error (expt *most-negative-float*     0.0) <error>)
($error (expt      -1234.5 -1234.5) <error>)
($error (expt      -1234.5 *most-negative-float*) <error>)
($error (expt *most-negative-float* -1234.5) <error>)
($error (expt *most-negative-float* *most-negative-float*) <error>)
;;; ̑̏ꍇ
;;; +Integer  -Integer
;;; +Integer    +Float
;;; +Integer       0.0
;;; +Integer    -Float
;;;        0    +Float
;;; -Integer  -Integer
;;;   +Float  +Integer
;;;   +Float         0
;;;   +Float  -Integer
;;;   +Float    +Float
;;;   +Float       0.0
;;;   +Float    -Float
;;;      0.0  +Integer
;;;      0.0         0
;;;      0.0    +Float
;;;   -Float  +Integer
;;;   -Float         0
;;;   -Float  -Integer
($error (expt  10000000000 -10000000000) <floating-point-underflow>)
((expt  10000000000           -2) 1.0e-20 ~eql)
((expt  10000000000           -1) 1.0e-10 eql)
($error (expt            2 -10000000000) <floating-point-underflow>)
((expt            2           -2) 0.25 eql)
((expt            2           -1) 0.5 eql)
((expt            1 -10000000000) 1.0 eql)
((expt            1           -2) 1.0 eql)
((expt            1           -1) 1.0 eql)
((expt  10000000000          2.0) 1.0e+20 eql)
((expt  10000000000          1.0) 1.0e+10 eql)
($error (expt  10000000000 *most-positive-float*) <floating-point-overflow>)
((expt            2          2.0) 4.0 eql)
((expt            2          1.0) 2.0 eql)
($error (expt            2 *most-positive-float*) <floating-point-overflow>)
((expt            1          2.0) 1.0 eql)
((expt            1          1.0) 1.0 eql)
((expt            1 *most-positive-float*) 1.0 eql)
((expt  10000000000          0.0) 1.0 eql)
((expt            2          0.0) 1.0 eql)
((expt            1          0.0) 1.0 eql)
((expt  10000000000         -2.0) 1.0e-20 ~eql)
((expt  10000000000         -1.0) 1.0e-10 eql)
($error (expt  10000000000 *most-negative-float*) <floating-point-underflow>)
((expt            2         -2.0) 0.25 eql)
((expt            2         -1.0) 0.5 eql)
($error (expt            2 *most-negative-float*) <floating-point-underflow>)
((expt            1         -2.0) 1.0 eql)
((expt            1         -1.0) 1.0 eql)
((expt            1 *most-negative-float*) 1.0 eql)
((expt            0          2.0) 0.0 eql)
((expt            0          1.0) 0.0 eql)
((expt            0 *most-positive-float*) 0.0 eql)
($error (expt -10000000000 -10000000000) <floating-point-underflow>)
((expt -10000000000           -2)  1.0e-20 ~eql)
((expt -10000000000           -1) -1.0e-10 eql)
($error (expt           -2 -10000000000) <floating-point-underflow>)
((expt           -2           -2)  0.25 eql)
((expt           -2           -1) -0.5 eql)
((expt           -1 -10000000000)  1.0 eql)
((expt           -1           -2)  1.0 eql)
((expt           -1           -1) -1.0 eql)
($error (expt          2.0  10000000000) <floating-point-overflow>)
((expt          2.0            2)  4.0 eql)
((expt          2.0            1)  2.0 eql)
((expt          2.0            0)  1.0 eql)
((expt          2.0           -1)  0.5 eql)
((expt          2.0           -2)  0.25 eql)
($error (expt          2.0 -10000000000) <floating-point-underflow>)
((expt          2.0           2.0) 4.0 eql)
((expt          2.0           1.0) 2.0 eql)
($error (expt          2.0 *most-positive-float*) <floating-point-overflow>)
((expt          2.0           0.0) 1.0 eql)
((expt          2.0          -1.0) 0.5 eql)
((expt          2.0          -2.0) 0.25 eql)
($error (expt          2.0 *most-negative-float*) <floating-point-underflow>)
((expt          1.0  10000000000)  1.0 eql)
((expt          1.0            2)  1.0 eql)
((expt          1.0            1)  1.0 eql)
((expt          1.0            0)  1.0 eql)
((expt          1.0           -1)  1.0 eql)
((expt          1.0           -2)  1.0 eql)
((expt          1.0 -10000000000)  1.0 eql)
((expt          1.0           2.0) 1.0 eql)
((expt          1.0           1.0) 1.0 eql)
((expt          1.0 *most-positive-float*) 1.0 eql)
((expt          1.0           0.0) 1.0 eql)
((expt          1.0          -1.0) 1.0 eql)
((expt          1.0          -2.0) 1.0 eql)
((expt          1.0 *most-negative-float*) 1.0 eql)
($error (expt *most-positive-float*  10000000000) <floating-point-overflow>)
($error (expt *most-positive-float*            2) <floating-point-overflow>)
((expt *most-positive-float*            1) *most-positive-float* eval-eql)
((expt *most-positive-float*            0)  1.0 eql)
($error (expt *most-positive-float*           -1) <floating-point-underflow>)
($error (expt *most-positive-float*           -2) <floating-point-underflow>)
($error (expt *most-positive-float* -10000000000) <floating-point-underflow>)
($error (expt *most-positive-float*           2.0) <floating-point-overflow>)
((expt *most-positive-float*           1.0) *most-positive-float* eval-eql)
($error (expt *most-positive-float* *most-positive-float*) <floating-point-overflow>)
((expt *most-positive-float*           0.0) 1.0 eql)
($error (expt *most-positive-float*          -1.0) <floating-point-underflow>)
($error (expt *most-positive-float*          -2.0) <floating-point-underflow>)
($error (expt *most-positive-float* *most-negative-float*) <floating-point-underflow>)
((expt 0.0 10000000000) 0.0 eql)
((expt 0.0           2) 0.0 eql)
((expt 0.0           1) 0.0 eql)
((expt 0.0           0) 1.0 eql)
((expt 0.0         2.0) 0.0 eql)
((expt 0.0         1.0) 0.0 eql)
((expt 0.0 *most-positive-float*) 0.0 eql)
($error (expt -2.0  10000000000) <floating-point-overflow>)
((expt -2.0            2)  4.0 eql)
((expt -2.0            1) -2.0 eql)
((expt -1.0  10000000000)  1.0 eql)
((expt -1.0            2)  1.0 eql)
((expt -1.0            1) -1.0 eql)
($error (expt *most-negative-float* 10000000000) <floating-point-overflow>)
($error (expt *most-negative-float*           2) <floating-point-overflow>)
((expt *most-negative-float*          1) *most-negative-float* eval-eql)
((expt -2.0            0) 1.0 eql)
((expt -1.0            0) 1.0 eql)
((expt *most-negative-float* 0) 1.0 eql)
($error (expt -2.0 -10000000000) <floating-point-underflow>)
((expt -2.0           -2)  0.25 eql)
((expt -2.0           -1) -0.5 eql)
((expt -1.0 -10000000000)  1.0 eql)
((expt -1.0           -2)  1.0 eql)
((expt -1.0           -1) -1.0 eql)
($error (expt *most-negative-float* -10000000000) <floating-point-underflow>)
($error (expt *most-negative-float*           -2) <floating-point-underflow>)
($error (expt *most-negative-float*           -1) <floating-point-underflow>)

;;;
;;; ֐ (SQRT x) --> <number>
;;;
($ap 2 "sqrt" P.72)
((sqrt 4) 2 eql)
((sqrt 2) 1.4142135623730951 eql)
($error (sqrt -1) <domain-error>)
;;;
($argc sqrt 1 0 0)
($type sqrt ($integer $float) :target)
;;;
((sqrt 100000000000000000000)   10000000000 eql)
((sqrt           10000000000)        100000 eql)
((sqrt                     1)             1 eql)
((sqrt                     0)             0 eql)
((sqrt 100000000000000000000.0) 10000000000.0 eql)
((sqrt           10000000000.0)      100000.0 eql)
((sqrt                     1.0)           1.0 eql)
((sqrt                     0.0)           0.0 eql)
((sqrt *most-positive-float*) 1.34078079299426e154 ~eql)
($error (sqrt -10000000000) <domain-error>)
($error (sqrt     -8388609) <domain-error>)
($error (sqrt     -8388608) <domain-error>)
($error (sqrt      -1234.5) <domain-error>)
($error (sqrt *most-negative-float*) <domain-error>)
($eval (defconstant *pi*/2 (quotient *pi* 2)))
($eval (defconstant -*pi*/2 (- *pi*/2)))

;;;
;;; ֐ (SIN x) --> <number>
;;;
($ap 2 "sin" P.73)
((sin 1) 0.8414709848078965 ~eql)
;;((sin 0) 0 =)						; 0 or 0.0 (IDEF)
((sin 0.001) 9.999998333333417E-4 ~eql)
;;;
($argc sin 1 0 0)
($type sin ($integer $float) :target)
;;;
((sin -10000000000)  0.4875060250763 ~eql)
((sin          -10)  0.54402111088936977 ~eql)
((sin           -1) -0.8414709848078965 ~eql)
((sin           10) -0.54402111088936977 ~eql)
((sin  10000000000) -0.4875060250763 ~eql)
((sin -10000000000.0)    0.4875060250763 ~eql)
((sin          -10.0)    0.54402111088936977 ~eql)
((sin           -1.0)   -0.8414709848078965 ~eql)
((sin           -0.001) -9.999998333333417E-4 ~eql)
((sin            0.0)    0.0 eql)
((sin            1.0)    0.8414709848078965 ~eql)
((sin           10.0)   -0.54402111088936977 ~eql)
((sin  10000000000.0)   -0.4875060250763 ~eql)
((sin (- (quotient *pi* 2))) -1.0 eql)
((sin (quotient *pi* 2)) 1.0 eql)
;((sin *most-negative-float*) ? ~eql)
;((sin *most-positive-float*) ? ~eql)

;;;
;;; ֐ (COS x) --> <number>
;;;
($ap 2 "cos" P.73)
((cos 1) 0.5403023058681398 ~eql)
;;((cos 0) 1 =)						; 1 or 1.0 (IDEF)
((cos 0.001) 0.9999995000000417 ~eql)
;;;
($argc cos 1 0 0)
($type cos ($integer $float) :target)
;;;
((cos -10000000000)  0.8731196226831 ~eql)
((cos          -10) -0.8390715290764524 ~eql)
((cos           -1)  0.5403023058681398 ~eql)
((cos           10) -0.8390715290764524 ~eql)
((cos  10000000000)  0.8731196226831 ~eql)
((cos -10000000000.0)    0.8731196226831 ~eql)
((cos          -10.0)   -0.8390715290764524 ~eql)
((cos           -1.0)    0.5403023058681398 ~eql)
((cos           -0.001)  0.9999995000000417 ~eql)
((cos            0.0)    1.0 eql)
((cos            0.001)  0.9999995000000417 ~eql)
((cos            1.0)    0.5403023058681398 ~eql)
((cos           10.0)   -0.8390715290764524 ~eql)
((cos  10000000000.0)    0.8731196226831 ~eql)
((cos (- *pi*)) -1.0 eql)
((cos *pi*) -1.0 eql)
;((cos *most-negative-float*) ? eql)
;((cos *most-positive-float*) ? eql)

;;;
;;; ֐ (TAN x) --> <number>
;;;
($ap 2 "tan" P.73)
((tan 1) 1.557407724654902 ~eql)
;;((tan 0) 0 =)						; 0 or 0.0 (IDEF)
((tan 0.001) 0.0010000003333334668 ~eql)
;;;
($argc tan 1 0 0)
($type tan ($integer $float) :target)
;;;
((tan -10000000000)  0.5583496377944 ~eql)
((tan          -10) -0.6483608274590866 ~eql)
((tan           -1) -1.557407724654902 ~eql)
((tan           10)  0.6483608274590866 ~eql)
((tan  10000000000) -0.5583496377944 ~eql)
((tan -10000000000.0)    0.5583496377944 ~eql)
((tan          -10.0)   -0.6483608274590866 ~eql)
((tan           -1.0)   -1.557407724654902 ~eql)
((tan           -0.001) -0.0010000003333334668 ~eql)
((tan            0.0)    0.0 eql)
((tan            1.0)    1.557407724654902 ~eql)
((tan           10.0)    0.6483608274590866 ~eql)
((tan  10000000000.0)   -0.5583496377944 ~eql)
((tan (- (quotient *pi* 4))) -1.0 ~eql)
((tan (quotient *pi* 4)) 1.0 ~eql)
;((tan *most-negative-float*) ? eql)
;((tan *most-positive-float*) ? eql)

;;;
;;; ֐ (ATAN x) --> <number>
;;;
($ap 2 "atan" P.73)
;;;
($argc atan 1 0 0)
($type atan ($integer $float) :target)
;;;
((atan -10000000000) -1.570796326694897 ~eql)
((atan          -10) -1.471127674303735 ~eql)
((atan           -1) -0.7853981633974483 ~eql)
((atan            0)  0 =)
((atan            1)  0.7853981633974483 ~eql)
((atan           10)  1.471127674303735 ~eql)
((atan  10000000000)  1.570796326694897 ~eql)
((atan -10000000000.0)   -1.570796326694897 ~eql)
((atan          -10.0)   -1.471127674303735 ~eql)
((atan           -1.0)   -0.7853981633974483 ~eql)
((atan           -0.001) -0.001 ~eql)
((atan            0.0)    0.0 eql)
((atan            0.001)  0.001 ~eql)
((atan            1.0)    0.7853981633974483 ~eql)
((atan           10.0)    1.471127674303735 ~eql)
((atan  10000000000.0)    1.570796326694897 ~eql)
((atan *most-negative-float*) -1.570796326794897 ~eql)
((atan *most-positive-float*)  1.570796326794897 ~eql)

;;;
;;; ֐ (ATAN2 x1 x2) --> <number>
;;;
($ap 2 "atan2" P.74)
;;((atan2 0 3.0) 0 =)					; 0 or 0.0 (IDEF)
((atan2 1 1) 0.7853981633974483 ~eql)
((atan2 1.0 -0.3) 1.8622531212727635 ~eql)
((atan2 0.0 -0.5) 3.141592653589793 ~eql)
((atan2 -1 -1) -2.356194490192345 ~eql)
((atan2 -1.0 0.3) -1.2793396 ~eql)
((atan2 0.0 0.5) 0.0 eql)
;;;
($argc atan2 2 0 0)
($type atan2 ($integer $float) :target 1)
($type atan2 ($integer $float) 1 :target)
;;; y = 0, x > 0 --> 0
((atan2 0 10000000000) 0 =)
((atan2 0          10) 0 =)
((atan2 0 10000000000.0) 0 =)
((atan2 0          10.0) 0 =)
((atan2 0 *most-positive-float*) 0 =)
((atan2 0.0 10000000000) 0 =)
((atan2 0.0          10) 0 =)
((atan2 0.0 10000000000.0) 0 =)
((atan2 0.0          10.0) 0 =)
((atan2 0.0 *most-positive-float*) 0 =)
;;; y > 0, x > 0 --> 0 < result < *pi*/2
((atan2 10000000000 10000000000) 0.7853981633974483 ~eql)
((atan2 10000000000          10) 1.570796325794897 ~eql)
((atan2 10000000000 10000000000.0) 0.7853981633974483 ~eql)
((atan2 10000000000          10.0) 1.570796325794897 ~eql)
((atan2 10000000000 *most-positive-float*) 5.562684646268005e-299 ~eql)
((atan2          10 10000000000) 1.0e-9 ~eql)
((atan2          10          10) 0.7853981633974483 ~eql)
((atan2          10 10000000000.0) 1.0e-9 ~eql)
((atan2          10          10.0) 0.7853981633974483 ~eql)
((atan2          10 *most-positive-float*) 5.562684646268004e-308 ~eql)
((atan2 10000000000.0 10000000000) 0.7853981633974483 ~eql)
((atan2 10000000000.0          10) 1.570796325794897 ~eql)
((atan2 10000000000.0 10000000000.0) 0.7853981633974483 ~eql)
((atan2 10000000000.0          10.0) 1.570796325794897 ~eql)
((atan2 10000000000.0 *most-positive-float*) 5.562684646268005e-299 ~eql)
((atan2          10.0 10000000000) 1.0e-9 ~eql)
((atan2          10.0          10) 0.7853981633974483 ~eql)
((atan2          10.0 10000000000.0) 1.0e-9 ~eql)
((atan2          10.0          10.0) 0.7853981633974483 ~eql)
((atan2          10.0 *most-positive-float*) 5.562684646268004e-308 ~eql)
((atan2 *most-positive-float* 10000000000) 1.570796326794897 ~eql)
((atan2 *most-positive-float*          10) 1.570796326794897 ~eql)
((atan2 *most-positive-float* 10000000000.0) 1.570796326794897 ~eql)
((atan2 *most-positive-float*          10.0) 1.570796326794897 ~eql)
((atan2 *most-positive-float* *most-positive-float*) 0.7853981633974483 ~eql)
;;; y > 0, x = 0 --> *pi*/2
((atan2 10000000000 0) *pi*/2 eval-eql)
((atan2          10 0) *pi*/2 eval-eql)
((atan2 10000000000.0 0) *pi*/2 eval-eql)
((atan2          10.0 0) *pi*/2 eval-eql)
((atan2 *most-positive-float* 0) *pi*/2 eval-eql)
((atan2 10000000000 0.0) *pi*/2 eval-eql)
((atan2          10 0.0) *pi*/2 eval-eql)
((atan2 10000000000.0 0.0) *pi*/2 eval-eql)
((atan2          10.0 0.0) *pi*/2 eval-eql)
((atan2 *most-positive-float* 0.0) *pi*/2 eval-eql)
;;; y > 0, x < 0 --> *pi*/2 < result < *pi*
((atan2 10000000000 -10000000000) 2.356194490192345 ~eql)
((atan2 10000000000          -10) 1.570796327794897 ~eql)
((atan2 10000000000 -10000000000.0) 2.356194490192345 ~eql)
((atan2 10000000000          -10.0) 1.570796327794897 ~eql)
((atan2 10000000000 *most-negative-float*) 3.141592653589793 ~eql)
((atan2          10 -10000000000) 3.141592652589793 ~eql)
((atan2          10          -10) 2.356194490192345 ~eql)
((atan2          10 -10000000000.0) 3.141592652589793 ~eql)
((atan2          10          -10.0) 2.356194490192345 ~eql)
((atan2          10 *most-negative-float*) 3.141592653589793 ~eql)
((atan2 10000000000.0 -10000000000) 2.356194490192345 ~eql)
((atan2 10000000000.0          -10) 1.570796327794897 ~eql)
((atan2 10000000000.0 -10000000000.0) 2.356194490192345 ~eql)
((atan2 10000000000.0          -10.0) 1.570796327794897 ~eql)
((atan2 10000000000.0 *most-negative-float*) 3.141592653589793 ~eql)
((atan2          10.0 -10000000000) 3.141592652589793 ~eql)
((atan2          10.0          -10) 2.356194490192345 ~eql)
((atan2          10.0 -10000000000.0) 3.141592652589793 ~eql)
((atan2          10.0          -10.0) 2.356194490192345 ~eql)
((atan2          10.0 *most-negative-float*) 3.141592653589793 ~eql)
((atan2 *most-positive-float* -10000000000) 1.570796326794897 ~eql)
((atan2 *most-positive-float*          -10) 1.570796326794897 ~eql)
((atan2 *most-positive-float* -10000000000.0) 1.570796326794897 ~eql)
((atan2 *most-positive-float*          -10.0) 1.570796326794897 ~eql)
((atan2 *most-positive-float* *most-negative-float*) 2.356194490192345 ~eql)
;;; y = 0, x < 0 --> *pi*
((atan2 0 -10000000000) *pi* eval-eql)
((atan2 0          -10) *pi* eval-eql)
((atan2 0 -10000000000.0) *pi* eval-eql)
((atan2 0          -10.0) *pi* eval-eql)
((atan2 0 *most-negative-float*) *pi* eval-eql)
((atan2 0.0 -10000000000) *pi* eval-eql)
((atan2 0.0          -10) *pi* eval-eql)
((atan2 0.0 -10000000000.0) *pi* eval-eql)
((atan2 0.0          -10.0) *pi* eval-eql)
((atan2 0.0 *most-negative-float*) *pi* eval-eql)
;;; y < 0, x < 0 --> -*pi* < result < -*pi*/2
((atan2 -10000000000 -10000000000) -2.356194490192345 ~eql)
((atan2 -10000000000          -10) -1.570796327794897 ~eql)
((atan2 -10000000000 -10000000000.0) -2.356194490192345 ~eql)
((atan2 -10000000000          -10.0) -1.570796327794897 ~eql)
((atan2 -10000000000 *most-negative-float*) -3.141592653589793 ~eql)
((atan2          -10 -10000000000) -3.141592652589793 ~eql)
((atan2          -10          -10) -2.356194490192345 ~eql)
((atan2          -10 -10000000000.0) -3.141592652589793 ~eql)
((atan2          -10          -10.0) -2.356194490192345 ~eql)
((atan2          -10 *most-negative-float*) -3.141592653589793 ~eql)
((atan2 -10000000000.0 -10000000000) -2.356194490192345 ~eql)
((atan2 -10000000000.0          -10) -1.570796327794897 ~eql)
((atan2 -10000000000.0 -10000000000.0) -2.356194490192345 ~eql)
((atan2 -10000000000.0          -10.0) -1.570796327794897 ~eql)
((atan2 -10000000000.0 *most-negative-float*) -3.141592653589793 ~eql)
((atan2          -10.0 -10000000000) -3.141592652589793 ~eql)
((atan2          -10.0          -10) -2.356194490192345 ~eql)
((atan2          -10.0 -10000000000.0) -3.141592652589793 ~eql)
((atan2          -10.0          -10.0) -2.356194490192345 ~eql)
((atan2          -10.0 *most-negative-float*) -3.141592653589793 ~eql)
((atan2 *most-negative-float* -10000000000) -1.570796326794897 ~eql)
((atan2 *most-negative-float*          -10) -1.570796326794897 ~eql)
((atan2 *most-negative-float* -10000000000.0) -1.570796326794897 ~eql)
((atan2 *most-negative-float*          -10.0) -1.570796326794897 ~eql)
((atan2 *most-negative-float* *most-negative-float*) -2.356194490192345 ~eql)
;;; y < 0, x = 0 --> -*pi*/2
((atan2 -10000000000 0) -*pi*/2 eval-eql)
((atan2          -10 0) -*pi*/2 eval-eql)
((atan2 -10000000000.0 0) -*pi*/2 eval-eql)
((atan2          -10.0 0) -*pi*/2 eval-eql)
((atan2 *most-negative-float* 0) -*pi*/2 eval-eql)
((atan2 -10000000000 0.0) -*pi*/2 eval-eql)
((atan2          -10 0.0) -*pi*/2 eval-eql)
((atan2 -10000000000.0 0.0) -*pi*/2 eval-eql)
((atan2          -10.0 0.0) -*pi*/2 eval-eql)
((atan2 *most-negative-float* 0.0) -*pi*/2 eval-eql)
;;; y < 0, x > 0 --> -*pi*/2 < result < 0
((atan2 -10000000000 10000000000) -0.7853981633974483 ~eql)
((atan2 -10000000000          10) -1.570796325794897 ~eql)
((atan2 -10000000000 10000000000.0) -0.7853981633974483 ~eql)
((atan2 -10000000000          10.0) -1.570796325794897 ~eql)
((atan2 -10000000000 *most-positive-float*) -5.562684646268005e-299 ~eql)
((atan2          -10 10000000000) -1.0e-9 ~eql)
((atan2          -10          10) -0.7853981633974483 ~eql)
((atan2          -10 10000000000.0) -1.0e-9 ~eql)
((atan2          -10          10.0) -0.7853981633974483 ~eql)
((atan2          -10 *most-positive-float*) -5.562684646268004e-308 ~eql)
((atan2 -10000000000.0 10000000000) -0.7853981633974483 ~eql)
((atan2 -10000000000.0          10) -1.570796325794897 ~eql)
((atan2 -10000000000.0 10000000000.0) -0.7853981633974483 ~eql)
((atan2 -10000000000.0          10.0) -1.570796325794897 ~eql)
((atan2 -10000000000.0 *most-positive-float*) -5.562684646268005e-299 ~eql)
((atan2          -10.0 10000000000) -1.0e-9 ~eql)
((atan2          -10.0          10) -0.7853981633974483 ~eql)
((atan2          -10.0 10000000000.0) -1.0e-9 ~eql)
((atan2          -10.0          10.0) -0.7853981633974483 ~eql)
((atan2          -10.0 *most-positive-float*) -5.562684646268004e-308 ~eql)
((atan2 *most-negative-float* 10000000000) -1.570796326794897 ~eql)
((atan2 *most-negative-float*          10) -1.570796326794897 ~eql)
((atan2 *most-negative-float* 10000000000.0) -1.570796326794897 ~eql)
((atan2 *most-negative-float*          10.0) -1.570796326794897 ~eql)
((atan2 *most-negative-float* *most-positive-float*) -0.7853981633974483 ~eql)
;;; y = 0, x = 0 --> undefined consequences

;;;
;;; ֐ (SINH x) --> <number>
;;;
($ap 2 "sinh" P.75)
((sinh 1) 1.1752011936438014 ~eql)
;;((sinh 0) 0 =)					; 0 or 0.0 (IDEF)
((sinh 0.001) 0.001000000166666675 ~eql)
;;;
($argc sinh 1 0 0)
($type sinh ($integer $float) :target)
;;;
($error (sinh -10000000000) <floating-point-underflow>)
((sinh -10) -11013.23287470339 ~eql)
((sinh  -1)     -1.1752011936438014 ~eql)
((sinh  10)  11013.23287470339 ~eql)
($error (sinh  10000000000) <floating-point-overflow>)
($error (sinh -10000000000.0) <floating-point-underflow>)
((sinh -10.0) -11013.23287470339 ~eql)
((sinh  -1.0)     -1.1752011936438014 ~eql)
((sinh   0.0)      0.0 eql)
((sinh   1.0)      1.1752011936438014 ~eql)
((sinh  10.0)  11013.23287470339 ~eql)
($error (sinh  10000000000.0) <floating-point-overflow>)
($error (sinh *most-negative-float*) <floating-point-underflow>)
($error (sinh *most-positive-float*) <floating-point-overflow>)

;;;
;;; ֐ (COSH x) --> <number>
;;;
($ap 2 "cosh" P.75)
((cosh 1) 1.5430806348152437 ~eql)
;;((cosh 0) 1 =)					; 1 or 1.0 (IDEF)
((cosh 0.001) 1.0000005000000416 ~eql)
;;;
($argc cosh 1 0 0)
($type cosh ($integer $float) :target)
;;;
($error (cosh -10000000000) <floating-point-underflow>)
((cosh -10) 11013.23292010332 ~eql)
((cosh  -1)     1.5430806348152437 ~eql)
((cosh  10) 11013.23292010332 ~eql)
($error (cosh  10000000000) <floating-point-overflow>)
($error (cosh -10000000000.0) <floating-point-underflow>)
((cosh -10.0) 11013.23292010332 ~eql)
((cosh  -1.0)     1.5430806348152437 ~eql)
((cosh  -0.001)   1.0000005000000416 ~eql)
((cosh   0.0)     1.0 eql)
((cosh   1.0)     1.5430806348152437 ~eql)
((cosh  10.0) 11013.23292010332 ~eql)
($error (cosh  10000000000.0) <floating-point-overflow>)
($error (cosh *most-negative-float*) <floating-point-underflow>)
($error (cosh *most-positive-float*) <floating-point-overflow>)

;;;
;;; ֐ (TANH x) --> <number>
;;;
($ap 2 "tanh" P.75)
((tanh 1) 0.7615941559557649 ~eql)
;;((tanh 0) 0 =)					; 0 or 0.0 (IDEF)
((tanh 0.001) 9.999996666668002E-4 ~eql)
;;;
($argc tanh 1 0 0)
($type tanh ($integer $float) :target)
;;;
($error (tanh -10000000000) <floating-point-underflow>)
((tanh          -10) -0.9999999958776926 ~eql)
((tanh           -1) -0.7615941559557649 ~eql)
((tanh           10)  0.9999999958776926 ~eql)
($error (tanh  10000000000) <floating-point-overflow>)
($error (tanh -10000000000.0) <floating-point-underflow>)
((tanh          -10.0) -0.9999999958776926 ~eql)
((tanh           -1.0) -0.7615941559557649 ~eql)
((tanh            0.0)  0.0 eql)
((tanh            1.0)  0.7615941559557649 ~eql)
((tanh           10.0)  0.9999999958776926 ~eql)
($error (tanh  10000000000.0) <floating-point-overflow>)
($error (tanh *most-negative-float*) <floating-point-underflow>)
($error (tanh *most-positive-float*) <floating-point-overflow>)

;;;
;;; ֐ (ATANH x) --> <number>
;;;
($ap 2 "atanh" P.75)
((atanh 0.5) 0.5493061443340549 ~eql)
;;((atanh 0) 0 =)					; 0 or 0.0 (IDEF)
((atanh 0.001) 0.0010000003333335335 ~eql)
;;;
($argc atanh 1 0 0)
($type atanh ($integer $float) :target)
;;;
($error (atanh -10000000000) <error>)
($error (atanh           -1) <error>)
($error (atanh            1) <error>)
($error (atanh  10000000000) <error>)
($error (atanh -10000000000.0) <error>)
($error (atanh           -1.0) <error>)
((atanh -0.9)   -1.472219489583221 ~eql)
((atanh -0.5)   -0.5493061443340549 ~eql)
((atanh -0.001) -0.0010000003333335335 ~eql)
((atanh  0.0)    0.0 eql)
((atanh  0.9)    1.472219489583221 ~eql)
($error (atanh *most-negative-float*) <error>)
($error (atanh *most-positive-float*) <error>)
($eval (defconstant *most-negative-float-integer*
         (* -17976931348623157 (expt 10 (- 308 16)))))
($eval (defconstant *most-positive-float-integer*
         (* 17976931348623157 (expt 10 (- 308 16)))))

;;;
;;; ֐ (FLOATP obj) --> boolean
;;;
($ap 2 "floatp" P.76)
((floatp "2.4") nil)
((floatp 2) nil)
((floatp 2.0) t)
;;;
($argc floatp 1 0 0)
($predicate floatp $float)
;;;
((floatp *pi*) t)
((floatp *most-negative-float*) t)
((floatp *most-positive-float*) t)

;;;
;;; ֐ (FLOAT x) --> <float>
;;;
($ap 2 "float" P.77)
((float 0) 0.0 eql)
((float 2) 2.0 eql)
((float -2.0) -2.0 eql)
((float 123456789123456789123456789) 1.2345678912345679E26 eql)
;;;
($argc float 1 0 0)
($type float ($integer $float) :target)
;;;
((float -10000000000) -10000000000.0 eql)
((float     -8388609)     -8388609.0 eql)
((float     -8388608)     -8388608.0 eql)
((float           -1)           -1.0 eql)
((float            1)            1.0 eql)
((float      8388607)      8388607.0 eql)
((float      8388608)      8388608.0 eql)
((float  10000000000)  10000000000.0 eql)
((float -1.0e10)   -1.0e10 eql)
((float -123.4)  -123.4 eql)
((float   -1.0)    -1.0 eql)
((float    0.0)     0.0 eql)
((float    1.0)     1.0 eql)
((float  123.4)   123.4 eql)
((float  1.0e10)    1.0e10 eql)
((float *pi*) *pi* eval-eql)
((float *most-negative-float*) *most-negative-float* eval-eql)
((float *most-positive-float*) *most-positive-float* eval-eql)

;;;
;;; ֐ (FLOOR x) --> <integer>
;;;
($ap 2 "floor" P.77)
((floor 3.0) 3 eql)
((floor 3.4) 3 eql)
((floor 3.9) 3 eql)
((floor -3.9) -4 eql)
((floor -3.4) -4 eql)
((floor -3.0) -3 eql)
;;;
($argc floor 1 0 0)
($type floor ($integer $float) :target)
;;;
((floor -10000000000) -10000000000 eql)
((floor     -8388609)     -8388609 eql)
((floor     -8388608)     -8388608 eql)
((floor           -1)           -1 eql)
((floor            0)            0 eql)
((floor            1)            1 eql)
((floor      8388607)      8388607 eql)
((floor      8388608)      8388608 eql)
((floor  10000000000)  10000000000 eql)
((floor -10000000000.5) -10000000001 eql)
((floor -10000000000.0) -10000000000 eql)
((floor  -9999999999.5) -10000000000 eql)
((floor     -8388609.5)     -8388610 eql)
((floor     -8388609.0)     -8388609 eql)
((floor     -8388608.5)     -8388609 eql)
((floor     -8388608.0)     -8388608 eql)
((floor     -8388607.5)     -8388608 eql)
((floor           -1.5)           -2 eql)
((floor           -1.0)           -1 eql)
((floor           -0.5)           -1 eql)
((floor            0.0)            0 eql)
((floor            0.5)            0 eql)
((floor            1.0)            1 eql)
((floor            1.5)            1 eql)
((floor      8388606.5)      8388606 eql)
((floor      8388607.0)      8388607 eql)
((floor      8388607.5)      8388607 eql)
((floor      8388608.0)      8388608 eql)
((floor      8388608.5)      8388608 eql)
((floor   9999999999.5)   9999999999 eql)
((floor  10000000000.0)  10000000000 eql)
((floor  10000000000.5)  10000000000 eql)
((floor *pi*) 3 eql)

;;;
;;; ֐ (CEILING x) --> <integer>
;;;
($ap 2 "ceiling" P.77)
((ceiling 3.0) 3 eql)
((ceiling 3.4) 4 eql)
((ceiling 3.9) 4 eql)
((ceiling -3.9) -3 eql)
((ceiling -3.4) -3 eql)
((ceiling -3.0) -3 eql)
;;;
($argc ceiling 1 0 0)
($type ceiling ($integer $float) :target)
;;;
((ceiling -10000000000) -10000000000 eql)
((ceiling     -8388609)     -8388609 eql)
((ceiling     -8388608)     -8388608 eql)
((ceiling           -1)           -1 eql)
((ceiling            0)            0 eql)
((ceiling            1)            1 eql)
((ceiling      8388607)      8388607 eql)
((ceiling      8388608)      8388608 eql)
((ceiling  10000000000)  10000000000 eql)
((ceiling -10000000000.5) -10000000000 eql)
((ceiling -10000000000.0) -10000000000 eql)
((ceiling  -9999999999.5)  -9999999999 eql)
((ceiling     -8388609.5)     -8388609 eql)
((ceiling     -8388609.0)     -8388609 eql)
((ceiling     -8388608.5)     -8388608 eql)
((ceiling     -8388608.0)     -8388608 eql)
((ceiling     -8388607.5)     -8388607 eql)
((ceiling           -1.5)           -1 eql)
((ceiling           -1.0)           -1 eql)
((ceiling           -0.5)            0 eql)
((ceiling            0.0)            0 eql)
((ceiling            0.5)            1 eql)
((ceiling            1.0)            1 eql)
((ceiling            1.5)            2 eql)
((ceiling      8388606.5)      8388607 eql)
((ceiling      8388607.0)      8388607 eql)
((ceiling      8388607.5)      8388608 eql)
((ceiling      8388608.0)      8388608 eql)
((ceiling      8388608.5)      8388609 eql)
((ceiling   9999999999.5)  10000000000 eql)
((ceiling  10000000000.0)  10000000000 eql)
((ceiling  10000000000.5)  10000000001 eql)
((ceiling *pi*) 4 eql)

;;;
;;; ֐ (TRUNCATE x) --> <integer>
;;;
($ap 2 "truncate" P.78)
((truncate 3.0) 3 eql)
((truncate 3.4) 3 eql)
((truncate 3.9) 3 eql)
((truncate -3.9) -3 eql)
((truncate -3.4) -3 eql)
((truncate -3.0) -3 eql)
;;;
($argc truncate 1 0 0)
($type truncate ($integer $float) :target)
;;;
((truncate -10000000000) -10000000000 eql)
((truncate     -8388609)     -8388609 eql)
((truncate     -8388608)     -8388608 eql)
((truncate           -1)           -1 eql)
((truncate            0)            0 eql)
((truncate            1)            1 eql)
((truncate      8388607)      8388607 eql)
((truncate      8388608)      8388608 eql)
((truncate  10000000000)  10000000000 eql)
((truncate -10000000000.5) -10000000000 eql)
((truncate -10000000000.0) -10000000000 eql)
((truncate  -9999999999.5)  -9999999999 eql)
((truncate     -8388609.5)     -8388609 eql)
((truncate     -8388609.0)     -8388609 eql)
((truncate     -8388608.5)     -8388608 eql)
((truncate     -8388608.0)     -8388608 eql)
((truncate     -8388607.5)     -8388607 eql)
((truncate           -1.5)           -1 eql)
((truncate           -1.0)           -1 eql)
((truncate           -0.5)            0 eql)
((truncate            0.0)            0 eql)
((truncate            0.5)            0 eql)
((truncate            1.0)            1 eql)
((truncate            1.5)            1 eql)
((truncate      8388606.5)      8388606 eql)
((truncate      8388607.0)      8388607 eql)
((truncate      8388607.5)      8388607 eql)
((truncate      8388608.0)      8388608 eql)
((truncate      8388608.5)      8388608 eql)
((truncate   9999999999.5)   9999999999 eql)
((truncate  10000000000.0)  10000000000 eql)
((truncate  10000000000.5)  10000000000 eql)
((truncate *pi*) 3 eql)

;;;
;;; ֐ (ROUND x) --> <integer>
;;;
($ap 2 "round" P.78)
((round 3.0) 3 eql)
((round 3.4) 3 eql)
((round -3.4) -3 eql)
((round 3.6) 4 eql)
((round -3.6) -4 eql)
((round 3.5) 4 eql)
((round -3.5) -4 eql)
((round 2.5) 2 eql)
((round -0.5) 0 eql)
;;;
($argc round 1 0 0)
($type round ($integer $float) :target)
;;;
((round -10000000000) -10000000000 eql)
((round     -8388609)     -8388609 eql)
((round     -8388608)     -8388608 eql)
((round           -1)           -1 eql)
((round            0)            0 eql)
((round            1)            1 eql)
((round      8388607)      8388607 eql)
((round      8388608)      8388608 eql)
((round  10000000000)  10000000000 eql)
((round -10000000001.6) -10000000002 eql)
((round -10000000001.5) -10000000002 eql)
((round -10000000001.4) -10000000001 eql)
((round -10000000000.6) -10000000001 eql)
((round -10000000000.5) -10000000000 eql)
((round -10000000000.4) -10000000000 eql)
((round -10000000000.0) -10000000000 eql)
((round  -9999999999.6) -10000000000 eql)
((round  -9999999999.5) -10000000000 eql)
((round  -9999999999.4)  -9999999999 eql)
((round     -8388609.6)     -8388610 eql)
((round     -8388609.5)     -8388610 eql)
((round     -8388609.4)     -8388609 eql)
((round     -8388609.0)     -8388609 eql)
((round     -8388608.6)     -8388609 eql)
((round     -8388608.5)     -8388608 eql)
((round     -8388608.4)     -8388608 eql)
((round     -8388608.0)     -8388608 eql)
((round     -8388607.6)     -8388608 eql)
((round     -8388607.5)     -8388608 eql)
((round     -8388607.4)     -8388607 eql)
((round           -1.6)           -2 eql)
((round           -1.5)           -2 eql)
((round           -1.4)           -1 eql)
((round           -1.0)           -1 eql)
((round           -0.6)           -1 eql)
((round           -0.5)            0 eql)
((round           -0.4)            0 eql)
((round            0.0)            0 eql)
((round            0.4)            0 eql)
((round            0.5)            0 eql)
((round            0.6)            1 eql)
((round            1.0)            1 eql)
((round            1.4)            1 eql)
((round            1.5)            2 eql)
((round            1.6)            2 eql)
((round      8388606.4)      8388606 eql)
((round      8388606.5)      8388606 eql)
((round      8388606.6)      8388607 eql)
((round      8388607.0)      8388607 eql)
((round      8388607.4)      8388607 eql)
((round      8388607.5)      8388608 eql)
((round      8388607.6)      8388608 eql)
((round      8388608.0)      8388608 eql)
((round      8388608.4)      8388608 eql)
((round      8388608.5)      8388608 eql)
((round      8388608.6)      8388609 eql)
((round   9999999999.4)   9999999999 eql)
((round   9999999999.5)  10000000000 eql)
((round   9999999999.6)  10000000000 eql)
((round  10000000000.0)  10000000000 eql)
((round  10000000000.4)  10000000000 eql)
((round  10000000000.5)  10000000000 eql)
((round  10000000000.6)  10000000001 eql)
((round  10000000001.4)  10000000001 eql)
((round  10000000001.5)  10000000002 eql)
((round  10000000001.6)  10000000002 eql)
((round *pi*) 3 eql)

;;;
;;; ֐ (INTEGERP obj) --> boolean
;;;
($ap 2 "integerp" P.79)
((integerp 3) t)
((integerp 3.4) nil)
((integerp "4") nil)
((integerp '(a b c)) nil)
;;;
($argc integerp 1 0 0)
($predicate integerp $integer)

;;;
;;; ֐ (DIV z1 z2) --> <integer>
;;;
($ap 2 "div" P.79)
((div 12 3) 4 eql)
((div 14 3) 4 eql)
((div -12 3) -4 eql)
((div -14 3) -5 eql)
((div 12 -3) -4 eql)
((div 14 -3) -5 eql)
((div -12 -3) 4 eql)
((div -14 -3) 4 eql)
;;;
($argc div 2 0 0)
($type div ($integer) :target 0)
($type div ($integer) 0 :target)
;;;
((div -10000000000000001 -10000000000000000)  1 eql)
((div -10000000000000000 -10000000000000000)  1 eql)
((div  -9999999999999999 -10000000000000000)  0 eql)
((div           -8388609 -10000000000000000)  0 eql)
((div           -8388608 -10000000000000000)  0 eql)
((div                 -1 -10000000000000000)  0 eql)
((div                  0 -10000000000000000)  0 eql)
((div                  1 -10000000000000000) -1 eql)
((div            8388607 -10000000000000000) -1 eql)
((div            8388608 -10000000000000000) -1 eql)
((div   9999999999999999 -10000000000000000) -1 eql)
((div  10000000000000000 -10000000000000000) -1 eql)
((div  10000000000000001 -10000000000000000) -2 eql)
;;;
((div -83886090000000001 -8388609)  10000000000 eql)
((div -83886090000000000 -8388609)  10000000000 eql)
((div -83886089999999999 -8388609)   9999999999 eql)
((div           -8388610 -8388609)            1 eql)
((div           -8388609 -8388609)            1 eql)
((div           -8388608 -8388609)            0 eql)
((div                 -1 -8388609)            0 eql)
((div                  0 -8388609)            0 eql)
((div                  1 -8388609)           -1 eql)
((div            8388607 -8388609)           -1 eql)
((div            8388608 -8388609)           -1 eql)
((div            8388609 -8388609)           -1 eql)
((div            8388610 -8388609)           -2 eql)
((div  83886089999999999 -8388609) -10000000000 eql)
((div  83886090000000000 -8388609) -10000000000 eql)
((div  83886090000000001 -8388609) -10000000001 eql)
;;;
((div -83886080000000001 -8388608)  10000000000 eql)
((div -83886080000000000 -8388608)  10000000000 eql)
((div -83886079999999999 -8388608)   9999999999 eql)
((div           -8388609 -8388608)            1 eql)
((div           -8388608 -8388608)            1 eql)
((div           -8388607 -8388608)            0 eql)
((div                 -1 -8388608)            0 eql)
((div                  0 -8388608)            0 eql)
((div                  1 -8388608)           -1 eql)
((div            8388607 -8388608)           -1 eql)
((div            8388608 -8388608)           -1 eql)
((div            8388609 -8388608)           -2 eql)
((div  83886079999999999 -8388608) -10000000000 eql)
((div  83886080000000000 -8388608) -10000000000 eql)
((div  83886080000000001 -8388608) -10000000001 eql)
;;;
((div -10000000000000000 -1)  10000000000000000 eql)
((div           -8388609 -1)            8388609 eql)
((div           -8388608 -1)            8388608 eql)
((div           -8388607 -1)            8388607 eql)
((div                 -1 -1)                  1 eql)
((div                  0 -1)                  0 eql)
((div                  1 -1)                 -1 eql)
((div            8388607 -1)           -8388607 eql)
((div            8388608 -1)           -8388608 eql)
((div            8388609 -1)           -8388609 eql)
((div  10000000000000000 -1) -10000000000000000 eql)
;;;
($error (div -10000000000000000 0) <division-by-zero>)
($error (div           -8388608 0) <division-by-zero>)
($error (div           -8388607 0) <division-by-zero>)
($error (div                 -1 0) <division-by-zero>)
($error (div                  0 0) <division-by-zero>)
($error (div                  1 0) <division-by-zero>)
($error (div            8388607 0) <division-by-zero>)
($error (div            8388608 0) <division-by-zero>)
($error (div  10000000000000000 0) <division-by-zero>)
;;;
((div -10000000000000000 1) -10000000000000000 eql)
((div           -8388609 1)           -8388609 eql)
((div           -8388608 1)           -8388608 eql)
((div           -8388607 1)           -8388607 eql)
((div                 -1 1)                 -1 eql)
((div                  0 1)                  0 eql)
((div                  1 1)                  1 eql)
((div            8388607 1)            8388607 eql)
((div            8388608 1)            8388608 eql)
((div            8388609 1)            8388609 eql)
((div  10000000000000000 1)  10000000000000000 eql)
;;;
((div -83886070000000001 8388607) -10000000001 eql)
((div -83886070000000000 8388607) -10000000000 eql)
((div -83886069999999999 8388607) -10000000000 eql)
((div           -8388609 8388607)           -2 eql)
((div           -8388608 8388607)           -2 eql)
((div           -8388607 8388607)           -1 eql)
((div           -8388606 8388607)           -1 eql)
((div                 -1 8388607)           -1 eql)
((div                  0 8388607)            0 eql)
((div                  1 8388607)            0 eql)
((div            8388606 8388607)            0 eql)
((div            8388607 8388607)            1 eql)
((div            8388608 8388607)            1 eql)
((div  83886069999999999 8388607)   9999999999 eql)
((div  83886070000000000 8388607)  10000000000 eql)
((div  83886070000000001 8388607)  10000000000 eql)
;;;
((div -83886080000000001 8388608) -10000000001 eql)
((div -83886080000000000 8388608) -10000000000 eql)
((div -83886079999999999 8388608) -10000000000 eql)
((div           -8388609 8388608)           -2 eql)
((div           -8388608 8388608)           -1 eql)
((div           -8388607 8388608)           -1 eql)
((div                 -1 8388608)           -1 eql)
((div                  0 8388608)            0 eql)
((div                  1 8388608)            0 eql)
((div            8388607 8388608)            0 eql)
((div            8388608 8388608)            1 eql)
((div            8388609 8388608)            1 eql)
((div  83886079999999999 8388608)   9999999999 eql)
((div  83886080000000000 8388608)  10000000000 eql)
((div  83886080000000001 8388608)  10000000000 eql)
;;;
((div -10000000000000001 10000000000000000) -2 eql)
((div -10000000000000000 10000000000000000) -1 eql)
((div  -9999999999999999 10000000000000000) -1 eql)
((div           -8388609 10000000000000000) -1 eql)
((div           -8388608 10000000000000000) -1 eql)
((div                 -1 10000000000000000) -1 eql)
((div                  0 10000000000000000)  0 eql)
((div                  1 10000000000000000)  0 eql)
((div            8388607 10000000000000000)  0 eql)
((div            8388608 10000000000000000)  0 eql)
((div   9999999999999999 10000000000000000)  0 eql)
((div  10000000000000000 10000000000000000)  1 eql)
((div  10000000000000001 10000000000000000)  1 eql)

;;;
;;; ֐ (MOD z1 z2) --> <integer>
;;;
($ap 2 "mod" P.79)
((mod 12 3) 0 eql)
((mod 7 247) 7 eql)
((mod 247 7) 2 eql)
((mod 14 3) 2 eql)
((mod -12 3) 0 eql)
((mod -14 3) 1 eql)
((mod 12 -3) 0 eql)
((mod 14 -3) -1 eql)
((mod -12 -3) 0 eql)
((mod -14 -3) -2 eql)
;;;
($argc mod 2 0 0)
($type mod ($integer) :target 1)
($type mod ($integer) 1 :target)
;;;
((mod -10000000000000001 -10000000000000000)                -1 eql)
((mod -10000000000000000 -10000000000000000)                 0 eql)
((mod  -9999999999999999 -10000000000000000) -9999999999999999 eql)
((mod           -8388609 -10000000000000000)          -8388609 eql)
((mod           -8388608 -10000000000000000)          -8388608 eql)
((mod                 -1 -10000000000000000)                -1 eql)
((mod                  0 -10000000000000000)                 0 eql)
((mod                  1 -10000000000000000) -9999999999999999 eql)
((mod            8388607 -10000000000000000) -9999999991611393 eql)
((mod            8388608 -10000000000000000) -9999999991611392 eql)
((mod   9999999999999999 -10000000000000000)                -1 eql)
((mod  10000000000000000 -10000000000000000)                 0 eql)
((mod  10000000000000001 -10000000000000000) -9999999999999999 eql)
;;;
((mod -83886090000000001 -8388609)       -1 eql)
((mod -83886090000000000 -8388609)        0 eql)
((mod -83886089999999999 -8388609) -8388608 eql)
((mod           -8388610 -8388609)       -1 eql)
((mod           -8388609 -8388609)        0 eql)
((mod           -8388608 -8388609) -8388608 eql)
((mod                 -1 -8388609)       -1 eql)
((mod                  0 -8388609)        0 eql)
((mod                  1 -8388609) -8388608 eql)
((mod            8388607 -8388609)       -2 eql)
((mod            8388608 -8388609)       -1 eql)
((mod            8388609 -8388609)        0 eql)
((mod            8388610 -8388609) -8388608 eql)
((mod  83886089999999999 -8388609)       -1 eql)
((mod  83886090000000000 -8388609)        0 eql)
((mod  83886090000000001 -8388609) -8388608 eql)
;;;
((mod -83886080000000001 -8388608)       -1 eql)
((mod -83886080000000000 -8388608)        0 eql)
((mod -83886079999999999 -8388608) -8388607 eql)
((mod           -8388609 -8388608)       -1 eql)
((mod           -8388608 -8388608)        0 eql)
((mod           -8388607 -8388608) -8388607 eql)
((mod                 -1 -8388608)       -1 eql)
((mod                  0 -8388608)        0 eql)
((mod                  1 -8388608) -8388607 eql)
((mod            8388607 -8388608)       -1 eql)
((mod            8388608 -8388608)        0 eql)
((mod            8388609 -8388608) -8388607 eql)
((mod  83886079999999999 -8388608)       -1 eql)
((mod  83886080000000000 -8388608)        0 eql)
((mod  83886080000000001 -8388608) -8388607 eql)
;;;
((mod -10000000000000000 -1) 0 eql)
((mod           -8388609 -1) 0 eql)
((mod           -8388608 -1) 0 eql)
((mod           -8388607 -1) 0 eql)
((mod                 -1 -1) 0 eql)
((mod                  0 -1) 0 eql)
((mod                  1 -1) 0 eql)
((mod            8388607 -1) 0 eql)
((mod            8388608 -1) 0 eql)
((mod            8388609 -1) 0 eql)
((mod  10000000000000000 -1) 0 eql)
;;;
($error (mod -10000000000000000 0) <division-by-zero>)
($error (mod           -8388608 0) <division-by-zero>)
($error (mod           -8388607 0) <division-by-zero>)
($error (mod                 -1 0) <division-by-zero>)
($error (mod                  0 0) <division-by-zero>)
($error (mod                  1 0) <division-by-zero>)
($error (mod            8388607 0) <division-by-zero>)
($error (mod            8388608 0) <division-by-zero>)
($error (mod  10000000000000000 0) <division-by-zero>)
;;;
((mod -10000000000000000 1) 0 eql)
((mod           -8388609 1) 0 eql)
((mod           -8388608 1) 0 eql)
((mod           -8388607 1) 0 eql)
((mod                 -1 1) 0 eql)
((mod                  0 1) 0 eql)
((mod                  1 1) 0 eql)
((mod            8388607 1) 0 eql)
((mod            8388608 1) 0 eql)
((mod            8388609 1) 0 eql)
((mod  10000000000000000 1) 0 eql)
;;;
((mod -83886070000000001 8388607) 8388606 eql)
((mod -83886070000000000 8388607)       0 eql)
((mod -83886069999999999 8388607)       1 eql)
((mod           -8388609 8388607) 8388605 eql)
((mod           -8388608 8388607) 8388606 eql)
((mod           -8388607 8388607)       0 eql)
((mod           -8388606 8388607)       1 eql)
((mod                 -1 8388607) 8388606 eql)
((mod                  0 8388607)       0 eql)
((mod                  1 8388607)       1 eql)
((mod            8388606 8388607) 8388606 eql)
((mod            8388607 8388607)       0 eql)
((mod            8388608 8388607)       1 eql)
((mod  83886069999999999 8388607) 8388606 eql)
((mod  83886070000000000 8388607)       0 eql)
((mod  83886070000000001 8388607)       1 eql)
;;;
((mod -83886080000000001 8388608) 8388607 eql)
((mod -83886080000000000 8388608)       0 eql)
((mod -83886079999999999 8388608)       1 eql)
((mod           -8388609 8388608) 8388607 eql)
((mod           -8388608 8388608)       0 eql)
((mod           -8388607 8388608)       1 eql)
((mod                 -1 8388608) 8388607 eql)
((mod                  0 8388608)       0 eql)
((mod                  1 8388608)       1 eql)
((mod            8388607 8388608) 8388607 eql)
((mod            8388608 8388608)       0 eql)
((mod            8388609 8388608)       1 eql)
((mod  83886079999999999 8388608) 8388607 eql)
((mod  83886080000000000 8388608)       0 eql)
((mod  83886080000000001 8388608)       1 eql)
;;;
((mod -10000000000000001 10000000000000000) 9999999999999999 eql)
((mod -10000000000000000 10000000000000000)                0 eql)
((mod  -9999999999999999 10000000000000000)                1 eql)
((mod           -8388609 10000000000000000) 9999999991611391 eql)
((mod           -8388608 10000000000000000) 9999999991611392 eql)
((mod                 -1 10000000000000000) 9999999999999999 eql)
((mod                  0 10000000000000000)                0 eql)
((mod                  1 10000000000000000)                1 eql)
((mod            8388607 10000000000000000)          8388607 eql)
((mod            8388608 10000000000000000)          8388608 eql)
((mod   9999999999999999 10000000000000000) 9999999999999999 eql)
((mod  10000000000000000 10000000000000000)                0 eql)
((mod  10000000000000001 10000000000000000)                1 eql)

;;;
;;; ֐ (GCD z1 z2) --> <integer>
;;;
($ap 2 "gcd" P.80)
((gcd 12 5) 1 eql)
((gcd 15 24) 3 eql)
((gcd -15 24) 3 eql)
((gcd 15 -24) 3 eql)
((gcd -15 -24) 3 eql)
((gcd 0 -4) 4 eql)
((gcd 0 0) 0 eql)
;;;
($argc gcd 2 0 0)
($type gcd ($integer) :target 1)
($type gcd ($integer) 1 :target)
;;;
((gcd -10000000000000001 -10000000000000000)                 1 eql)
((gcd -10000000000000000 -10000000000000000) 10000000000000000 eql)
((gcd  -9999999999999999 -10000000000000000)                 1 eql)
((gcd           -8388609 -10000000000000000)                 1 eql)
((gcd           -8388608 -10000000000000000)             65536 eql)
((gcd                 -1 -10000000000000000)                 1 eql)
((gcd                  0 -10000000000000000) 10000000000000000 eql)
((gcd                  1 -10000000000000000)                 1 eql)
((gcd            8388607 -10000000000000000)                 1 eql)
((gcd            8388608 -10000000000000000)             65536 eql)
((gcd   9999999999999999 -10000000000000000)                 1 eql)
((gcd  10000000000000000 -10000000000000000) 10000000000000000 eql)
((gcd  10000000000000001 -10000000000000000)                 1 eql)
;;;
((gcd -83886090000000001 -8388609)       1 eql)
((gcd -83886090000000000 -8388609) 8388609 eql)
((gcd -83886089999999999 -8388609)       1 eql)
((gcd           -8388610 -8388609)       1 eql)
((gcd           -8388609 -8388609) 8388609 eql)
((gcd           -8388608 -8388609)       1 eql)
((gcd                 -1 -8388609)       1 eql)
((gcd                  0 -8388609) 8388609 eql)
((gcd                  1 -8388609)       1 eql)
((gcd            8388607 -8388609)       1 eql)
((gcd            8388608 -8388609)       1 eql)
((gcd            8388609 -8388609) 8388609 eql)
((gcd            8388610 -8388609)       1 eql)
((gcd  83886089999999999 -8388609)       1 eql)
((gcd  83886090000000000 -8388609) 8388609 eql)
((gcd  83886090000000001 -8388609)       1 eql)
;;;
((gcd -83886080000000001 -8388608)       1 eql)
((gcd -83886080000000000 -8388608) 8388608 eql)
((gcd -83886079999999999 -8388608)       1 eql)
((gcd           -8388609 -8388608)       1 eql)
((gcd           -8388608 -8388608) 8388608 eql)
((gcd           -8388607 -8388608)       1 eql)
((gcd                 -1 -8388608)       1 eql)
((gcd                  0 -8388608) 8388608 eql)
((gcd                  1 -8388608)       1 eql)
((gcd            8388607 -8388608)       1 eql)
((gcd            8388608 -8388608) 8388608 eql)
((gcd            8388609 -8388608)       1 eql)
((gcd  83886079999999999 -8388608)       1 eql)
((gcd  83886080000000000 -8388608) 8388608 eql)
((gcd  83886080000000001 -8388608)       1 eql)
;;;
((gcd -10000000000000000 -1) 1 eql)
((gcd           -8388609 -1) 1 eql)
((gcd           -8388608 -1) 1 eql)
((gcd           -8388607 -1) 1 eql)
((gcd                 -1 -1) 1 eql)
((gcd                  0 -1) 1 eql)
((gcd                  1 -1) 1 eql)
((gcd            8388607 -1) 1 eql)
((gcd            8388608 -1) 1 eql)
((gcd            8388609 -1) 1 eql)
((gcd  10000000000000000 -1) 1 eql)
;;;
((gcd -10000000000000000 0) 10000000000000000 eql)
((gcd           -8388608 0)           8388608 eql)
((gcd           -8388607 0)           8388607 eql)
((gcd                 -1 0)                 1 eql)
((gcd                  0 0)                 0 eql)
((gcd                  1 0)                 1 eql)
((gcd            8388607 0)           8388607 eql)
((gcd            8388608 0)           8388608 eql)
((gcd  10000000000000000 0) 10000000000000000 eql)
;;;
((gcd -10000000000000000 1) 1 eql)
((gcd           -8388609 1) 1 eql)
((gcd           -8388608 1) 1 eql)
((gcd           -8388607 1) 1 eql)
((gcd                 -1 1) 1 eql)
((gcd                  0 1) 1 eql)
((gcd                  1 1) 1 eql)
((gcd            8388607 1) 1 eql)
((gcd            8388608 1) 1 eql)
((gcd            8388609 1) 1 eql)
((gcd  10000000000000000 1) 1 eql)
;;;
((gcd -83886070000000001 8388607)       1 eql)
((gcd -83886070000000000 8388607) 8388607 eql)
((gcd -83886069999999999 8388607)       1 eql)
((gcd           -8388609 8388607)       1 eql)
((gcd           -8388608 8388607)       1 eql)
((gcd           -8388607 8388607) 8388607 eql)
((gcd           -8388606 8388607)       1 eql)
((gcd                 -1 8388607)       1 eql)
((gcd                  0 8388607) 8388607 eql)
((gcd                  1 8388607)       1 eql)
((gcd            8388606 8388607)       1 eql)
((gcd            8388607 8388607) 8388607 eql)
((gcd            8388608 8388607)       1 eql)
((gcd  83886069999999999 8388607)       1 eql)
((gcd  83886070000000000 8388607) 8388607 eql)
((gcd  83886070000000001 8388607)       1 eql)
;;;
((gcd -83886080000000001 8388608)       1 eql)
((gcd -83886080000000000 8388608) 8388608 eql)
((gcd -83886079999999999 8388608)       1 eql)
((gcd           -8388609 8388608)       1 eql)
((gcd           -8388608 8388608) 8388608 eql)
((gcd           -8388607 8388608)       1 eql)
((gcd                 -1 8388608)       1 eql)
((gcd                  0 8388608) 8388608 eql)
((gcd                  1 8388608)       1 eql)
((gcd            8388607 8388608)       1 eql)
((gcd            8388608 8388608) 8388608 eql)
((gcd            8388609 8388608)       1 eql)
((gcd  83886079999999999 8388608)       1 eql)
((gcd  83886080000000000 8388608) 8388608 eql)
((gcd  83886080000000001 8388608)       1 eql)
;;;
((gcd -10000000000000001 10000000000000000)                 1 eql)
((gcd -10000000000000000 10000000000000000) 10000000000000000 eql)
((gcd  -9999999999999999 10000000000000000)                 1 eql)
((gcd           -8388609 10000000000000000)                 1 eql)
((gcd           -8388608 10000000000000000)             65536 eql)
((gcd                 -1 10000000000000000)                 1 eql)
((gcd                  0 10000000000000000) 10000000000000000 eql)
((gcd                  1 10000000000000000)                 1 eql)
((gcd            8388607 10000000000000000)                 1 eql)
((gcd            8388608 10000000000000000)             65536 eql)
((gcd   9999999999999999 10000000000000000)                 1 eql)
((gcd  10000000000000000 10000000000000000) 10000000000000000 eql)
((gcd  10000000000000001 10000000000000000)                 1 eql)

;;;
;;; ֐ (LCM z1 z2) --> <integer>
;;;
($ap 2 "lcm" P.80)
((lcm 2 3) 6 eql)
((lcm 15 24) 120 eql)
((lcm 15 -24) 120 eql)
((lcm -15 24) 120 eql)
((lcm -15 -24) 120 eql)
((lcm 0 -4) 0 eql)
((lcm 0 0) 0 eql)
;;;
($argc lcm 2 0 0)
($type lcm ($integer) :target 1)
($type lcm ($integer) 1 :target)
;;;
((lcm -10000000000000001 -10000000000000000) 100000000000000010000000000000000 eql)
((lcm -10000000000000000 -10000000000000000)                 10000000000000000 eql)
((lcm  -9999999999999999 -10000000000000000)  99999999999999990000000000000000 eql)
((lcm           -8388609 -10000000000000000)           83886090000000000000000 eql)
((lcm           -8388608 -10000000000000000)               1280000000000000000 eql)
((lcm                 -1 -10000000000000000)                 10000000000000000 eql)
((lcm                  0 -10000000000000000)                                 0 eql)
((lcm                  1 -10000000000000000)                 10000000000000000 eql)
((lcm            8388607 -10000000000000000)           83886070000000000000000 eql)
((lcm            8388608 -10000000000000000)               1280000000000000000 eql)
((lcm   9999999999999999 -10000000000000000)  99999999999999990000000000000000 eql)
((lcm  10000000000000000 -10000000000000000)                 10000000000000000 eql)
((lcm  10000000000000001 -10000000000000000) 100000000000000010000000000000000 eql)
;;;
((lcm -83886090000000001 -8388609) 703687609548810008388609 eql)
((lcm -83886090000000000 -8388609)        83886090000000000 eql)
((lcm -83886089999999999 -8388609) 703687609548809991611391 eql)
((lcm           -8388610 -8388609)           70368769343490 eql)
((lcm           -8388609 -8388609)                  8388609 eql)
((lcm           -8388608 -8388609)           70368752566272 eql)
((lcm                 -1 -8388609)                  8388609 eql)
((lcm                  0 -8388609)                        0 eql)
((lcm                  1 -8388609)                  8388609 eql)
((lcm            8388607 -8388609)           70368744177663 eql)
((lcm            8388608 -8388609)           70368752566272 eql)
((lcm            8388609 -8388609)                  8388609 eql)
((lcm            8388610 -8388609)           70368769343490 eql)
((lcm  83886089999999999 -8388609) 703687609548809991611391 eql)
((lcm  83886090000000000 -8388609)        83886090000000000 eql)
((lcm  83886090000000001 -8388609) 703687609548810008388609 eql)
;;;
((lcm -83886080000000001 -8388608) 703687441776640008388608 eql)
((lcm -83886080000000000 -8388608)        83886080000000000 eql)
((lcm -83886079999999999 -8388608) 703687441776639991611392 eql)
((lcm           -8388609 -8388608)           70368752566272 eql)
((lcm           -8388608 -8388608)                  8388608 eql)
((lcm           -8388607 -8388608)           70368735789056 eql)
((lcm                 -1 -8388608)                  8388608 eql)
((lcm                  0 -8388608)                        0 eql)
((lcm                  1 -8388608)                  8388608 eql)
((lcm            8388607 -8388608)           70368735789056 eql)
((lcm            8388608 -8388608)                  8388608 eql)
((lcm            8388609 -8388608)           70368752566272 eql)
((lcm  83886079999999999 -8388608) 703687441776639991611392 eql)
((lcm  83886080000000000 -8388608)        83886080000000000 eql)
((lcm  83886080000000001 -8388608) 703687441776640008388608 eql)
;;;
((lcm -10000000000000000 -1) 10000000000000000 eql)
((lcm           -8388609 -1)           8388609 eql)
((lcm           -8388608 -1)           8388608 eql)
((lcm           -8388607 -1)           8388607 eql)
((lcm                 -1 -1)                 1 eql)
((lcm                  0 -1)                 0 eql)
((lcm                  1 -1)                 1 eql)
((lcm            8388607 -1)           8388607 eql)
((lcm            8388608 -1)           8388608 eql)
((lcm            8388609 -1)           8388609 eql)
((lcm  10000000000000000 -1) 10000000000000000 eql)
;;;
((lcm -10000000000000000 0) 0 eql)
((lcm           -8388608 0) 0 eql)
((lcm           -8388607 0) 0 eql)
((lcm                 -1 0) 0 eql)
((lcm                  0 0) 0 eql)
((lcm                  1 0) 0 eql)
((lcm            8388607 0) 0 eql)
((lcm            8388608 0) 0 eql)
((lcm  10000000000000000 0) 0 eql)
;;;
((lcm -10000000000000000 1) 10000000000000000 eql)
((lcm           -8388609 1)           8388609 eql)
((lcm           -8388608 1)           8388608 eql)
((lcm           -8388607 1)           8388607 eql)
((lcm                 -1 1)                 1 eql)
((lcm                  0 1)                 0 eql)
((lcm                  1 1)                 1 eql)
((lcm            8388607 1)           8388607 eql)
((lcm            8388608 1)           8388608 eql)
((lcm            8388609 1)           8388609 eql)
((lcm  10000000000000000 1) 10000000000000000 eql)
;;;
((lcm -83886070000000001 8388607) 703687274004490008388607 eql)
((lcm -83886070000000000 8388607)        83886070000000000 eql)
((lcm -83886069999999999 8388607) 703687274004489991611393 eql)
((lcm           -8388609 8388607)           70368744177663 eql)
((lcm           -8388608 8388607)           70368735789056 eql)
((lcm           -8388607 8388607)                  8388607 eql)
((lcm           -8388606 8388607)           70368719011842 eql)
((lcm                 -1 8388607)                  8388607 eql)
((lcm                  0 8388607)                        0 eql)
((lcm                  1 8388607)                  8388607 eql)
((lcm            8388606 8388607)           70368719011842 eql)
((lcm            8388607 8388607)                  8388607 eql)
((lcm            8388608 8388607)           70368735789056 eql)
((lcm  83886069999999999 8388607) 703687274004489991611393 eql)
((lcm  83886070000000000 8388607)        83886070000000000 eql)
((lcm  83886070000000001 8388607) 703687274004490008388607 eql)
;;;
((lcm -83886080000000001 8388608) 703687441776640008388608 eql)
((lcm -83886080000000000 8388608)        83886080000000000 eql)
((lcm -83886079999999999 8388608) 703687441776639991611392 eql)
((lcm           -8388609 8388608)           70368752566272 eql)
((lcm           -8388608 8388608)                  8388608 eql)
((lcm           -8388607 8388608)           70368735789056 eql)
((lcm                 -1 8388608)                  8388608 eql)
((lcm                  0 8388608)                        0 eql)
((lcm                  1 8388608)                  8388608 eql)
((lcm            8388607 8388608)           70368735789056 eql)
((lcm            8388608 8388608)                  8388608 eql)
((lcm            8388609 8388608)           70368752566272 eql)
((lcm  83886079999999999 8388608) 703687441776639991611392 eql)
((lcm  83886080000000000 8388608)        83886080000000000 eql)
((lcm  83886080000000001 8388608) 703687441776640008388608 eql)
;;;
((lcm -10000000000000001 10000000000000000) 100000000000000010000000000000000 eql)
((lcm -10000000000000000 10000000000000000)                 10000000000000000 eql)
((lcm  -9999999999999999 10000000000000000)  99999999999999990000000000000000 eql)
((lcm           -8388609 10000000000000000)           83886090000000000000000 eql)
((lcm           -8388608 10000000000000000)               1280000000000000000 eql)
((lcm                 -1 10000000000000000)                 10000000000000000 eql)
((lcm                  0 10000000000000000)                                 0 eql)
((lcm                  1 10000000000000000)                 10000000000000000 eql)
((lcm            8388607 10000000000000000)           83886070000000000000000 eql)
((lcm            8388608 10000000000000000)               1280000000000000000 eql)
((lcm   9999999999999999 10000000000000000)  99999999999999990000000000000000 eql)
((lcm  10000000000000000 10000000000000000)                 10000000000000000 eql)
((lcm  10000000000000001 10000000000000000) 100000000000000010000000000000000 eql)

;;;
;;; ֐ (ISQRT z) --> <integer>
;;;
($ap 2 "isqrt" P.81)
((isqrt 49) 7 eql)
((isqrt 63) 7 eql)
((isqrt 1000000000000002000000000000000) 1000000000000000 eql)
;;;
($argc isqrt 1 0 0)
($type isqrt ($integer) :target)
;;;
($error (isqrt -1234567890) <domain-error>)
($error (isqrt -1) <domain-error>)
((isqrt                 0)         0 eql)
((isqrt                 1)         1 eql)
((isqrt           8388607)      2896 eql)
((isqrt           8388608)      2896 eql)
((isqrt        9999999999)     99999 eql)
((isqrt       10000000000)    100000 eql)
((isqrt       10000000001)    100000 eql)
((isqrt    70368727400448)   8388606 eql)
((isqrt    70368727400449)   8388607 eql)
((isqrt    70368727400450)   8388607 eql)
((isqrt    70368744177663)   8388607 eql)
((isqrt    70368744177664)   8388608 eql)
((isqrt    70368744177665)   8388608 eql)
((isqrt  9999999999999999)  99999999 eql)
((isqrt 10000000000000000) 100000000 eql)
((isqrt 10000000000000001) 100000000 eql)
