;;;
;;;  T  Predicates
;;;

($ap 1 "Predicates")

;;;
;;; ֐ EQ
;;;
($ap 2 "eq" P.26)
((eq () ()) t)
((eq '() '()) t)
((eq 'a 'a) t)
((eq 'a 'A) t)
((eq 'a 'b) nil)
((eq 'f 'nil) nil)
;;((eq 2 2) t)						; nil or t (IDEF)
((eq 2 2.0) nil)
;;((eq 100000000 100000000) nil)			; nil or t (IDEF)
;;((eq 10.00000 10.0) nil)				; nil or t (IDEF)
((eq (cons 1 2) (cons 1 2)) nil)
((let ((x '(a))) (eq x x)) t)
;;((eq '(a) '(a)) nil)					; nil or t (IDEF)
;;((let ((x '(b)) (y '(a b))) (eq x (cdr y))) nil)	; nil or t (IDEF)
;;((eq '(b) (cdr '(a b))) nil)				; nil or t (IDEF)
((let ((p (lambda (x) x))) (eq p p)) t)
((let ((x "a")) (eq x x)) t)
;;((eq "a" "a") nil)					; nil or t (IDEF)
((let ((x "")) (eq x x)) t)
;;((eq "" "") nil)					; nil or t (IDEF)
((eq #\a #\A) nil)
;;((eq #\a #\a) t)					; nil or t (IDEF)
;;((eq #\space #\Space) t)				; nil or t (IDEF)
;;((eq #\space #\space) t)				; nil or t (IDEF)
;;;
($argc eq 2 0 0)

;;;
;;; ֐ (EQL obj1 obj2) --> boolean
;;;
($ap 2 "eql" P.26)
((eql () ()) t)
((eql '() '()) t)
((eql 'a 'a) t)
((eql 'a 'A) t)
((eql 'a 'b) nil)
((eql 'f 'nil) nil)
((eql 2 2) t)
((eql 2 2.0) nil)
((eql 100000000 100000000) t)
((eql 10.00000 10.0) t)
((eql (cons 1 2) (cons 1 2)) nil)
((let ((x '(a))) (eql x x)) t)
;;((eql '(a) '(a)) nil)					; nil or t (IDEF)
;;((let ((x '(b)) (y '(a b))) (eql x (cdr y))) nil)	; nil or t (IDEF)
;;((eql '(b) (cdr '(a b))) nil)				; nil or t (IDEF)
((let ((p (lambda (x) x))) (eql p p)) t)
((let ((x "a")) (eql x x)) t)
;;((eql "a" "a") nil)					; nil or t (IDEF)
((let ((x "")) (eql x x)) t)
;;((eql "" "") nil)					; nil or t (IDEF)
((eql #\a #\A) nil)
((eql #\a #\a) t)
((eql #\space #\Space) t)
((eql #\space #\space) t)
;;;
($argc eql 2 0 0)
;;;
((eql *most-negative-float* *most-negative-float*) t)
((eql *most-negative-float* *most-positive-float*) nil)

;;;
;;; ֐ (EQUAL obj1 obj2) --> boolean
;;;
($ap 2 "equal" P.28)
((equal 'a 'a) t)
((equal 2 2) t)
((equal 2 2.0) nil)
((equal '(a) '(a)) t)
((equal '(a (b) c) '(a (b) c)) t)
((equal (cons 1 2) (cons 1 2)) t)
((equal '(a) (list 'a)) t)
((equal "abc" "abc") t)
((equal (vector 'a) (vector 'a)) t)
((equal #(a b) #(a b)) t)
((equal #(a b) #(a c)) nil)
((equal "a" "A") nil)
;;;
($argc equal 2 0 0)
;;;
((equal 2.0 2.0) t)
((equal *most-negative-float* *most-negative-float*) t)
((equal *most-negative-float* *most-positive-float*) nil)
((equal "" "") t)
((equal (create-string 1000 #\a) (create-string 1000 #\a)) t)
((equal (create-string 1000 #\a) (create-string 1000 #\b)) nil)
((equal #() #()) t)
((equal #(a #(b) c) #(a #(b) c)) t)
((equal #(a #(b) c) #(a #(d) c)) nil)
((equal (create-vector 1000 'a) (create-vector 1000 'a)) t)
((equal (create-vector 1000 'a) (create-vector 1000 'b)) nil)
((equal (create-array () 'a) (create-array () 'a)) t)
((equal (create-array () 'a) (create-array () 'b)) nil)
((equal (create-array '(1 2 3) 'a) (create-array '(1 2 3) 'a)) t)
((equal (create-array '(1 2 3) 'a) (create-array '(1 2 3) 'b)) nil)

;;;
;;; ֐ (NOT obj) --> boolean
;;;
($ap 2 "not" P.29)
((not t) nil)
((not '()) t)
((not 'nil) t)
((not nil) t)
((not 3) nil)
((not (list)) t)
((not (list 3)) nil)
;;;
($argc not 1 0 0)
($predicate not $null)

;;;
;;; ` (AND form*) --> <object>
;;;
($ap 2 "and" P.29)
((and (= 2 2) (> 2 1)) t)
((and (= 2 2) (< 2 1)) nil)
((and (eql 'a 'a) (not (> 1 2))) t)
((let ((x 'a)) (and x (setq x 'b))) b)
((let ((x nil)) (and x (setq x 'b))) nil)
((let ((time 10))
   (if (and (< time 24) (> time 12))
       (- time 12) time))
 10
 eql)
((let ((time 18))
   (if (and (< time 24) (> time 12))
       (- time 12) time))
 6
 eql)
;;;
($argc and 0 0 1)
;;;
((and) t)
((and (cons 1 2)) (1 . 2) equal)
((and (cons 1 2) nil (cons 3 4)) nil)
((and (cons 1 2) (cons 3 4) nil) nil)
((and (cons 1 2) (cons 3 4) (cons 5 6)) (5 . 6) equal)

;;;
;;; ` (OR form*) --> <object>
;;;
($ap 2 "or" P.30)
((or (= 2 2) (> 2 1)) t)
((or (= 2 2) (< 2 1)) t)
((let ((x 'a)) (or x (setq x 'b))) a)
((let ((x nil)) (or x (setq x 'b))) b)
;;;
($argc or 0 0 1)
;;;
((or) nil)
((or (cons 1 2)) (1 . 2) equal)
((or nil (cons 1 2) (cons 3 4)) (1 . 2) equal)
((or (cons 1 2) (cons 3 4) (cons 5 6)) (1 . 2) equal)
((or nil nil nil nil nil) nil)
