;;;
;;;  PU  String class
;;;

($ap 1 "String class")

;;;
;;; ֐ (STRINGP obj) --> boolean
;;;
($ap 2 "stringp" P.95)
((stringp "abc") t)
((stringp 'abc) nil)
;;;
($argc stringp 1 0 0)
($predicate stringp $string)

;;;
;;; ֐ (CREATE-STRING i [initial-element]) --> <string>
;;;
($ap 2 "create-string" P.95)
((create-string 3 #\a) "aaa" string=)
((create-string 0 #\a) "" string=)
;;;
($argc create-string 1 1 0)
($type create-string ($integer) :target)
;;;
((create-string 0) "" string=)
((create-string 1) " " string=)
((length (create-string 1000)) 1000 eql)
($error (create-string -1) <domain-error>)
($error (create-string -1234567890) <domain-error>)
($error (create-string 1234567890) <storage-exhausted>)

;;;
;;; ֐ (STRING= string1 string2) --> quasi-boolean
;;;
($ap 2 "string=" P.96)
((if (string= "abcd" "abcd") t nil) t)
((if (string= "abcd" "wxyz") t nil) nil)
((if (string= "abcd" "abcde") t nil) nil)
((if (string= "abcde" "abcd") t nil) nil)
;;;
($argc string= 2 0 0)
($type string= ($string) :target "a")
($type string= ($string) "a" :target)
;;;
((string= "" "") t)
((string= "" "a") nil)
((string= "a" "") nil)
((string= "abcd" "Abcd") nil)
((string= "abcd" "abcD") nil)
((string= (create-string 1000 #\a) (create-string 1000 #\a)) t)
((string= (create-string 1000 #\a) (create-string 1000 #\b)) nil)

;;;
;;; ֐ (STRING/= string1 string2) --> quasi-boolean
;;;
($ap 2 "string/=" P.96)
((if (string/= "abcd" "wxyz") t nil) t)
;;;
($argc string/= 2 0 0)
($type string/= ($string) :target "a")
($type string/= ($string) "a" :target)
;;;
((string/= "" "") nil)
((string/= "" "a") t)
((string/= "a" "") t)
((string/= "abcd" "Abcd") t)
((string/= "abcd" "abcD") t)
((string/= (create-string 1000 #\a) (create-string 1000 #\a)) nil)
((string/= (create-string 1000 #\a) (create-string 1000 #\b)) t)

;;;
;;; ֐ (STRING< string1 string2) --> quasi-boolean
;;;
($ap 2 "string<" P.96)
((if (string< "abcd" "abcd") t nil) nil)
((if (string< "abcd" "wxyz") t nil) t)
((if (string< "abcd" "abcde") t nil) t)
((if (string< "abcde" "abcd") t nil) nil)
;;;
($argc string< 2 0 0)
($type string< ($string) :target "a")
($type string< ($string) "a" :target)
;;;
((string< "" "") nil)
((string< "" "a") t)
((string< "a" "") nil)
((string< (create-string 1000 #\a) (create-string 1000 #\a)) nil)
((string< (create-string 1000 #\a) (create-string 1000 #\b)) t)
((string< (create-string 1000 #\b) (create-string 1000 #\a)) nil)

;;;
;;; ֐ (STRING> string1 string2) --> quasi-boolean
;;;
($ap 2 "string>" P.96)
((if (string> "abcd" "wxyz") t nil) nil)
;;;
($argc string> 2 0 0)
($type string> ($string) :target "a")
($type string> ($string) "a" :target)
;;;
((string> "" "") nil)
((string> "" "a") nil)
((string> "a" "") t)
((string> (create-string 1000 #\a) (create-string 1000 #\a)) nil)
((string> (create-string 1000 #\a) (create-string 1000 #\b)) nil)
((string> (create-string 1000 #\b) (create-string 1000 #\a)) t)

;;;
;;; ֐ (STRING>= string1 string2) --> quasi-boolean
;;;
($ap 2 "string>=" P.96)
((if (string>= "abcd" "abcd") t nil) t)
;;;
($argc string>= 2 0 0)
($type string>= ($string) :target "a")
($type string>= ($string) "a" :target)
;;;
((string>= "" "") t)
((string>= "" "a") nil)
((string>= "a" "") t)
((string>= (create-string 1000 #\a) (create-string 1000 #\a)) t)
((string>= (create-string 1000 #\a) (create-string 1000 #\b)) nil)
((string>= (create-string 1000 #\b) (create-string 1000 #\a)) t)

;;;
;;; ֐ (STRING<= string1 string2) --> quasi-boolean
;;;
($ap 2 "string<=" P.96)
((if (string<= "abcd" "abcd") t nil) t)
((if (string<= "abcd" "wxyz") t nil) t)
((if (string<= "abcd" "abcde") t nil) t)
((if (string<= "abcde" "abcd") t nil) nil)
;;;
($argc string<= 2 0 0)
($type string<= ($string) :target "a")
($type string<= ($string) "a" :target)
;;;
((string<= "" "") t)
((string<= "" "a") t)
((string<= "a" "") nil)
((string<= (create-string 1000 #\a) (create-string 1000 #\a)) t)
((string<= (create-string 1000 #\a) (create-string 1000 #\b)) t)
((string<= (create-string 1000 #\b) (create-string 1000 #\a)) nil)

;;;
;;; ֐ (CHAR-INDEX character string [start-position]) --> <object>
;;;
($ap 2 "char-index" P.97)
((char-index #\b "abcab") 1 eql)
((char-index #\B "abcab") nil)
((char-index #\b "abcab" 2) 4 eql)
((char-index #\d "abcab") nil)
((char-index #\a "abcab" 4) nil)
;;;
($argc char-index 2 1 0)
($type char-index ($character) :target "abc")
($type char-index ($string) #\a :target)
($type char-index ($integer) #\a "abc" :target)
;;;
((char-index #\space " ") 0 eql)
((char-index #\a "") nil)
((char-index #\a (create-string 1000 #\a)) 0 eql)
((char-index #\a (create-string 1000 #\b)) nil)
($error (char-index #\a "" 0) <program-error>)
($error (char-index #\a "" -1) <domain-error>)
($error (char-index #\a "" -1234567890) <domain-error>)
($error (char-index #\a "" 1234567890) <program-error>)
($error (char-index #\a "abc" 3) <program-error>)
($error (char-index #\a "abc" -1) <domain-error>)
($error (char-index #\a "abc" -1234567890) <domain-error>)
($error (char-index #\a "abc" 1234567890) <program-error>)

;;;
;;; ֐ (STRING-INDEX substring string [start-position]) --> <object>
;;;
($ap 2 "string-index" P.97)
((string-index "foo" "foobar") 0 eql)
((string-index "bar" "foobar") 3 eql)
((string-index "FOO" "foobar") nil)
((string-index "foo" "foobar" 1) nil)
((string-index "bar" "foobar" 1) 3 eql)
((string-index "foo" "") nil)
((string-index "" "foo") 0 eql)
;;;
($argc string-index 2 1 0)
($type string-index ($string) :target "abc")
($type string-index ($string) "abc" :target)
($type string-index ($integer) "abc" "abc" :target)
;;;
((string-index " " "a b") 1 eql)
((string-index "" "") 0 eql)
((string-index "abc" "abc") 0 eql)
((string-index "aaa" (create-string 1000 #\a)) 0 eql)
((string-index "aaa" (create-string 1000 #\b)) nil)
($error (string-index "abc" "" 0) <program-error>)
($error (string-index "abc" "" -1) <domain-error>)
($error (string-index "abc" "" -1234567890) <domain-error>)
($error (string-index "abc" "" 1234567890) <program-error>)
($error (string-index "a" "abc" 3) <program-error>)
($error (string-index "a" "abc" -1) <domain-error>)
($error (string-index "a" "abc" -1234567890) <domain-error>)
($error (string-index "a" "abc" 1234567890) <program-error>)

;;;
;;; ֐ (STRING-APPEND string*) --> <string>
;;;
($ap 2 "string-append" P.98)
((string-append "abc" "def") "abcdef" string=)
((string-append "abc" "abc") "abcabc" string=)
((string-append "abc" "") "abc" string=)
((string-append "" "abc") "abc" string=)
((string-append "abc" "" "def") "abcdef" string=)
;;;
($argc string-append 0 0 1)
($type string-append ($string) :target)
($type string-append ($string) :target "abc")
($type string-append ($string) "abc" :target)
($type string-append ($string) :target "abc" "def")
($type string-append ($string) "abc" "def" :target)
;;;
((string-append) "" string=)
((string-append "" "" "") "" string=)
((string-append "abc" "def" "ghi") "abcdefghi" string=)
((length (string-append (create-string 1000))) 1000 eql)
((length (string-append (create-string 1000) (create-string 1000))) 2000 eql)
