;;;------------------------------------------------------------
;;; ISLISP؃VXe
;;;
;;; ISLISPnISLISPKiɏĂ邩ǂ؂D
;;;
;;; ؃f[^̌`͈ȉ̂ꂩł邱ƁD
;;;
;;; (1) Ȏs
;;;     (form correct [pred-func-name])
;;; (2) G[
;;;     ($error form condition-class-name)
;;; (3) q֐`FbN
;;;     ($predicate func-name ok-types+)
;;; (4) ̌`FbN
;;;     ($argc func-name reqs opt rest)
;;; (5) ̌^`FbN(֐)
;;;     ($type func-name (ok-types+) args+)
;;; (6) ̌^`FbN(ꉉZq)
;;;     ($stype special-operator-name (ok-types*) args+)
;;; (7) PȂs(O)
;;;     ($eval form)
;;; (8) bZ[W\
;;;     ($echo message)
;;; (9) ؃VXeȊOŎgp
;;;     ($ap data*)
;;;------------------------------------------------------------

;;;------------------------------------------------------------
;;; ؃f[^t@CfBNg
;;;------------------------------------------------------------
(defconstant *tp-dir* "data/")

;;;------------------------------------------------------------
;;; ؃VXegpꎞt@CufBNg
;;;------------------------------------------------------------
(defconstant *tp-tmp-dir* "/tmp/")

;;;------------------------------------------------------------
;;; eXgf[^t@CŎgpϐA֐
;;;------------------------------------------------------------
(defglobal *tp-file-no* 0)
(defglobal *tp-example-file* nil)

;;;------------------------------------------------------------
;;; ؃VXegpꎞt@C
;;;------------------------------------------------------------
(defun tp-make-tmp-file ()
  (setq *tp-example-file* 
	(string-append 
	 *tp-tmp-dir* 
	 "islsp" 
	 (convert (setq *tp-file-no* (+ *tp-file-no* 1)) <string>))))
(defconstant *tp-tmp-input-file* (tp-make-tmp-file))
(defconstant *tp-tmp-output-file* (tp-make-tmp-file))
(defconstant *tp-tmp-error-file* (tp-make-tmp-file))

;;;------------------------------------------------------------
(defglobal *tp-ok* 0)
(defglobal *tp-ng* 0)

;;;------------------------------------------------------------
(defglobal *tp-verbose* nil)

;;;------------------------------------------------------------
;;; ؃f[^t@C̃Xg
;;;------------------------------------------------------------
(defconstant *tp-all-files* 
  '(
    "formeval.lsp"		;  4. Forms and Evaluation
    "pred.lsp"			;  5. Predicates
    "control.lsp"               ;  6. Control Structure
    "object.lsp"                ;  7. Objects
    "macro.lsp"                 ;  8. Macros
    "declare.lsp"		;  9. Declarations and Coercions
    "symbol.lsp"		; 10. Symbol class
    "number.lsp"		; 11. Number class
    "char.lsp"			; 12. Character class
    "list.lsp"			; 13. List class
    "array.lsp"			; 14. Arrays
    "vector.lsp"		; 15. Vectors
    "string.lsp"		; 16. String class
    "seq.lsp"			; 17. Sequence Functions
    "stream.lsp"                ; 18. Stream class
    "io.lsp"                    ; 19. Input and Output
    "files.lsp"                 ; 20. Files
    "cond.lsp"                  ; 21. Condition System
    "misc.lsp"			; 22. Miscellaneous
    ))

;;;------------------------------------------------------------
(with-open-output-file (str *tp-tmp-input-file*))
(with-open-output-file (str *tp-tmp-output-file*))
(with-open-output-file (str *tp-tmp-error-file*))

;;;------------------------------------------------------------
(defconstant *tp-arithmetic-error*
  (catch 'c-arithmetic-error
    (with-handler 
     (lambda (c) (throw 'c-arithmetic-error c))
     (div 1 0)))
  )

(defconstant *tp-domain-error*
  (catch 'c-domain-error
    (with-handler 
     (lambda (c) (throw 'c-domain-error c))
     (car 3)))
  )

(defconstant *tp-parse-error*
  (catch 'c-parse-error
    (with-handler 
     (lambda (c) (throw 'c-parse-error c))
     (parse-number "foo")))
  )

(defconstant *tp-simple-error*
  (catch 'c-simple-error
    (with-handler 
     (lambda (c) (throw 'c-simple-error c))
     (error "err")))
  )

(defconstant *tp-stream-error*
  (catch 'c-stream-error
    (with-handler 
     (lambda (c) (throw 'c-stream-error c))
     (with-open-io-file 
      (estr *tp-tmp-error-file*)
      (while t (read estr)))))
  )

(defconstant *tp-undefined-entity*
  (catch 'c-undefined-entity
    (with-handler 
     (lambda (c) (throw 'c-undefined-entity c))
     (function %%undef-func%%)))
  )

(defclass *tp-user-class* () ())
(defconstant *tp-instance* (create (class *tp-user-class*)))

;;;------------------------------------------------------------
;;; f[^^̃Xg
;;;
;;;  ((^Cv . ^CvɑΉLISPIuWFNg) ...)
;;;------------------------------------------------------------
(defglobal *tp-all-types* 
  (list
   (cons '$array		(create-array '(1 2 3) nil))
   (cons '$vector		(vector 1 2 3))
   ;;(cons '$string		(string-append *tp-tmp-dir* "abcd"))
   (cons '$string		(string-append *tp-tmp-dir* "islsp0"))
   (cons '$class		(class <object>))
   (cons '$character		#\x)
   (cons '$function		(function +))
   (cons '$generic		(function create))
   (cons '$symbol		''aBcD)
   (cons '$cons			(list 'quote (cons 1 2)))
   (cons '$null			''nil)
   (cons '$float		1.234)
   (cons '$integer		123)
   (cons '$arithmetic-error	*tp-arithmetic-error*)
   (cons '$domain-error		*tp-domain-error*)
   (cons '$parse-error		*tp-parse-error*)
   (cons '$simple-error		*tp-simple-error*)
   (cons '$stream-error		*tp-stream-error*)
   (cons '$undefined-entity	*tp-undefined-entity*)
   (cons '$instance		*tp-instance*)
   (cons '$file-input-stream  
	 (with-open-input-file 
	  (istr *tp-tmp-input-file*) istr))
   (cons '$file-output-stream 
	 (with-open-output-file 
	  (ostr *tp-tmp-output-file*) ostr))
   (cons '$string-input-stream	(create-string-input-stream "hello"))
   (cons '$string-output-stream	(create-string-output-stream))
   ))

;;;------------------------------------------------------------
(defglobal *tp-all-types-length* (length *tp-all-types*))

(defun tp-check-all-types ()
  (for ((i 0 (+ i 1)))
       ((= i *tp-all-types-length*))
       (case (car (elt *tp-all-types* i))
	     (($array)
	      (setf (cdr (elt *tp-all-types* i))
		    (create-array '(1 2 3) nil)))
	     (($vector)
	      (setf (cdr (elt *tp-all-types* i))
		    (vector 1 2 3)))
	     (($string)
	      (setf (cdr (elt *tp-all-types* i))
		    (string-append *tp-tmp-dir* "islsp0")))
	     (($cons)
	      (setf (cdr (elt *tp-all-types* i))
		    (list 'quote (cons 1 2)))))
       ))

;;;------------------------------------------------------------
(defun tp-output (format-string &rest format-args)
  (format (standard-output) "> ")
  (apply #'format (standard-output) format-string format-args))

(defun tp-data-error (errmsg data)
  (tp-output "TP data error [~A]: ~S~%" errmsg data)
  (throw 'tp-data-error nil))

;;;------------------------------------------------------------
(defmacro tp-incf (x)
  `(setq ,x (+ ,x 1)))

(defun tp-ok-incf ()
  (tp-incf *tp-ok*))

(defun tp-ng-incf ()
  (tp-incf *tp-ng*))

;;;------------------------------------------------------------
(defun tp-ok (form ret)
  (cond
   ((consp ret)
    ;; I
    (if *tp-verbose*
	(tp-output "OK: ~S -> ~S~%"
		   form (car ret))))
   (t
    ;; ُI
    (if *tp-verbose*
	(tp-output "OK: ~S -> #<Error> ~S~%"
		   form ret))))
  (tp-ok-incf)
  )

(defun tp-ng (form ret correct error-flag)
  (cond
   ((consp ret)
    (if error-flag
	;; ُIȂ΂ȂȂ̂ɐIĂ܂
	(tp-output "NG: ~S -> ~S [#<Error> ~S]~%"
		   form (car ret) correct)
      ;; IʂႤ
      (tp-output "NG: ~S -> ~S [~S]~%"
		 form (car ret) correct)))
   (t
    (if error-flag
	;; ُIʂႤ
	(tp-output "NG: ~S -> #<Error> ~S [#<Error> ~S]~%"
		   form (class-of ret) correct)
      ;; IȂ΂ȂȂ̂ɈُIĂ܂
      (tp-output "NG: ~S -> #<Error> ~S [~S]~%"
		 form (class-of ret) correct))))
  (tp-ng-incf)
  )

;;;------------------------------------------------------------
(defconstant *tp-condition-class-name*
  '(
    <serious-condition>
    <error>
    <arithmetic-error>
    <division-by-zero>
    <floating-point-overflow>
    <floating-point-underflow>
    <control-error>
    <parse-error>
    <program-error>
    <domain-error>
    <undefined-entity>
    <unbound-variable>
    <undefined-function>
    <simple-error>
    <stream-error>
    <end-of-stream>
    <storage-exhausted>
    ))

(defun tp-check-condition-class-name (class-name)
  (member class-name *tp-condition-class-name*))

;;;------------------------------------------------------------
(defconstant *tp-defining-operator*
  '(
    defun 
    defmacro 
    defglobal 
    defconstant
    defdynamic
    defclass
    defgeneric
    defmethod
    ))

(defun tp-toplevel-p-progn (form)
  (block nil
    (for ((l form (cdr l)))
	 ((not (consp l)))
	 (if (tp-toplevel-p (car l)) (return-from nil t)))))

(defun tp-toplevel-p (form)
  (and (consp form)
       (or (member (car form) *tp-defining-operator*)
	   (and (eq (car form) 'progn)
		(consp (cdr form))
		(tp-toplevel-p-progn (cdr form))))))

;;;------------------------------------------------------------
(defglobal *tp-error-flag* nil)
(defun tp-error-handler (condition)
  (setq *tp-error-flag* t)
  (throw 'tp-error condition))

(defmacro tp-eval-form (&rest form)
  `(catch 'tp-error
     (with-handler #'tp-error-handler ,@form)))

;;;------------------------------------------------------------
;;; form]D
;;; 
;;; IȂ΁C]ꂽlXgɂĕԂD
;;; ُIȂ΁CRfBVIuWFNgԂD
;;;------------------------------------------------------------
(defun tp-eval (form)
  (let ((ret nil))
    (if (tp-toplevel-p form)
	(setq form `(eval ',form)))
    (setq ret (eval (list 'tp-eval-form form)))
    (if *tp-error-flag*
	(setq *tp-error-flag* nil)
      (setq ret (list ret)))
    ret))

;;;------------------------------------------------------------
;;; (1) Ȏs
;;;
;;;     (form correct [pred-func-name])
;;;
;;;      form
;;;        ]鎮
;;;
;;;      correct
;;;        ]ꂽƂ̒l
;;;
;;;      pred-func-name
;;;        ]ꂽlƎۂɕ]ꂽlƂr֐
;;;        (w肪Ȃꍇeqp)
;;;------------------------------------------------------------
(defun tp-$normal-prim (form correct pred-func)
  (let ((ret nil))
    (setq ret (tp-eval form))
    (if (and (consp ret) (funcall pred-func (car ret) correct))
	;; ICʂ -> OK
	(tp-ok form ret)
      ;; IʂႤ or ُI -> NG
      (tp-ng form ret correct nil))
    ))

(defun tp-$normal (data)
  (if (and (/= (length data) 2) (/= (length data) 3))
      (tp-data-error "Syntax error" data))
  (let ((form (elt data 0))
	(correct (elt data 1))
	(pred-func-name 'eq)
	(pred-func nil))
    (if (= (length data) 3)
	(setq pred-func-name (elt data 2)))
    (setq pred-func (tp-eval `(function ,pred-func-name)))
    (if (and (consp pred-func) (functionp (car pred-func)))
	(setq pred-func (car pred-func))
      (tp-data-error "Invalid predicate function" data))
    (tp-$normal-prim form correct pred-func)
    (tp-check-all-types)
    ))

;;;------------------------------------------------------------
;;; (2) G[
;;;
;;;     ($error form condition-class-name)
;;;
;;;      form
;;;        ]鎮
;;;
;;;      condition-class-name
;;;        ׂRfBṼNX
;;;------------------------------------------------------------
(defun tp-$error-prim (form condition-class-name)
  (let ((ret nil)
	(condition-class nil))
    (setq ret (tp-eval form))
    ;; RfBVNXݒ
    (setq condition-class (tp-eval `(class ,condition-class-name)))
    (if (consp condition-class)
	(setq condition-class (car condition-class))
      (tp-data-error "Invalid condition class"
		     (list '$error form condition-class-name)))
    (if (instancep ret condition-class)
	;; ُICʂ -> OK
	(tp-ok form condition-class)
      ;; ُIʂႤ or I -> NG
      (tp-ng form ret condition-class t))
    ))

(defun tp-$error (data)
  (if (/= (length data) 3)
      (tp-data-error "Syntax error" data))
  (let ((form (elt data 1))
	(condition-class-name (elt data 2)))
    (tp-$error-prim form condition-class-name)
    (tp-check-all-types)
    ))
    
;;;------------------------------------------------------------
;;; (3) q֐`FbN
;;;
;;;     ($predicate func-name ok-types+)
;;;
;;;      func-name
;;;        q֐
;;;
;;;      ok-types
;;;        ʂ^ƂȂ^̖O
;;;        (*tp-all-types* Œ`Ă)
;;;------------------------------------------------------------
(defun tp-$predicate-prim (func-name ok-types)
  (let ((type nil))
    (for ((types *tp-all-types* (cdr types)))
	 ((not (consp types)) nil)
	 (setq type (car types))
	 (tp-$normal-prim 
	  (list func-name (cdr type))
	  (not (null (member (car type) ok-types)))
	  #'eq)
	 (tp-check-all-types)
	 )
    ))

(defun tp-$predicate (data)
  (if (< (length data) 3)
      (tp-error "Syntax error" data))
  (let ((func-name (elt data 1))
	(ok-types (cdr (cdr data))))
    (tp-$predicate-prim func-name ok-types)))

;;;------------------------------------------------------------
;;; (4) ̌`FbN
;;;
;;;     ($argc func-name reqs opt rest)
;;;
;;;      func-name
;;;        ֐/ꉉZq
;;;
;;;      reqs
;;;        K{̌
;;;
;;;      opt
;;;        ť
;;;
;;;      rest
;;;        ]邩ǂ
;;;        (0: Ȃ, 1: )
;;;------------------------------------------------------------
(defun tp-correct-args (form)
  (let ((ret nil))
    (setq ret (tp-eval form))
    (cond
     ((eq (class-of ret) (class <program-error>))
      ;; ̌ĂƔ肳ꂽ -> NG
      (tp-output "NG: ~S -> ~A [~A]~%"
		 form
		 "#<Wrong number of arguments>"
		 "#<Correct number of arguments]")
      (tp-ng-incf))
     ;; for OpenLisp bug
     ((eq (class-of ret) '<program-error>)
      ;; ̌ĂƔ肳ꂽ -> NG
      (tp-output "NG: ~S -> ~A [~A]~%"
		 form
		 "#<Wrong number of arguments>"
		 "#<Correct number of arguments]")
      (tp-ng-incf))
     (t
      ;; ̌Ɣ肳ꂽ -> OK
      (if *tp-verbose*
	  (tp-output "OK: ~S -> ~A~%"
		     form
		     "#<Correct number of arguments]"))
      (tp-ok-incf)))
    (tp-check-all-types)
    ))

(defun tp-wrong-args (form)
  (let ((ret nil))
    (setq ret (tp-eval form))
    (cond
     ;; ̌ĂƔ肳ꂽ -> OK
     ((eq (class-of ret) (class <program-error>))
      (if *tp-verbose*
	  (tp-output "OK: ~S -> ~A~%"
		     form
		     "#<Wrong number of arguments>"))
      (tp-ok-incf))
     ;; for OpenLisp bug
     ;; ̌ĂƔ肳ꂽ -> OK
     ((eq (class-of ret) '<program-error>)
      (if *tp-verbose*
	  (tp-output "OK: ~S -> ~A~%"
		     form
		     "#<Wrong number of arguments>"))
      (tp-ok-incf))
     (t
      ;; ̌Ɣ肳ꂽ -> NG
      (tp-output "NG: ~S -> ~A [~A]~%"
		 form
		 "#<Correct number of arguments]"
		 "#<Wrong number of arguments>")
      (tp-ng-incf)))
    (tp-check-all-types)
    ))

(defun tp-$argc-prim (fname reqs opt rest)
  (let ((form nil)
	(arg 'nil))
    (setq form (list fname))
    (if (member fname '(setq setf defconstant defglobal))
	(setq arg 'nilnil))
    ;; K{菭Ȃꍇ -> ُI
    (for ((i 0 (+ i 1)))
	 ((<= reqs i))
	 (tp-wrong-args form)
	 (setq form (append form (list arg))))
    ;; K{Ɠꍇ -> I
    (tp-correct-args form)
    (setq form (append form (list arg)))
    (cond ((/= opt 0)
	   ;; tꍇ -> I
	   (for ((i 0 (+ i 1)))
		((<= opt i) nil)
		(tp-correct-args form)
		(setq form (append form (list arg))))
	   ;; t葽ꍇ -> ُI
	   (tp-wrong-args form))
	  ((/= rest 0)
	   ;; ]ꍇ -> I
	   (tp-correct-args form)
	   (setq form (append form (list arg)))
	   (tp-correct-args form))
	  (t
	   ;; K{葽ꍇ -> ُI
	   (tp-wrong-args form)))
    ))

(defun tp-$argc (data)
  (if (/= (length data) 5)
      (tp-data-error "Syntax error" data))
  (let ((fname (elt data 1))
	(reqs  (elt data 2))
	(opt   (elt data 3))
	(rest  (elt data 4)))
    (tp-$argc-prim fname reqs opt rest)
    ))
  
;;;------------------------------------------------------------
;;; (5) ̌^`FbN(֐)
;;;
;;;     ($type func-name (ok-types*) args+)
;;;
;;;      func-name
;;;        ֐
;;;
;;;      ok-types
;;;        G[Ȃ^̖O
;;;        (*tp-all-types* Œ`Ă)
;;;
;;;      args
;;;        ֐ɓnD
;;;        G[Ȃw肵C1ӏ :target w肷D
;;;        :target w肵ɑ΂Č^`FbNsȂD
;;;------------------------------------------------------------
(defun tp-ng-type-p (form pos ret func-p)
  (and (eq (class-of ret) (class <domain-error>))
       (equal (domain-error-object ret) 
	      (if func-p (eval (elt form pos))
		(elt form pos)))
       ))

(defun tp-ok-type-string (pos)
  (string-append
   "#<Correct type of argument #" (convert pos <string>) ">"))

(defun tp-ng-type-string (pos)
  (string-append
   "#<Wrong type of argument #" (convert pos <string>) ">"))

(defun tp-ok-type-prim (form pos func-p)
  (let ((ret (tp-eval form)))
    (cond
     ((tp-ng-type-p form pos ret func-p)
      (tp-output "NG: ~S -> ~A [~A]~%"
		 form (tp-ng-type-string pos) (tp-ok-type-string pos))
      (tp-ng-incf))
     (t
      (if *tp-verbose*
	  (tp-output "OK: ~S -> ~A~%"
		     form (tp-ok-type-string pos)))
      (tp-ok-incf))
     (tp-check-all-types)
     )))

(defun tp-ok-type (form pos)
  (tp-ok-type-prim form pos t))

(defun tp-ng-type-prim (form pos func-p)
  (let ((ret (tp-eval form)))
    (cond
     ((tp-ng-type-p form pos ret func-p)
      (if *tp-verbose*
	  (tp-output "OK: ~S -> ~A~%"
		     form (tp-ng-type-string pos)))
      (tp-ok-incf))
     (t
      (tp-output "NG: ~S -> ~A [~A]~%"
		 form (tp-ok-type-string pos) (tp-ng-type-string pos))
      (tp-ng-incf))
     (tp-check-all-types)
     )))

(defun tp-ng-type (form pos)
  (tp-ng-type-prim form pos t))

(defun tp-$type-prim (func-name ok-types args)
  (let ((args2 args)
	(pos 0)
	(type nil)
	(form nil))
    ;; :targeẗʒuT
    (while (not (eq (car args2) ':target))
      (setq pos (+ pos 1))
      (setq args2 (cdr args2)))
    ;;
    (for ((types *tp-all-types* (cdr types)))
	 ((not (consp types)) nil)
	 (setq type (car types))
	 (setf (elt args pos) (cdr type))
	 (setq form (cons func-name args))
	 (if (member (car type) ok-types)
	     (tp-ok-type form (+ pos 1))
	   (tp-ng-type form (+ pos 1))))
    ))

(defun tp-$type (data)
  (if (< (length data) 4)
      (tp-error "Syntax error" data))
  (let ((func-name (elt data 1))
	(ok-types  (elt data 2))
	(args      (cdr (cdr (cdr data)))))
    (tp-$type-prim func-name ok-types args)))

;;;------------------------------------------------------------
;;; (6) ̌^`FbN(ꉉZq)
;;;
;;;     ($stype special-operator-name (ok-types*) args)
;;;
;;;      special-operator-name
;;;        ꉉZq
;;;
;;;      ok-types
;;;        G[Ȃ^̖O
;;;        (*tp-all-types* Œ`Ă)
;;;
;;;      args
;;;        ꉉZqɓnD
;;;        G[Ȃw肵C1ӏ :target w肷D
;;;        :target w肵ɑ΂Č^`FbNsȂD
;;;------------------------------------------------------------
(defun tp-create-stype-args (args)
  (cond
   ;;
   ((consp args)
    (if (eq (car args) 'quote)
	(car (cdr args))
      (cons (tp-create-stype-args (car args))
	    (tp-create-stype-args (cdr args)))))
   ;;
   (t
    args)))

(defun tp-ok-stype (form pos)
  (tp-ok-type-prim form pos nil))

(defun tp-ng-stype (form pos)
  (tp-ng-type-prim form pos nil))

(defun tp-$stype-prim (special-operator-name ok-types args)
  (let ((args2 args)
	(pos 0)
	(type nil)
	(form nil))
    ;; :targeẗʒuT
    (while (not (eq (car args2) ':target))
      (setq pos (+ pos 1))
      (setq args2 (cdr args2)))
    ;;
    (for ((types *tp-all-types* (cdr types)))
	 ((not (consp types)) nil)
	 (setq type (car types))
	 (setf (elt args pos) (cdr type))
	 (setq form (cons special-operator-name (tp-create-stype-args args)))
	 (if (member (car type) ok-types)
	     (tp-ok-stype form (+ pos 1))
	   (tp-ng-stype form (+ pos 1))))
    ))

(defun tp-$stype (data)
  (if (< (length data) 4)
      (tp-error "Syntax error" data))
  (let ((special-operator-name (elt data 1))
	(ok-types  (elt data 2))
	(args      (cdr (cdr (cdr data)))))
    (tp-$stype-prim special-operator-name ok-types args)))

;;;------------------------------------------------------------
;;; (7) PȂs(O)
;;;
;;;     ($eval form)
;;;
;;;      form
;;;        ]鎮
;;;------------------------------------------------------------
(defun tp-$eval-prim (form)
  (tp-eval form))

(defun tp-$eval (data)
  (if (/= (length data) 2)
      (tp-error "Syntax error" data))
  (let ((form (elt data 1)))
    (tp-$eval-prim form)
    (tp-check-all-types)
    ))

;;;------------------------------------------------------------
;;; (8) bZ[W\
;;;
;;;     ($echo message)
;;;
;;;      message
;;;        \郁bZ[W
;;;------------------------------------------------------------
(defun tp-$echo-prim (message)
  (tp-output "~A~%" message))

(defun tp-$echo (data)
  (if (/= (length data) 2)
      (tp-error "Syntax error" data))
  (let ((message (elt data 1)))
    (tp-$echo-prim message)
    (tp-check-all-types)
    ))

;;;------------------------------------------------------------
(defun tp-initialize ()
  (setq *tp-ok* 0)
  (setq *tp-ng* 0))

(defun tp-main (file options)
  (setq *tp-verbose* (member 'verbose options))
  (with-standard-input 
   (create-string-input-stream "this is a string")
   (with-open-input-file 
    (stream file)
    (for ((data (read stream 'nil 'eof) (read stream 'nil 'eof)))
	 ((eq data 'eof))
	 (case (car data)
	       (($error)     (tp-$error data))		; (2)
	       (($predicate) (tp-$predicate data))	; (3)
	       (($argc)      (tp-$argc data))		; (4)
	       (($type)      (tp-$type data))		; (5)
	       (($stype)     (tp-$stype data))		; (6)
	       (($eval)      (tp-$eval data))		; (7)
	       (($echo)      (tp-$echo data))		; (8)
	       (($ap))					; (9)
	       (t            (tp-$normal data)))	; (1)
	 )
    )))

(defun tp-output-result ()
  (tp-output
   "TP Result: OK = ~S, NG = ~S~%" *tp-ok* *tp-ng*))

;;;------------------------------------------------------------
;;; ؃vOs(t@Cw)
;;;
;;;   (tp file options*)
;;;------------------------------------------------------------
(defun tp (file &rest options)
  (tp-initialize)
  (tp-main file options)
  (tp-output-result)
  (= *tp-ng* 0))

;;;------------------------------------------------------------
;;; ؃vOs
;;;
;;;   *tp-all-files* Œ`ĂSẴt@Cɑ΂
;;;   ؃vOsD
;;;
;;;   (tp-all options*)
;;;------------------------------------------------------------
(defun tp-all (&rest options)
  (tp-initialize)
  (let ((file nil))
    (for ((files *tp-all-files* (cdr files)))
	 ((not (consp files)))
	 (setq file (string-append *tp-dir* (car files)))
	 (tp-output "TP File : ~A~%" file)
	 (tp-main file options)))
  (tp-output-result)
  (= *tp-ng* 0))

